# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dag_edge import DagEdge
from .dag_node import DagNode


class SyncDag(UniversalBaseModel):
    """
    Schema for a sync DAG definition.

    The DAG structure as the UI displays it.

    This means that for each entity, there is a node that is the producer and a node that is the
    consumer. These are connected by an edge: producer -edge-> entity -edge-> consumer

    Sources, transformers, and destinations are also nodes, but they do not have an
    entity_definition_id.

    Sources are producers by default, and destinations are consumers by default.
    Transformers are both producers and consumers.
    """

    name: str
    description: typing.Optional[str] = None
    sync_id: str
    id: str
    organization_id: str
    created_by_email: typing.Optional[str] = None
    modified_by_email: typing.Optional[str] = None
    nodes: typing.List[DagNode]
    edges: typing.List[DagEdge]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
