#!/usr/bin/env python

'''
the following tables were generated with the following code. the html file was
generated by running pdftohtml on the lfsr_table.pdf provided in the git repo:
====

def print_poly_entry(bitsize, poly):
    print '    %d: polygen(%s),' % (bitsize, ', '.join(map(str, poly)))

def print_poly(poly_name, poly_dict):
    print '%s = {' % poly_name
    entries = poly_dict.keys()
    entries.sort()

    for entry in entries:
        print_poly_entry(entry, poly_dict[entry])

    print '}'

if __name__ == '__main__':
    fp = open('lfsr_tables.html')
    data = fp.read()
    fp.close()

    data = data.replace('&#160;', ' ')
    data = data.replace('\n', '')
    data = data.replace('<br/>', ' ')
    tape = data.split(' ')

    state_read = 0
    state_parse_bitsize = 1
    state_parse_poly = 2
    state_end_poly = 3

    tap2_polys = dict()
    tap4_polys = dict()
    all_polys = dict()

    current_bitsize = None
    current_poly = list()
    element = None
    state = state_read

    while len(tape) > 0:
        if state == state_read:
            if tape[0].endswith(','):
                state = state_parse_poly
            else:
                element = tape.pop(0)
                state = state_parse_bitsize
        elif state == state_parse_bitsize:
            current_bitsize = int(element)
            state = state_parse_poly
        elif state == state_parse_poly:
            element = tape.pop(0)

            if not element.endswith(','):
                state = state_end_poly
            else:
                element = element.rstrip(',')

            current_poly.append(int(element))
        elif state == state_end_poly:
            if len(current_poly) == 2:
                tap2_polys[current_bitsize] = current_poly
            elif len(current_poly) == 4:
                tap4_polys[current_bitsize] = current_poly

            if not current_bitsize in all_polys:
                all_polys[current_bitsize] = current_poly

            current_poly = list()
            state = state_read

    print_poly('tap2_polys', tap2_polys)
    print ''
    print_poly('tap4_polys', tap4_polys)
    print ''
    print_poly('all_polys', all_polys)
'''

def polygen(*args):
    '''Create a polynomial value.'''
    
    value = 0
    
    for bit in args:
        value |= 1 << (bit - 1)

    return value

tap2_polys = {
    2: polygen(2, 1),
    3: polygen(3, 2),
    4: polygen(4, 3),
    5: polygen(5, 3),
    6: polygen(6, 5),
    7: polygen(7, 6),
    9: polygen(9, 5),
    10: polygen(10, 7),
    11: polygen(11, 9),
    15: polygen(15, 14),
    17: polygen(17, 14),
    18: polygen(18, 11),
    20: polygen(20, 17),
    21: polygen(21, 19),
    22: polygen(22, 21),
    23: polygen(23, 18),
    25: polygen(25, 22),
    28: polygen(28, 25),
    29: polygen(29, 27),
    31: polygen(31, 28),
    33: polygen(33, 20),
    35: polygen(35, 33),
    36: polygen(36, 25),
    39: polygen(39, 35),
    41: polygen(41, 38),
    47: polygen(47, 42),
    49: polygen(49, 40),
    52: polygen(52, 49),
    55: polygen(55, 31),
    57: polygen(57, 50),
    58: polygen(58, 39),
    60: polygen(60, 59),
    63: polygen(63, 62),
    65: polygen(65, 47),
    68: polygen(68, 59),
    71: polygen(71, 65),
    73: polygen(73, 48),
    79: polygen(79, 70),
    81: polygen(81, 77),
    84: polygen(84, 71),
    87: polygen(87, 74),
    89: polygen(89, 51),
    93: polygen(93, 91),
    94: polygen(94, 73),
    95: polygen(95, 84),
    97: polygen(97, 91),
    98: polygen(98, 87),
    100: polygen(100, 63),
    103: polygen(103, 94),
    105: polygen(105, 89),
    106: polygen(106, 91),
    108: polygen(108, 77),
    111: polygen(111, 101),
    113: polygen(113, 104),
    118: polygen(118, 85),
    119: polygen(119, 111),
    121: polygen(121, 103),
    123: polygen(123, 121),
    124: polygen(124, 87),
    127: polygen(127, 126),
    129: polygen(129, 124),
    130: polygen(130, 127),
    132: polygen(132, 103),
    134: polygen(134, 77),
    135: polygen(135, 124),
    137: polygen(137, 116),
    140: polygen(140, 111),
    142: polygen(142, 121),
    145: polygen(145, 93),
    148: polygen(148, 121),
    150: polygen(150, 97),
    151: polygen(151, 148),
    153: polygen(153, 152),
    159: polygen(159, 128),
    161: polygen(161, 143),
    167: polygen(167, 161),
    169: polygen(169, 135),
    170: polygen(170, 147),
    172: polygen(172, 165),
    174: polygen(174, 161),
    175: polygen(175, 169),
    177: polygen(177, 169),
    178: polygen(178, 91),
    183: polygen(183, 127),
    185: polygen(185, 161),
    191: polygen(191, 182),
    193: polygen(193, 178),
    194: polygen(194, 107),
    198: polygen(198, 133),
    199: polygen(199, 165),
    201: polygen(201, 187),
    202: polygen(202, 147),
    207: polygen(207, 164),
    209: polygen(209, 203),
    212: polygen(212, 107),
    215: polygen(215, 192),
    217: polygen(217, 172),
    218: polygen(218, 207),
    223: polygen(223, 190),
    225: polygen(225, 193),
    231: polygen(231, 205),
    233: polygen(233, 159),
    234: polygen(234, 203),
    236: polygen(236, 231),
    239: polygen(239, 203),
    241: polygen(241, 171),
    247: polygen(247, 165),
    249: polygen(249, 163),
    250: polygen(250, 147),
    252: polygen(252, 185),
    255: polygen(255, 203),
    257: polygen(257, 245),
    258: polygen(258, 175),
    263: polygen(263, 170),
    265: polygen(265, 223),
    266: polygen(266, 219),
    268: polygen(268, 243),
    270: polygen(270, 217),
    271: polygen(271, 213),
    273: polygen(273, 250),
    274: polygen(274, 207),
    278: polygen(278, 273),
    279: polygen(279, 274),
    281: polygen(281, 188),
    282: polygen(282, 247),
    284: polygen(284, 165),
    286: polygen(286, 217),
    287: polygen(287, 216),
    289: polygen(289, 268),
    292: polygen(292, 195),
    294: polygen(294, 233),
    295: polygen(295, 247),
    297: polygen(297, 292),
    300: polygen(300, 293),
    302: polygen(302, 261),
    305: polygen(305, 203),
    313: polygen(313, 234),
    314: polygen(314, 299),
    316: polygen(316, 181),
    319: polygen(319, 283),
    321: polygen(321, 290),
    322: polygen(322, 255),
    327: polygen(327, 293),
    329: polygen(329, 279),
    332: polygen(332, 209),
    333: polygen(333, 331),
    337: polygen(337, 282),
    342: polygen(342, 217),
    343: polygen(343, 268),
    345: polygen(345, 323),
    350: polygen(350, 297),
    351: polygen(351, 317),
    353: polygen(353, 284),
    359: polygen(359, 291),
    362: polygen(362, 299),
    364: polygen(364, 297),
    366: polygen(366, 337),
    367: polygen(367, 346),
    369: polygen(369, 278),
    370: polygen(370, 231),
    375: polygen(375, 359),
    377: polygen(377, 336),
    378: polygen(378, 335),
    380: polygen(380, 333),
    382: polygen(382, 301),
    383: polygen(383, 293),
    385: polygen(385, 379),
    386: polygen(386, 303),
    390: polygen(390, 301),
    391: polygen(391, 363),
    393: polygen(393, 386),
    394: polygen(394, 259),
    396: polygen(396, 371),
    399: polygen(399, 313),
    401: polygen(401, 249),
    404: polygen(404, 215),
    406: polygen(406, 249),
    407: polygen(407, 336),
    409: polygen(409, 322),
    412: polygen(412, 265),
    415: polygen(415, 313),
    417: polygen(417, 310),
    422: polygen(422, 273),
    423: polygen(423, 398),
    425: polygen(425, 413),
    428: polygen(428, 323),
    431: polygen(431, 311),
    433: polygen(433, 400),
    436: polygen(436, 271),
    438: polygen(438, 373),
    439: polygen(439, 390),
    441: polygen(441, 410),
    446: polygen(446, 341),
    447: polygen(447, 374),
    449: polygen(449, 315),
    450: polygen(450, 371),
    455: polygen(455, 417),
    457: polygen(457, 441),
    458: polygen(458, 255),
    460: polygen(460, 399),
    462: polygen(462, 389),
    463: polygen(463, 370),
    465: polygen(465, 406),
    470: polygen(470, 321),
    471: polygen(471, 470),
    474: polygen(474, 283),
    476: polygen(476, 461),
    478: polygen(478, 357),
    479: polygen(479, 375),
    481: polygen(481, 343),
    484: polygen(484, 379),
    487: polygen(487, 393),
    489: polygen(489, 406),
    490: polygen(490, 271),
    494: polygen(494, 357),
    495: polygen(495, 419),
    497: polygen(497, 419),
    503: polygen(503, 500),
    505: polygen(505, 349),
    506: polygen(506, 411),
    508: polygen(508, 399),
    511: polygen(511, 501),
    513: polygen(513, 428),
    518: polygen(518, 485),
    519: polygen(519, 440),
    521: polygen(521, 489),
    524: polygen(524, 357),
    527: polygen(527, 480),
    529: polygen(529, 487),
    532: polygen(532, 531),
    537: polygen(537, 443),
    540: polygen(540, 361),
    543: polygen(543, 527),
    545: polygen(545, 423),
    550: polygen(550, 357),
    551: polygen(551, 416),
    553: polygen(553, 514),
    556: polygen(556, 403),
    559: polygen(559, 525),
    561: polygen(561, 490),
    564: polygen(564, 401),
    566: polygen(566, 413),
    567: polygen(567, 424),
    569: polygen(569, 492),
    570: polygen(570, 503),
    574: polygen(574, 561),
    575: polygen(575, 429),
    577: polygen(577, 552),
    582: polygen(582, 497),
    583: polygen(583, 453),
    585: polygen(585, 464),
    588: polygen(588, 437),
    590: polygen(590, 497),
    593: polygen(593, 507),
    594: polygen(594, 575),
    599: polygen(599, 569),
    601: polygen(601, 400),
    607: polygen(607, 502),
    609: polygen(609, 578),
    610: polygen(610, 483),
    615: polygen(615, 404),
    617: polygen(617, 417),
    622: polygen(622, 325),
    623: polygen(623, 555),
    625: polygen(625, 492),
    628: polygen(628, 405),
    631: polygen(631, 324),
    633: polygen(633, 532),
    634: polygen(634, 319),
    639: polygen(639, 623),
    641: polygen(641, 630),
    642: polygen(642, 523),
    646: polygen(646, 397),
    647: polygen(647, 642),
    649: polygen(649, 612),
    650: polygen(650, 647),
    652: polygen(652, 559),
    655: polygen(655, 567),
    657: polygen(657, 619),
    658: polygen(658, 603),
    662: polygen(662, 365),
    663: polygen(663, 406),
    665: polygen(665, 632),
    670: polygen(670, 517),
    671: polygen(671, 656),
    673: polygen(673, 645),
    676: polygen(676, 435),
    679: polygen(679, 613),
    686: polygen(686, 489),
    687: polygen(687, 674),
    689: polygen(689, 675),
    692: polygen(692, 393),
    695: polygen(695, 483),
    697: polygen(697, 430),
    698: polygen(698, 483),
    702: polygen(702, 665),
    705: polygen(705, 686),
    708: polygen(708, 421),
    711: polygen(711, 619),
    713: polygen(713, 672),
    714: polygen(714, 691),
    716: polygen(716, 533),
    719: polygen(719, 569),
    721: polygen(721, 712),
    722: polygen(722, 491),
    726: polygen(726, 721),
    727: polygen(727, 547),
    729: polygen(729, 671),
    730: polygen(730, 583),
    735: polygen(735, 691),
    737: polygen(737, 732),
    738: polygen(738, 391),
    740: polygen(740, 587),
    743: polygen(743, 653),
    745: polygen(745, 487),
    746: polygen(746, 395),
    751: polygen(751, 733),
    753: polygen(753, 595),
    754: polygen(754, 735),
    756: polygen(756, 407),
    759: polygen(759, 661),
    761: polygen(761, 758),
    762: polygen(762, 679),
    767: polygen(767, 599),
    769: polygen(769, 649),
    772: polygen(772, 765),
    774: polygen(774, 589),
    775: polygen(775, 408),
    777: polygen(777, 748),
    778: polygen(778, 403),
    782: polygen(782, 453),
    783: polygen(783, 715),
    785: polygen(785, 693),
}
'''Mapping of possible 2-tap polynomials.'''

tap4_polys = {
    5: polygen(5, 4, 3, 2),
    6: polygen(6, 5, 3, 2),
    7: polygen(7, 6, 5, 4),
    8: polygen(8, 6, 5, 4),
    9: polygen(9, 8, 6, 5),
    10: polygen(10, 9, 7, 6),
    11: polygen(11, 10, 9, 7),
    12: polygen(12, 11, 8, 6),
    13: polygen(13, 12, 10, 9),
    14: polygen(14, 13, 11, 9),
    15: polygen(15, 14, 13, 11),
    16: polygen(16, 14, 13, 11),
    17: polygen(17, 16, 15, 14),
    18: polygen(18, 17, 16, 13),
    19: polygen(19, 18, 17, 14),
    20: polygen(20, 19, 16, 14),
    21: polygen(21, 20, 19, 16),
    22: polygen(22, 19, 18, 17),
    23: polygen(23, 22, 20, 18),
    24: polygen(24, 23, 21, 20),
    25: polygen(25, 24, 23, 22),
    26: polygen(26, 25, 24, 20),
    27: polygen(27, 26, 25, 22),
    28: polygen(28, 27, 24, 22),
    29: polygen(29, 28, 27, 25),
    30: polygen(30, 29, 26, 24),
    31: polygen(31, 30, 29, 28),
    32: polygen(32, 30, 26, 25),
    33: polygen(33, 32, 29, 27),
    34: polygen(34, 31, 30, 26),
    35: polygen(35, 34, 28, 27),
    36: polygen(36, 35, 29, 28),
    37: polygen(37, 36, 33, 31),
    38: polygen(38, 37, 33, 32),
    39: polygen(39, 38, 35, 32),
    40: polygen(40, 37, 36, 35),
    41: polygen(41, 40, 39, 38),
    42: polygen(42, 40, 37, 35),
    43: polygen(43, 42, 38, 37),
    44: polygen(44, 42, 39, 38),
    45: polygen(45, 44, 42, 41),
    46: polygen(46, 40, 39, 38),
    47: polygen(47, 46, 43, 42),
    48: polygen(48, 44, 41, 39),
    49: polygen(49, 45, 44, 43),
    50: polygen(50, 48, 47, 46),
    51: polygen(51, 50, 48, 45),
    52: polygen(52, 51, 49, 46),
    53: polygen(53, 52, 51, 47),
    54: polygen(54, 51, 48, 46),
    55: polygen(55, 54, 53, 49),
    56: polygen(56, 54, 52, 49),
    57: polygen(57, 55, 54, 52),
    58: polygen(58, 57, 53, 52),
    59: polygen(59, 57, 55, 52),
    60: polygen(60, 58, 56, 55),
    61: polygen(61, 60, 59, 56),
    62: polygen(62, 59, 57, 56),
    63: polygen(63, 62, 59, 58),
    64: polygen(64, 63, 61, 60),
    65: polygen(65, 64, 62, 61),
    66: polygen(66, 60, 58, 57),
    67: polygen(67, 66, 65, 62),
    68: polygen(68, 67, 63, 61),
    69: polygen(69, 67, 64, 63),
    70: polygen(70, 69, 67, 65),
    71: polygen(71, 70, 68, 66),
    72: polygen(72, 69, 63, 62),
    73: polygen(73, 71, 70, 69),
    74: polygen(74, 71, 70, 67),
    75: polygen(75, 74, 72, 69),
    76: polygen(76, 74, 72, 71),
    77: polygen(77, 75, 72, 71),
    78: polygen(78, 77, 76, 71),
    79: polygen(79, 77, 76, 75),
    80: polygen(80, 78, 76, 71),
    81: polygen(81, 79, 78, 75),
    82: polygen(82, 78, 76, 73),
    83: polygen(83, 81, 79, 76),
    84: polygen(84, 83, 77, 75),
    85: polygen(85, 84, 83, 77),
    86: polygen(86, 84, 81, 80),
    87: polygen(87, 86, 82, 80),
    88: polygen(88, 80, 79, 77),
    89: polygen(89, 86, 84, 83),
    90: polygen(90, 88, 87, 85),
    91: polygen(91, 90, 86, 83),
    92: polygen(92, 90, 87, 86),
    93: polygen(93, 91, 90, 87),
    94: polygen(94, 93, 89, 88),
    95: polygen(95, 94, 90, 88),
    96: polygen(96, 90, 87, 86),
    97: polygen(97, 95, 93, 91),
    98: polygen(98, 97, 91, 90),
    99: polygen(99, 95, 94, 92),
    100: polygen(100, 98, 93, 92),
    101: polygen(101, 100, 95, 94),
    102: polygen(102, 99, 97, 96),
    103: polygen(103, 102, 99, 94),
    104: polygen(104, 103, 94, 93),
    105: polygen(105, 104, 99, 98),
    106: polygen(106, 105, 101, 100),
    107: polygen(107, 105, 99, 98),
    108: polygen(108, 103, 97, 96),
    109: polygen(109, 107, 105, 104),
    110: polygen(110, 109, 106, 104),
    111: polygen(111, 109, 107, 104),
    112: polygen(112, 108, 106, 101),
    113: polygen(113, 111, 110, 108),
    114: polygen(114, 113, 112, 103),
    115: polygen(115, 110, 108, 107),
    116: polygen(116, 114, 111, 110),
    117: polygen(117, 116, 115, 112),
    118: polygen(118, 116, 113, 112),
    119: polygen(119, 116, 111, 110),
    120: polygen(120, 118, 114, 111),
    121: polygen(121, 120, 116, 113),
    122: polygen(122, 121, 120, 116),
    123: polygen(123, 122, 119, 115),
    124: polygen(124, 119, 118, 117),
    125: polygen(125, 120, 119, 118),
    126: polygen(126, 124, 122, 119),
    127: polygen(127, 126, 124, 120),
    128: polygen(128, 127, 126, 121),
    129: polygen(129, 128, 125, 124),
    130: polygen(130, 129, 128, 125),
    131: polygen(131, 129, 128, 123),
    132: polygen(132, 130, 127, 123),
    133: polygen(133, 131, 125, 124),
    134: polygen(134, 133, 129, 127),
    135: polygen(135, 132, 131, 129),
    136: polygen(136, 134, 133, 128),
    137: polygen(137, 136, 133, 126),
    138: polygen(138, 137, 131, 130),
    139: polygen(139, 136, 134, 131),
    140: polygen(140, 139, 136, 132),
    141: polygen(141, 140, 135, 128),
    142: polygen(142, 141, 139, 132),
    143: polygen(143, 141, 140, 138),
    144: polygen(144, 142, 140, 137),
    145: polygen(145, 144, 140, 139),
    146: polygen(146, 144, 143, 141),
    147: polygen(147, 145, 143, 136),
    148: polygen(148, 145, 143, 141),
    149: polygen(149, 142, 140, 139),
    150: polygen(150, 148, 147, 142),
    151: polygen(151, 150, 149, 148),
    152: polygen(152, 150, 149, 146),
    153: polygen(153, 149, 148, 145),
    154: polygen(154, 153, 149, 145),
    155: polygen(155, 151, 150, 148),
    156: polygen(156, 153, 151, 147),
    157: polygen(157, 155, 152, 151),
    158: polygen(158, 153, 152, 150),
    159: polygen(159, 156, 153, 148),
    160: polygen(160, 158, 157, 155),
    161: polygen(161, 159, 158, 155),
    162: polygen(162, 158, 155, 154),
    163: polygen(163, 160, 157, 156),
    164: polygen(164, 159, 158, 152),
    165: polygen(165, 162, 157, 156),
    166: polygen(166, 164, 163, 156),
    167: polygen(167, 165, 163, 161),
    168: polygen(168, 162, 159, 152),
    169: polygen(169, 164, 163, 161),
    170: polygen(170, 169, 166, 161),
    171: polygen(171, 169, 166, 165),
    172: polygen(172, 169, 165, 161),
    173: polygen(173, 171, 168, 165),
    174: polygen(174, 169, 166, 165),
    175: polygen(175, 173, 171, 169),
    176: polygen(176, 167, 165, 164),
    177: polygen(177, 175, 174, 172),
    178: polygen(178, 176, 171, 170),
    179: polygen(179, 178, 177, 175),
    180: polygen(180, 173, 170, 168),
    181: polygen(181, 180, 175, 174),
    182: polygen(182, 181, 176, 174),
    183: polygen(183, 179, 176, 175),
    184: polygen(184, 177, 176, 175),
    185: polygen(185, 184, 182, 177),
    186: polygen(186, 180, 178, 177),
    187: polygen(187, 182, 181, 180),
    188: polygen(188, 186, 183, 182),
    189: polygen(189, 187, 184, 183),
    190: polygen(190, 188, 184, 177),
    191: polygen(191, 187, 185, 184),
    192: polygen(192, 190, 178, 177),
    193: polygen(193, 189, 186, 184),
    194: polygen(194, 192, 191, 190),
    195: polygen(195, 193, 192, 187),
    196: polygen(196, 194, 187, 185),
    197: polygen(197, 195, 193, 188),
    198: polygen(198, 193, 190, 183),
    199: polygen(199, 198, 195, 190),
    200: polygen(200, 198, 197, 195),
    201: polygen(201, 199, 198, 195),
    202: polygen(202, 198, 196, 195),
    203: polygen(203, 202, 196, 195),
    204: polygen(204, 201, 200, 194),
    205: polygen(205, 203, 200, 196),
    206: polygen(206, 201, 197, 196),
    207: polygen(207, 206, 201, 198),
    208: polygen(208, 207, 205, 199),
    209: polygen(209, 207, 206, 204),
    210: polygen(210, 207, 206, 198),
    211: polygen(211, 203, 201, 200),
    212: polygen(212, 209, 208, 205),
    213: polygen(213, 211, 208, 207),
    214: polygen(214, 213, 211, 209),
    215: polygen(215, 212, 210, 209),
    216: polygen(216, 215, 213, 209),
    217: polygen(217, 213, 212, 211),
    218: polygen(218, 217, 211, 210),
    219: polygen(219, 218, 215, 211),
    220: polygen(220, 211, 210, 208),
    221: polygen(221, 219, 215, 213),
    222: polygen(222, 220, 217, 214),
    223: polygen(223, 221, 219, 218),
    224: polygen(224, 222, 217, 212),
    225: polygen(225, 224, 220, 215),
    226: polygen(226, 223, 219, 216),
    227: polygen(227, 223, 218, 217),
    228: polygen(228, 226, 217, 216),
    229: polygen(229, 228, 225, 219),
    230: polygen(230, 224, 223, 222),
    231: polygen(231, 229, 227, 224),
    232: polygen(232, 228, 223, 221),
    233: polygen(233, 232, 229, 224),
    234: polygen(234, 232, 225, 223),
    235: polygen(235, 234, 229, 226),
    236: polygen(236, 229, 228, 226),
    237: polygen(237, 236, 233, 230),
    238: polygen(238, 237, 236, 233),
    239: polygen(239, 238, 232, 227),
    240: polygen(240, 237, 235, 232),
    241: polygen(241, 237, 233, 232),
    242: polygen(242, 241, 236, 231),
    243: polygen(243, 242, 238, 235),
    244: polygen(244, 243, 240, 235),
    245: polygen(245, 244, 241, 239),
    246: polygen(246, 245, 244, 235),
    247: polygen(247, 245, 243, 238),
    248: polygen(248, 238, 234, 233),
    249: polygen(249, 248, 245, 242),
    250: polygen(250, 247, 245, 240),
    251: polygen(251, 249, 247, 244),
    252: polygen(252, 251, 247, 241),
    253: polygen(253, 252, 247, 246),
    254: polygen(254, 253, 252, 247),
    255: polygen(255, 253, 252, 250),
    256: polygen(256, 254, 251, 246),
    257: polygen(257, 255, 251, 250),
    258: polygen(258, 254, 252, 249),
    259: polygen(259, 257, 253, 249),
    260: polygen(260, 253, 252, 250),
    261: polygen(261, 257, 255, 254),
    262: polygen(262, 258, 254, 253),
    263: polygen(263, 261, 258, 252),
    264: polygen(264, 263, 255, 254),
    265: polygen(265, 263, 262, 260),
    266: polygen(266, 265, 260, 259),
    267: polygen(267, 264, 261, 259),
    268: polygen(268, 267, 264, 258),
    269: polygen(269, 268, 263, 262),
    270: polygen(270, 267, 263, 260),
    271: polygen(271, 265, 264, 260),
    272: polygen(272, 270, 266, 263),
    273: polygen(273, 272, 271, 266),
    274: polygen(274, 272, 267, 265),
    275: polygen(275, 266, 265, 264),
    276: polygen(276, 275, 273, 270),
    277: polygen(277, 274, 271, 265),
    278: polygen(278, 277, 274, 273),
    279: polygen(279, 278, 275, 274),
    280: polygen(280, 278, 275, 271),
    281: polygen(281, 280, 277, 272),
    282: polygen(282, 278, 277, 272),
    283: polygen(283, 278, 276, 271),
    284: polygen(284, 279, 278, 276),
    285: polygen(285, 280, 278, 275),
    286: polygen(286, 285, 276, 271),
    287: polygen(287, 285, 282, 281),
    288: polygen(288, 287, 278, 277),
    289: polygen(289, 286, 285, 277),
    290: polygen(290, 288, 287, 285),
    291: polygen(291, 286, 280, 279),
    292: polygen(292, 291, 289, 285),
    293: polygen(293, 292, 287, 282),
    294: polygen(294, 292, 291, 285),
    295: polygen(295, 293, 291, 290),
    296: polygen(296, 292, 287, 285),
    297: polygen(297, 296, 293, 292),
    298: polygen(298, 294, 290, 287),
    299: polygen(299, 295, 293, 288),
    300: polygen(300, 290, 288, 287),
    301: polygen(301, 299, 296, 292),
    302: polygen(302, 297, 293, 290),
    303: polygen(303, 297, 291, 290),
    304: polygen(304, 303, 302, 293),
    305: polygen(305, 303, 299, 298),
    306: polygen(306, 305, 303, 299),
    307: polygen(307, 305, 303, 299),
    308: polygen(308, 306, 299, 293),
    309: polygen(309, 307, 302, 299),
    310: polygen(310, 309, 305, 302),
    311: polygen(311, 308, 306, 304),
    312: polygen(312, 307, 302, 301),
    313: polygen(313, 312, 310, 306),
    314: polygen(314, 311, 305, 300),
    315: polygen(315, 314, 306, 305),
    316: polygen(316, 309, 305, 304),
    317: polygen(317, 315, 313, 310),
    318: polygen(318, 313, 312, 310),
    319: polygen(319, 318, 317, 308),
    320: polygen(320, 319, 317, 316),
    321: polygen(321, 319, 316, 314),
    322: polygen(322, 321, 320, 305),
    323: polygen(323, 322, 320, 313),
    324: polygen(324, 321, 320, 318),
    325: polygen(325, 323, 320, 315),
    326: polygen(326, 325, 323, 316),
    327: polygen(327, 325, 322, 319),
    328: polygen(328, 323, 321, 319),
    329: polygen(329, 326, 323, 321),
    330: polygen(330, 328, 323, 322),
    331: polygen(331, 329, 325, 321),
    332: polygen(332, 325, 321, 320),
    333: polygen(333, 331, 329, 325),
    334: polygen(334, 333, 330, 327),
    335: polygen(335, 333, 328, 325),
    336: polygen(336, 335, 332, 329),
    337: polygen(337, 336, 331, 327),
    338: polygen(338, 336, 335, 332),
    339: polygen(339, 332, 329, 323),
    340: polygen(340, 337, 336, 329),
    341: polygen(341, 336, 330, 327),
    342: polygen(342, 341, 340, 331),
    343: polygen(343, 338, 335, 333),
    344: polygen(344, 338, 334, 333),
    345: polygen(345, 343, 341, 337),
    346: polygen(346, 344, 339, 335),
    347: polygen(347, 344, 337, 336),
    348: polygen(348, 344, 341, 340),
    349: polygen(349, 347, 344, 343),
    350: polygen(350, 340, 337, 336),
    351: polygen(351, 348, 345, 343),
    352: polygen(352, 346, 341, 339),
    353: polygen(353, 349, 346, 344),
    354: polygen(354, 349, 341, 340),
    355: polygen(355, 354, 350, 349),
    356: polygen(356, 349, 347, 346),
    357: polygen(357, 355, 347, 346),
    358: polygen(358, 351, 350, 344),
    359: polygen(359, 358, 352, 350),
    360: polygen(360, 359, 335, 334),
    361: polygen(361, 360, 357, 354),
    362: polygen(362, 360, 351, 344),
    363: polygen(363, 362, 356, 355),
    364: polygen(364, 363, 359, 352),
    365: polygen(365, 360, 359, 356),
    366: polygen(366, 362, 359, 352),
    367: polygen(367, 365, 363, 358),
    368: polygen(368, 361, 359, 351),
    369: polygen(369, 367, 359, 358),
    370: polygen(370, 368, 367, 365),
    371: polygen(371, 369, 368, 363),
    372: polygen(372, 369, 365, 357),
    373: polygen(373, 371, 366, 365),
    374: polygen(374, 369, 368, 366),
    375: polygen(375, 374, 368, 367),
    376: polygen(376, 371, 369, 368),
    377: polygen(377, 376, 374, 369),
    378: polygen(378, 374, 365, 363),
    379: polygen(379, 375, 370, 369),
    380: polygen(380, 377, 374, 366),
    381: polygen(381, 380, 379, 376),
    382: polygen(382, 379, 375, 364),
    383: polygen(383, 382, 378, 374),
    384: polygen(384, 378, 369, 368),
    385: polygen(385, 383, 381, 379),
    386: polygen(386, 381, 380, 376),
    387: polygen(387, 385, 379, 378),
    388: polygen(388, 387, 385, 374),
    389: polygen(389, 384, 380, 379),
    390: polygen(390, 388, 380, 377),
    391: polygen(391, 390, 389, 385),
    392: polygen(392, 386, 382, 379),
    393: polygen(393, 392, 391, 386),
    394: polygen(394, 392, 387, 386),
    395: polygen(395, 390, 389, 384),
    396: polygen(396, 392, 390, 389),
    397: polygen(397, 392, 387, 385),
    398: polygen(398, 393, 392, 384),
    399: polygen(399, 397, 390, 388),
    400: polygen(400, 398, 397, 395),
    401: polygen(401, 399, 392, 389),
    402: polygen(402, 399, 398, 393),
    403: polygen(403, 398, 395, 394),
    404: polygen(404, 400, 398, 397),
    405: polygen(405, 398, 397, 388),
    406: polygen(406, 402, 397, 393),
    407: polygen(407, 402, 400, 398),
    408: polygen(408, 407, 403, 401),
    409: polygen(409, 406, 404, 402),
    410: polygen(410, 407, 406, 400),
    411: polygen(411, 408, 401, 399),
    412: polygen(412, 409, 404, 401),
    413: polygen(413, 407, 406, 403),
    414: polygen(414, 405, 401, 398),
    415: polygen(415, 413, 411, 406),
    416: polygen(416, 414, 411, 407),
    417: polygen(417, 416, 414, 407),
    418: polygen(418, 417, 415, 403),
    419: polygen(419, 415, 414, 404),
    420: polygen(420, 412, 410, 407),
    421: polygen(421, 419, 417, 416),
    422: polygen(422, 421, 416, 412),
    423: polygen(423, 420, 418, 414),
    424: polygen(424, 422, 417, 415),
    425: polygen(425, 422, 421, 418),
    426: polygen(426, 415, 414, 412),
    427: polygen(427, 422, 421, 416),
    428: polygen(428, 426, 425, 417),
    429: polygen(429, 422, 421, 419),
    430: polygen(430, 419, 417, 415),
    431: polygen(431, 430, 428, 426),
    432: polygen(432, 429, 428, 419),
    433: polygen(433, 430, 428, 422),
    434: polygen(434, 429, 423, 422),
    435: polygen(435, 430, 426, 423),
    436: polygen(436, 432, 431, 430),
    437: polygen(437, 436, 435, 431),
    438: polygen(438, 436, 432, 421),
    439: polygen(439, 437, 436, 431),
    440: polygen(440, 439, 437, 436),
    441: polygen(441, 440, 433, 430),
    442: polygen(442, 440, 437, 435),
    443: polygen(443, 442, 437, 433),
    444: polygen(444, 435, 432, 431),
    445: polygen(445, 441, 439, 438),
    446: polygen(446, 442, 439, 431),
    447: polygen(447, 446, 441, 438),
    448: polygen(448, 444, 442, 437),
    449: polygen(449, 446, 440, 438),
    450: polygen(450, 443, 438, 434),
    451: polygen(451, 450, 441, 435),
    452: polygen(452, 448, 447, 446),
    453: polygen(453, 449, 447, 438),
    454: polygen(454, 449, 445, 444),
    455: polygen(455, 453, 449, 444),
    456: polygen(456, 454, 445, 433),
    457: polygen(457, 454, 449, 446),
    458: polygen(458, 453, 448, 445),
    459: polygen(459, 457, 454, 447),
    460: polygen(460, 459, 455, 451),
    461: polygen(461, 460, 455, 454),
    462: polygen(462, 457, 451, 450),
    463: polygen(463, 456, 455, 452),
    464: polygen(464, 460, 455, 441),
    465: polygen(465, 463, 462, 457),
    466: polygen(466, 460, 455, 452),
    467: polygen(467, 466, 461, 456),
    468: polygen(468, 464, 459, 453),
    469: polygen(469, 467, 464, 460),
    470: polygen(470, 468, 462, 461),
    471: polygen(471, 469, 468, 465),
    472: polygen(472, 470, 469, 461),
    473: polygen(473, 470, 467, 465),
    474: polygen(474, 465, 463, 456),
    475: polygen(475, 471, 467, 466),
    476: polygen(476, 475, 468, 466),
    477: polygen(477, 470, 462, 461),
    478: polygen(478, 477, 474, 472),
    479: polygen(479, 475, 472, 470),
    480: polygen(480, 473, 467, 464),
    481: polygen(481, 480, 472, 471),
    482: polygen(482, 477, 476, 473),
    483: polygen(483, 479, 477, 474),
    484: polygen(484, 483, 482, 470),
    485: polygen(485, 479, 469, 468),
    486: polygen(486, 481, 478, 472),
    487: polygen(487, 485, 483, 478),
    488: polygen(488, 487, 485, 484),
    489: polygen(489, 484, 483, 480),
    490: polygen(490, 485, 483, 481),
    491: polygen(491, 488, 485, 480),
    492: polygen(492, 491, 485, 484),
    493: polygen(493, 490, 488, 483),
    494: polygen(494, 493, 489, 481),
    495: polygen(495, 494, 486, 480),
    496: polygen(496, 494, 491, 480),
    497: polygen(497, 493, 488, 486),
    498: polygen(498, 495, 489, 487),
    499: polygen(499, 494, 493, 488),
    500: polygen(500, 499, 494, 490),
    501: polygen(501, 499, 497, 496),
    502: polygen(502, 498, 497, 494),
    503: polygen(503, 502, 501, 500),
    504: polygen(504, 502, 490, 483),
    505: polygen(505, 500, 497, 493),
    506: polygen(506, 501, 494, 491),
    507: polygen(507, 504, 501, 494),
    508: polygen(508, 505, 500, 495),
    509: polygen(509, 506, 502, 501),
    510: polygen(510, 501, 500, 498),
    511: polygen(511, 509, 503, 501),
    512: polygen(512, 510, 507, 504),
    513: polygen(513, 505, 503, 500),
    514: polygen(514, 511, 509, 507),
    515: polygen(515, 511, 508, 501),
    516: polygen(516, 514, 511, 509),
    517: polygen(517, 515, 507, 505),
    518: polygen(518, 516, 515, 507),
    519: polygen(519, 517, 511, 507),
    520: polygen(520, 509, 507, 503),
    521: polygen(521, 519, 514, 512),
    522: polygen(522, 518, 509, 507),
    523: polygen(523, 521, 517, 510),
    524: polygen(524, 523, 519, 515),
    525: polygen(525, 524, 521, 519),
    526: polygen(526, 525, 521, 517),
    527: polygen(527, 526, 520, 518),
    528: polygen(528, 526, 522, 517),
    529: polygen(529, 528, 525, 522),
    530: polygen(530, 527, 523, 520),
    531: polygen(531, 529, 525, 519),
    532: polygen(532, 529, 528, 522),
    533: polygen(533, 531, 530, 529),
    534: polygen(534, 533, 529, 527),
    535: polygen(535, 533, 529, 527),
    536: polygen(536, 533, 531, 529),
    537: polygen(537, 536, 535, 527),
    538: polygen(538, 537, 536, 533),
    539: polygen(539, 535, 534, 529),
    540: polygen(540, 537, 534, 529),
    541: polygen(541, 537, 531, 528),
    542: polygen(542, 540, 539, 533),
    543: polygen(543, 538, 536, 532),
    544: polygen(544, 538, 535, 531),
    545: polygen(545, 539, 537, 532),
    546: polygen(546, 545, 544, 538),
    547: polygen(547, 543, 540, 534),
    548: polygen(548, 545, 543, 538),
    549: polygen(549, 546, 545, 533),
    550: polygen(550, 546, 533, 529),
    551: polygen(551, 550, 547, 542),
    552: polygen(552, 550, 547, 532),
    553: polygen(553, 550, 549, 542),
    554: polygen(554, 551, 546, 543),
    555: polygen(555, 551, 546, 545),
    556: polygen(556, 549, 546, 540),
    557: polygen(557, 552, 551, 550),
    558: polygen(558, 553, 549, 544),
    559: polygen(559, 557, 552, 550),
    560: polygen(560, 554, 551, 549),
    561: polygen(561, 558, 552, 550),
    562: polygen(562, 560, 558, 551),
    563: polygen(563, 561, 554, 549),
    564: polygen(564, 563, 561, 558),
    565: polygen(565, 564, 559, 554),
    566: polygen(566, 564, 561, 560),
    567: polygen(567, 563, 557, 556),
    568: polygen(568, 558, 557, 551),
    569: polygen(569, 568, 559, 557),
    570: polygen(570, 563, 558, 552),
    571: polygen(571, 569, 566, 561),
    572: polygen(572, 571, 564, 560),
    573: polygen(573, 569, 567, 563),
    574: polygen(574, 569, 565, 560),
    575: polygen(575, 572, 570, 569),
    576: polygen(576, 573, 572, 563),
    577: polygen(577, 575, 574, 569),
    578: polygen(578, 562, 556, 555),
    579: polygen(579, 572, 570, 567),
    580: polygen(580, 579, 576, 574),
    581: polygen(581, 575, 574, 568),
    582: polygen(582, 579, 576, 571),
    583: polygen(583, 581, 577, 575),
    584: polygen(584, 581, 571, 570),
    585: polygen(585, 583, 582, 577),
    586: polygen(586, 584, 581, 579),
    587: polygen(587, 586, 581, 576),
    588: polygen(588, 577, 572, 571),
    589: polygen(589, 586, 585, 579),
    590: polygen(590, 588, 587, 578),
    591: polygen(591, 587, 585, 582),
    592: polygen(592, 591, 573, 568),
    593: polygen(593, 588, 585, 584),
    594: polygen(594, 586, 584, 583),
    595: polygen(595, 594, 593, 586),
    596: polygen(596, 592, 591, 590),
    597: polygen(597, 588, 585, 583),
    598: polygen(598, 597, 592, 591),
    599: polygen(599, 593, 591, 590),
    600: polygen(600, 599, 590, 589),
    601: polygen(601, 600, 597, 589),
    602: polygen(602, 596, 594, 591),
    603: polygen(603, 600, 599, 597),
    604: polygen(604, 600, 598, 589),
    605: polygen(605, 600, 598, 595),
    606: polygen(606, 602, 599, 591),
    607: polygen(607, 600, 598, 595),
    608: polygen(608, 606, 602, 585),
    609: polygen(609, 601, 600, 597),
    610: polygen(610, 602, 600, 599),
    611: polygen(611, 609, 607, 601),
    612: polygen(612, 607, 602, 598),
    613: polygen(613, 609, 603, 594),
    614: polygen(614, 613, 612, 607),
    615: polygen(615, 614, 609, 608),
    616: polygen(616, 614, 602, 597),
    617: polygen(617, 612, 608, 607),
    618: polygen(618, 615, 604, 598),
    619: polygen(619, 614, 611, 610),
    620: polygen(620, 619, 618, 611),
    621: polygen(621, 616, 615, 609),
    622: polygen(622, 612, 610, 605),
    623: polygen(623, 614, 613, 612),
    624: polygen(624, 617, 615, 612),
    625: polygen(625, 620, 617, 613),
    626: polygen(626, 623, 621, 613),
    627: polygen(627, 622, 617, 613),
    628: polygen(628, 626, 617, 616),
    629: polygen(629, 627, 624, 623),
    630: polygen(630, 628, 626, 623),
    631: polygen(631, 625, 623, 617),
    632: polygen(632, 629, 619, 613),
    633: polygen(633, 632, 631, 626),
    634: polygen(634, 631, 629, 627),
    635: polygen(635, 631, 625, 621),
    636: polygen(636, 632, 628, 623),
    637: polygen(637, 636, 628, 623),
    638: polygen(638, 637, 633, 632),
    639: polygen(639, 636, 635, 629),
    640: polygen(640, 638, 637, 626),
    641: polygen(641, 640, 636, 622),
    642: polygen(642, 636, 633, 632),
    643: polygen(643, 641, 640, 632),
    644: polygen(644, 634, 633, 632),
    645: polygen(645, 641, 637, 634),
    646: polygen(646, 635, 634, 633),
    647: polygen(647, 646, 643, 642),
    648: polygen(648, 647, 626, 625),
    649: polygen(649, 648, 644, 638),
    650: polygen(650, 644, 635, 632),
    651: polygen(651, 646, 638, 637),
    652: polygen(652, 647, 643, 641),
    653: polygen(653, 646, 645, 643),
    654: polygen(654, 649, 643, 640),
    655: polygen(655, 653, 639, 638),
    656: polygen(656, 646, 638, 637),
    657: polygen(657, 656, 650, 649),
    658: polygen(658, 651, 648, 646),
    659: polygen(659, 657, 655, 644),
    660: polygen(660, 657, 656, 648),
    661: polygen(661, 657, 650, 649),
    662: polygen(662, 659, 656, 650),
    663: polygen(663, 655, 652, 649),
    664: polygen(664, 662, 660, 649),
    665: polygen(665, 661, 659, 654),
    666: polygen(666, 664, 659, 656),
    667: polygen(667, 664, 660, 649),
    668: polygen(668, 658, 656, 651),
    669: polygen(669, 667, 665, 664),
    670: polygen(670, 669, 665, 664),
    671: polygen(671, 669, 665, 662),
    672: polygen(672, 667, 666, 661),
    673: polygen(673, 666, 664, 663),
    674: polygen(674, 671, 665, 660),
    675: polygen(675, 674, 672, 669),
    676: polygen(676, 675, 671, 664),
    677: polygen(677, 674, 673, 669),
    678: polygen(678, 675, 673, 663),
    679: polygen(679, 676, 667, 661),
    680: polygen(680, 679, 650, 645),
    681: polygen(681, 678, 672, 670),
    682: polygen(682, 681, 679, 675),
    683: polygen(683, 682, 677, 672),
    684: polygen(684, 681, 671, 666),
    685: polygen(685, 684, 682, 681),
    686: polygen(686, 684, 674, 673),
    687: polygen(687, 682, 675, 673),
    688: polygen(688, 682, 674, 669),
    689: polygen(689, 686, 683, 681),
    690: polygen(690, 687, 683, 680),
    691: polygen(691, 689, 685, 678),
    692: polygen(692, 687, 686, 678),
    693: polygen(693, 691, 685, 678),
    694: polygen(694, 691, 681, 677),
    695: polygen(695, 694, 691, 686),
    696: polygen(696, 694, 686, 673),
    697: polygen(697, 689, 685, 681),
    698: polygen(698, 690, 689, 688),
    699: polygen(699, 698, 689, 684),
    700: polygen(700, 698, 695, 694),
    701: polygen(701, 699, 697, 685),
    702: polygen(702, 701, 699, 695),
    703: polygen(703, 702, 696, 691),
    704: polygen(704, 701, 699, 692),
    705: polygen(705, 704, 698, 697),
    706: polygen(706, 697, 695, 692),
    707: polygen(707, 702, 699, 692),
    708: polygen(708, 706, 704, 703),
    709: polygen(709, 708, 706, 705),
    710: polygen(710, 709, 696, 695),
    711: polygen(711, 704, 703, 700),
    712: polygen(712, 709, 708, 707),
    713: polygen(713, 706, 703, 696),
    714: polygen(714, 709, 707, 701),
    715: polygen(715, 714, 711, 708),
    716: polygen(716, 706, 705, 704),
    717: polygen(717, 716, 710, 701),
    718: polygen(718, 717, 716, 713),
    719: polygen(719, 711, 710, 707),
    720: polygen(720, 718, 712, 709),
    721: polygen(721, 720, 713, 712),
    722: polygen(722, 721, 718, 707),
    723: polygen(723, 717, 710, 707),
    724: polygen(724, 719, 716, 711),
    725: polygen(725, 720, 719, 716),
    726: polygen(726, 725, 722, 721),
    727: polygen(727, 721, 719, 716),
    728: polygen(728, 726, 725, 724),
    729: polygen(729, 726, 724, 718),
    730: polygen(730, 726, 715, 711),
    731: polygen(731, 729, 725, 723),
    732: polygen(732, 729, 728, 725),
    733: polygen(733, 731, 726, 725),
    734: polygen(734, 724, 721, 720),
    735: polygen(735, 733, 728, 727),
    736: polygen(736, 730, 728, 723),
    737: polygen(737, 736, 733, 732),
    738: polygen(738, 730, 729, 727),
    739: polygen(739, 731, 723, 721),
    740: polygen(740, 737, 728, 716),
    741: polygen(741, 738, 733, 732),
    742: polygen(742, 741, 738, 730),
    743: polygen(743, 742, 731, 730),
    744: polygen(744, 743, 733, 731),
    745: polygen(745, 740, 738, 737),
    746: polygen(746, 738, 733, 728),
    747: polygen(747, 743, 741, 737),
    748: polygen(748, 744, 743, 733),
    749: polygen(749, 748, 743, 742),
    750: polygen(750, 746, 741, 734),
    751: polygen(751, 750, 748, 740),
    752: polygen(752, 749, 732, 731),
    753: polygen(753, 748, 745, 740),
    754: polygen(754, 742, 740, 735),
    755: polygen(755, 754, 745, 743),
    756: polygen(756, 755, 747, 740),
    757: polygen(757, 756, 751, 750),
    758: polygen(758, 757, 746, 741),
    759: polygen(759, 757, 756, 750),
    760: polygen(760, 757, 747, 734),
    761: polygen(761, 760, 759, 758),
    762: polygen(762, 761, 755, 745),
    763: polygen(763, 754, 749, 747),
    764: polygen(764, 761, 759, 758),
    765: polygen(765, 760, 755, 754),
    766: polygen(766, 757, 747, 744),
    767: polygen(767, 763, 760, 759),
    768: polygen(768, 764, 751, 749),
    769: polygen(769, 763, 762, 760),
    770: polygen(770, 768, 765, 756),
    771: polygen(771, 765, 756, 754),
    772: polygen(772, 767, 766, 764),
    773: polygen(773, 767, 765, 763),
    774: polygen(774, 767, 760, 758),
    775: polygen(775, 771, 769, 768),
    776: polygen(776, 773, 764, 759),
    777: polygen(777, 776, 767, 761),
    778: polygen(778, 775, 762, 759),
    779: polygen(779, 776, 771, 769),
    780: polygen(780, 775, 772, 764),
    781: polygen(781, 779, 765, 764),
    782: polygen(782, 780, 779, 773),
    783: polygen(783, 782, 776, 773),
    784: polygen(784, 778, 775, 771),
    785: polygen(785, 780, 776, 775),
    786: polygen(786, 782, 780, 771),
    1024: polygen(1024, 1015, 1002, 1001),
    2048: polygen(2048, 2035, 2034, 2029),
    4096: polygen(4096, 4095, 4081, 4069),
}
'''Mapping of possible 4-tap polynomials.'''

all_polys = {
    2: polygen(2, 1),
    3: polygen(3, 2),
    4: polygen(4, 3),
    5: polygen(5, 3),
    6: polygen(6, 5),
    7: polygen(7, 6),
    8: polygen(8, 6, 5, 4),
    9: polygen(9, 5),
    10: polygen(10, 7),
    11: polygen(11, 9),
    12: polygen(12, 11, 8, 6),
    13: polygen(13, 12, 10, 9),
    14: polygen(14, 13, 11, 9),
    15: polygen(15, 14),
    16: polygen(16, 14, 13, 11),
    17: polygen(17, 14),
    18: polygen(18, 11),
    19: polygen(19, 18, 17, 14),
    20: polygen(20, 17),
    21: polygen(21, 19),
    22: polygen(22, 21),
    23: polygen(23, 18),
    24: polygen(24, 23, 21, 20),
    25: polygen(25, 22),
    26: polygen(26, 25, 24, 20),
    27: polygen(27, 26, 25, 22),
    28: polygen(28, 25),
    29: polygen(29, 27),
    30: polygen(30, 29, 26, 24),
    31: polygen(31, 28),
    32: polygen(32, 30, 26, 25),
    33: polygen(33, 20),
    34: polygen(34, 31, 30, 26),
    35: polygen(35, 33),
    36: polygen(36, 25),
    37: polygen(37, 36, 33, 31),
    38: polygen(38, 37, 33, 32),
    39: polygen(39, 35),
    40: polygen(40, 37, 36, 35),
    41: polygen(41, 38),
    42: polygen(42, 40, 37, 35),
    43: polygen(43, 42, 38, 37),
    44: polygen(44, 42, 39, 38),
    45: polygen(45, 44, 42, 41),
    46: polygen(46, 40, 39, 38),
    47: polygen(47, 42),
    48: polygen(48, 44, 41, 39),
    49: polygen(49, 40),
    50: polygen(50, 48, 47, 46),
    51: polygen(51, 50, 48, 45),
    52: polygen(52, 49),
    53: polygen(53, 52, 51, 47),
    54: polygen(54, 51, 48, 46),
    55: polygen(55, 31),
    56: polygen(56, 54, 52, 49),
    57: polygen(57, 50),
    58: polygen(58, 39),
    59: polygen(59, 57, 55, 52),
    60: polygen(60, 59),
    61: polygen(61, 60, 59, 56),
    62: polygen(62, 59, 57, 56),
    63: polygen(63, 62),
    64: polygen(64, 63, 61, 60),
    65: polygen(65, 47),
    66: polygen(66, 60, 58, 57),
    67: polygen(67, 66, 65, 62),
    68: polygen(68, 59),
    69: polygen(69, 67, 64, 63),
    70: polygen(70, 69, 67, 65),
    71: polygen(71, 65),
    72: polygen(72, 69, 63, 62),
    73: polygen(73, 48),
    74: polygen(74, 71, 70, 67),
    75: polygen(75, 74, 72, 69),
    76: polygen(76, 74, 72, 71),
    77: polygen(77, 75, 72, 71),
    78: polygen(78, 77, 76, 71),
    79: polygen(79, 70),
    80: polygen(80, 78, 76, 71),
    81: polygen(81, 77),
    82: polygen(82, 78, 76, 73),
    83: polygen(83, 81, 79, 76),
    84: polygen(84, 71),
    85: polygen(85, 84, 83, 77),
    86: polygen(86, 84, 81, 80),
    87: polygen(87, 74),
    88: polygen(88, 80, 79, 77),
    89: polygen(89, 51),
    90: polygen(90, 88, 87, 85),
    91: polygen(91, 90, 86, 83),
    92: polygen(92, 90, 87, 86),
    93: polygen(93, 91),
    94: polygen(94, 73),
    95: polygen(95, 84),
    96: polygen(96, 90, 87, 86),
    97: polygen(97, 91),
    98: polygen(98, 87),
    99: polygen(99, 95, 94, 92),
    100: polygen(100, 63),
    101: polygen(101, 100, 95, 94),
    102: polygen(102, 99, 97, 96),
    103: polygen(103, 94),
    104: polygen(104, 103, 94, 93),
    105: polygen(105, 89),
    106: polygen(106, 91),
    107: polygen(107, 105, 99, 98),
    108: polygen(108, 77),
    109: polygen(109, 107, 105, 104),
    110: polygen(110, 109, 106, 104),
    111: polygen(111, 101),
    112: polygen(112, 108, 106, 101),
    113: polygen(113, 104),
    114: polygen(114, 113, 112, 103),
    115: polygen(115, 110, 108, 107),
    116: polygen(116, 114, 111, 110),
    117: polygen(117, 116, 115, 112),
    118: polygen(118, 85),
    119: polygen(119, 111),
    120: polygen(120, 118, 114, 111),
    121: polygen(121, 103),
    122: polygen(122, 121, 120, 116),
    123: polygen(123, 121),
    124: polygen(124, 87),
    125: polygen(125, 120, 119, 118),
    126: polygen(126, 124, 122, 119),
    127: polygen(127, 126),
    128: polygen(128, 127, 126, 121),
    129: polygen(129, 124),
    130: polygen(130, 127),
    131: polygen(131, 129, 128, 123),
    132: polygen(132, 103),
    133: polygen(133, 131, 125, 124),
    134: polygen(134, 77),
    135: polygen(135, 124),
    136: polygen(136, 134, 133, 128),
    137: polygen(137, 116),
    138: polygen(138, 137, 131, 130),
    139: polygen(139, 136, 134, 131),
    140: polygen(140, 111),
    141: polygen(141, 140, 135, 128),
    142: polygen(142, 121),
    143: polygen(143, 141, 140, 138),
    144: polygen(144, 142, 140, 137),
    145: polygen(145, 93),
    146: polygen(146, 144, 143, 141),
    147: polygen(147, 145, 143, 136),
    148: polygen(148, 121),
    149: polygen(149, 142, 140, 139),
    150: polygen(150, 97),
    151: polygen(151, 148),
    152: polygen(152, 150, 149, 146),
    153: polygen(153, 152),
    154: polygen(154, 153, 149, 145),
    155: polygen(155, 151, 150, 148),
    156: polygen(156, 153, 151, 147),
    157: polygen(157, 155, 152, 151),
    158: polygen(158, 153, 152, 150),
    159: polygen(159, 128),
    160: polygen(160, 158, 157, 155),
    161: polygen(161, 143),
    162: polygen(162, 158, 155, 154),
    163: polygen(163, 160, 157, 156),
    164: polygen(164, 159, 158, 152),
    165: polygen(165, 162, 157, 156),
    166: polygen(166, 164, 163, 156),
    167: polygen(167, 161),
    168: polygen(168, 162, 159, 152),
    169: polygen(169, 135),
    170: polygen(170, 147),
    171: polygen(171, 169, 166, 165),
    172: polygen(172, 165),
    173: polygen(173, 171, 168, 165),
    174: polygen(174, 161),
    175: polygen(175, 169),
    176: polygen(176, 167, 165, 164),
    177: polygen(177, 169),
    178: polygen(178, 91),
    179: polygen(179, 178, 177, 175),
    180: polygen(180, 173, 170, 168),
    181: polygen(181, 180, 175, 174),
    182: polygen(182, 181, 176, 174),
    183: polygen(183, 127),
    184: polygen(184, 177, 176, 175),
    185: polygen(185, 161),
    186: polygen(186, 180, 178, 177),
    187: polygen(187, 182, 181, 180),
    188: polygen(188, 186, 183, 182),
    189: polygen(189, 187, 184, 183),
    190: polygen(190, 188, 184, 177),
    191: polygen(191, 182),
    192: polygen(192, 190, 178, 177),
    193: polygen(193, 178),
    194: polygen(194, 107),
    195: polygen(195, 193, 192, 187),
    196: polygen(196, 194, 187, 185),
    197: polygen(197, 195, 193, 188),
    198: polygen(198, 133),
    199: polygen(199, 165),
    200: polygen(200, 198, 197, 195),
    201: polygen(201, 187),
    202: polygen(202, 147),
    203: polygen(203, 202, 196, 195),
    204: polygen(204, 201, 200, 194),
    205: polygen(205, 203, 200, 196),
    206: polygen(206, 201, 197, 196),
    207: polygen(207, 164),
    208: polygen(208, 207, 205, 199),
    209: polygen(209, 203),
    210: polygen(210, 207, 206, 198),
    211: polygen(211, 203, 201, 200),
    212: polygen(212, 107),
    213: polygen(213, 211, 208, 207),
    214: polygen(214, 213, 211, 209),
    215: polygen(215, 192),
    216: polygen(216, 215, 213, 209),
    217: polygen(217, 172),
    218: polygen(218, 207),
    219: polygen(219, 218, 215, 211),
    220: polygen(220, 211, 210, 208),
    221: polygen(221, 219, 215, 213),
    222: polygen(222, 220, 217, 214),
    223: polygen(223, 190),
    224: polygen(224, 222, 217, 212),
    225: polygen(225, 193),
    226: polygen(226, 223, 219, 216),
    227: polygen(227, 223, 218, 217),
    228: polygen(228, 226, 217, 216),
    229: polygen(229, 228, 225, 219),
    230: polygen(230, 224, 223, 222),
    231: polygen(231, 205),
    232: polygen(232, 228, 223, 221),
    233: polygen(233, 159),
    234: polygen(234, 203),
    235: polygen(235, 234, 229, 226),
    236: polygen(236, 231),
    237: polygen(237, 236, 233, 230),
    238: polygen(238, 237, 236, 233),
    239: polygen(239, 203),
    240: polygen(240, 237, 235, 232),
    241: polygen(241, 171),
    242: polygen(242, 241, 236, 231),
    243: polygen(243, 242, 238, 235),
    244: polygen(244, 243, 240, 235),
    245: polygen(245, 244, 241, 239),
    246: polygen(246, 245, 244, 235),
    247: polygen(247, 165),
    248: polygen(248, 238, 234, 233),
    249: polygen(249, 163),
    250: polygen(250, 147),
    251: polygen(251, 249, 247, 244),
    252: polygen(252, 185),
    253: polygen(253, 252, 247, 246),
    254: polygen(254, 253, 252, 247),
    255: polygen(255, 203),
    256: polygen(256, 254, 251, 246),
    257: polygen(257, 245),
    258: polygen(258, 175),
    259: polygen(259, 257, 253, 249),
    260: polygen(260, 253, 252, 250),
    261: polygen(261, 257, 255, 254),
    262: polygen(262, 258, 254, 253),
    263: polygen(263, 170),
    264: polygen(264, 263, 255, 254),
    265: polygen(265, 223),
    266: polygen(266, 219),
    267: polygen(267, 264, 261, 259),
    268: polygen(268, 243),
    269: polygen(269, 268, 263, 262),
    270: polygen(270, 217),
    271: polygen(271, 213),
    272: polygen(272, 270, 266, 263),
    273: polygen(273, 250),
    274: polygen(274, 207),
    275: polygen(275, 266, 265, 264),
    276: polygen(276, 275, 273, 270),
    277: polygen(277, 274, 271, 265),
    278: polygen(278, 273),
    279: polygen(279, 274),
    280: polygen(280, 278, 275, 271),
    281: polygen(281, 188),
    282: polygen(282, 247),
    283: polygen(283, 278, 276, 271),
    284: polygen(284, 165),
    285: polygen(285, 280, 278, 275),
    286: polygen(286, 217),
    287: polygen(287, 216),
    288: polygen(288, 287, 278, 277),
    289: polygen(289, 268),
    290: polygen(290, 288, 287, 285),
    291: polygen(291, 286, 280, 279),
    292: polygen(292, 195),
    293: polygen(293, 292, 287, 282),
    294: polygen(294, 233),
    295: polygen(295, 247),
    296: polygen(296, 292, 287, 285),
    297: polygen(297, 292),
    298: polygen(298, 294, 290, 287),
    299: polygen(299, 295, 293, 288),
    300: polygen(300, 293),
    301: polygen(301, 299, 296, 292),
    302: polygen(302, 261),
    303: polygen(303, 297, 291, 290),
    304: polygen(304, 303, 302, 293),
    305: polygen(305, 203),
    306: polygen(306, 305, 303, 299),
    307: polygen(307, 305, 303, 299),
    308: polygen(308, 306, 299, 293),
    309: polygen(309, 307, 302, 299),
    310: polygen(310, 309, 305, 302),
    311: polygen(311, 308, 306, 304),
    312: polygen(312, 307, 302, 301),
    313: polygen(313, 234),
    314: polygen(314, 299),
    315: polygen(315, 314, 306, 305),
    316: polygen(316, 181),
    317: polygen(317, 315, 313, 310),
    318: polygen(318, 313, 312, 310),
    319: polygen(319, 283),
    320: polygen(320, 319, 317, 316),
    321: polygen(321, 290),
    322: polygen(322, 255),
    323: polygen(323, 322, 320, 313),
    324: polygen(324, 321, 320, 318),
    325: polygen(325, 323, 320, 315),
    326: polygen(326, 325, 323, 316),
    327: polygen(327, 293),
    328: polygen(328, 323, 321, 319),
    329: polygen(329, 279),
    330: polygen(330, 328, 323, 322),
    331: polygen(331, 329, 325, 321),
    332: polygen(332, 209),
    333: polygen(333, 331),
    334: polygen(334, 333, 330, 327),
    335: polygen(335, 333, 328, 325),
    336: polygen(336, 335, 332, 329),
    337: polygen(337, 282),
    338: polygen(338, 336, 335, 332),
    339: polygen(339, 332, 329, 323),
    340: polygen(340, 337, 336, 329),
    341: polygen(341, 336, 330, 327),
    342: polygen(342, 217),
    343: polygen(343, 268),
    344: polygen(344, 338, 334, 333),
    345: polygen(345, 323),
    346: polygen(346, 344, 339, 335),
    347: polygen(347, 344, 337, 336),
    348: polygen(348, 344, 341, 340),
    349: polygen(349, 347, 344, 343),
    350: polygen(350, 297),
    351: polygen(351, 317),
    352: polygen(352, 346, 341, 339),
    353: polygen(353, 284),
    354: polygen(354, 349, 341, 340),
    355: polygen(355, 354, 350, 349),
    356: polygen(356, 349, 347, 346),
    357: polygen(357, 355, 347, 346),
    358: polygen(358, 351, 350, 344),
    359: polygen(359, 291),
    360: polygen(360, 359, 335, 334),
    361: polygen(361, 360, 357, 354),
    362: polygen(362, 299),
    363: polygen(363, 362, 356, 355),
    364: polygen(364, 297),
    365: polygen(365, 360, 359, 356),
    366: polygen(366, 337),
    367: polygen(367, 346),
    368: polygen(368, 361, 359, 351),
    369: polygen(369, 278),
    370: polygen(370, 231),
    371: polygen(371, 369, 368, 363),
    372: polygen(372, 369, 365, 357),
    373: polygen(373, 371, 366, 365),
    374: polygen(374, 369, 368, 366),
    375: polygen(375, 359),
    376: polygen(376, 371, 369, 368),
    377: polygen(377, 336),
    378: polygen(378, 335),
    379: polygen(379, 375, 370, 369),
    380: polygen(380, 333),
    381: polygen(381, 380, 379, 376),
    382: polygen(382, 301),
    383: polygen(383, 293),
    384: polygen(384, 378, 369, 368),
    385: polygen(385, 379),
    386: polygen(386, 303),
    387: polygen(387, 385, 379, 378),
    388: polygen(388, 387, 385, 374),
    389: polygen(389, 384, 380, 379),
    390: polygen(390, 301),
    391: polygen(391, 363),
    392: polygen(392, 386, 382, 379),
    393: polygen(393, 386),
    394: polygen(394, 259),
    395: polygen(395, 390, 389, 384),
    396: polygen(396, 371),
    397: polygen(397, 392, 387, 385),
    398: polygen(398, 393, 392, 384),
    399: polygen(399, 313),
    400: polygen(400, 398, 397, 395),
    401: polygen(401, 249),
    402: polygen(402, 399, 398, 393),
    403: polygen(403, 398, 395, 394),
    404: polygen(404, 215),
    405: polygen(405, 398, 397, 388),
    406: polygen(406, 249),
    407: polygen(407, 336),
    408: polygen(408, 407, 403, 401),
    409: polygen(409, 322),
    410: polygen(410, 407, 406, 400),
    411: polygen(411, 408, 401, 399),
    412: polygen(412, 265),
    413: polygen(413, 407, 406, 403),
    414: polygen(414, 405, 401, 398),
    415: polygen(415, 313),
    416: polygen(416, 414, 411, 407),
    417: polygen(417, 310),
    418: polygen(418, 417, 415, 403),
    419: polygen(419, 415, 414, 404),
    420: polygen(420, 412, 410, 407),
    421: polygen(421, 419, 417, 416),
    422: polygen(422, 273),
    423: polygen(423, 398),
    424: polygen(424, 422, 417, 415),
    425: polygen(425, 413),
    426: polygen(426, 415, 414, 412),
    427: polygen(427, 422, 421, 416),
    428: polygen(428, 323),
    429: polygen(429, 422, 421, 419),
    430: polygen(430, 419, 417, 415),
    431: polygen(431, 311),
    432: polygen(432, 429, 428, 419),
    433: polygen(433, 400),
    434: polygen(434, 429, 423, 422),
    435: polygen(435, 430, 426, 423),
    436: polygen(436, 271),
    437: polygen(437, 436, 435, 431),
    438: polygen(438, 373),
    439: polygen(439, 390),
    440: polygen(440, 439, 437, 436),
    441: polygen(441, 410),
    442: polygen(442, 440, 437, 435),
    443: polygen(443, 442, 437, 433),
    444: polygen(444, 435, 432, 431),
    445: polygen(445, 441, 439, 438),
    446: polygen(446, 341),
    447: polygen(447, 374),
    448: polygen(448, 444, 442, 437),
    449: polygen(449, 315),
    450: polygen(450, 371),
    451: polygen(451, 450, 441, 435),
    452: polygen(452, 448, 447, 446),
    453: polygen(453, 449, 447, 438),
    454: polygen(454, 449, 445, 444),
    455: polygen(455, 417),
    456: polygen(456, 454, 445, 433),
    457: polygen(457, 441),
    458: polygen(458, 255),
    459: polygen(459, 457, 454, 447),
    460: polygen(460, 399),
    461: polygen(461, 460, 455, 454),
    462: polygen(462, 389),
    463: polygen(463, 370),
    464: polygen(464, 460, 455, 441),
    465: polygen(465, 406),
    466: polygen(466, 460, 455, 452),
    467: polygen(467, 466, 461, 456),
    468: polygen(468, 464, 459, 453),
    469: polygen(469, 467, 464, 460),
    470: polygen(470, 321),
    471: polygen(471, 470),
    472: polygen(472, 470, 469, 461),
    473: polygen(473, 470, 467, 465),
    474: polygen(474, 283),
    475: polygen(475, 471, 467, 466),
    476: polygen(476, 461),
    477: polygen(477, 470, 462, 461),
    478: polygen(478, 357),
    479: polygen(479, 375),
    480: polygen(480, 473, 467, 464),
    481: polygen(481, 343),
    482: polygen(482, 477, 476, 473),
    483: polygen(483, 479, 477, 474),
    484: polygen(484, 379),
    485: polygen(485, 479, 469, 468),
    486: polygen(486, 481, 478, 472),
    487: polygen(487, 393),
    488: polygen(488, 487, 485, 484),
    489: polygen(489, 406),
    490: polygen(490, 271),
    491: polygen(491, 488, 485, 480),
    492: polygen(492, 491, 485, 484),
    493: polygen(493, 490, 488, 483),
    494: polygen(494, 357),
    495: polygen(495, 419),
    496: polygen(496, 494, 491, 480),
    497: polygen(497, 419),
    498: polygen(498, 495, 489, 487),
    499: polygen(499, 494, 493, 488),
    500: polygen(500, 499, 494, 490),
    501: polygen(501, 499, 497, 496),
    502: polygen(502, 498, 497, 494),
    503: polygen(503, 500),
    504: polygen(504, 502, 490, 483),
    505: polygen(505, 349),
    506: polygen(506, 411),
    507: polygen(507, 504, 501, 494),
    508: polygen(508, 399),
    509: polygen(509, 506, 502, 501),
    510: polygen(510, 501, 500, 498),
    511: polygen(511, 501),
    512: polygen(512, 510, 507, 504),
    513: polygen(513, 428),
    514: polygen(514, 511, 509, 507),
    515: polygen(515, 511, 508, 501),
    516: polygen(516, 514, 511, 509),
    517: polygen(517, 515, 507, 505),
    518: polygen(518, 485),
    519: polygen(519, 440),
    520: polygen(520, 509, 507, 503),
    521: polygen(521, 489),
    522: polygen(522, 518, 509, 507),
    523: polygen(523, 521, 517, 510),
    524: polygen(524, 357),
    525: polygen(525, 524, 521, 519),
    526: polygen(526, 525, 521, 517),
    527: polygen(527, 480),
    528: polygen(528, 526, 522, 517),
    529: polygen(529, 487),
    530: polygen(530, 527, 523, 520),
    531: polygen(531, 529, 525, 519),
    532: polygen(532, 531),
    533: polygen(533, 531, 530, 529),
    534: polygen(534, 533, 529, 527),
    535: polygen(535, 533, 529, 527),
    536: polygen(536, 533, 531, 529),
    537: polygen(537, 443),
    538: polygen(538, 537, 536, 533),
    539: polygen(539, 535, 534, 529),
    540: polygen(540, 361),
    541: polygen(541, 537, 531, 528),
    542: polygen(542, 540, 539, 533),
    543: polygen(543, 527),
    544: polygen(544, 538, 535, 531),
    545: polygen(545, 423),
    546: polygen(546, 545, 544, 538),
    547: polygen(547, 543, 540, 534),
    548: polygen(548, 545, 543, 538),
    549: polygen(549, 546, 545, 533),
    550: polygen(550, 357),
    551: polygen(551, 416),
    552: polygen(552, 550, 547, 532),
    553: polygen(553, 514),
    554: polygen(554, 551, 546, 543),
    555: polygen(555, 551, 546, 545),
    556: polygen(556, 403),
    557: polygen(557, 552, 551, 550),
    558: polygen(558, 553, 549, 544),
    559: polygen(559, 525),
    560: polygen(560, 554, 551, 549),
    561: polygen(561, 490),
    562: polygen(562, 560, 558, 551),
    563: polygen(563, 561, 554, 549),
    564: polygen(564, 401),
    565: polygen(565, 564, 559, 554),
    566: polygen(566, 413),
    567: polygen(567, 424),
    568: polygen(568, 558, 557, 551),
    569: polygen(569, 492),
    570: polygen(570, 503),
    571: polygen(571, 569, 566, 561),
    572: polygen(572, 571, 564, 560),
    573: polygen(573, 569, 567, 563),
    574: polygen(574, 561),
    575: polygen(575, 429),
    576: polygen(576, 573, 572, 563),
    577: polygen(577, 552),
    578: polygen(578, 562, 556, 555),
    579: polygen(579, 572, 570, 567),
    580: polygen(580, 579, 576, 574),
    581: polygen(581, 575, 574, 568),
    582: polygen(582, 497),
    583: polygen(583, 453),
    584: polygen(584, 581, 571, 570),
    585: polygen(585, 464),
    586: polygen(586, 584, 581, 579),
    587: polygen(587, 586, 581, 576),
    588: polygen(588, 437),
    589: polygen(589, 586, 585, 579),
    590: polygen(590, 497),
    591: polygen(591, 587, 585, 582),
    592: polygen(592, 591, 573, 568),
    593: polygen(593, 507),
    594: polygen(594, 575),
    595: polygen(595, 594, 593, 586),
    596: polygen(596, 592, 591, 590),
    597: polygen(597, 588, 585, 583),
    598: polygen(598, 597, 592, 591),
    599: polygen(599, 569),
    600: polygen(600, 599, 590, 589),
    601: polygen(601, 400),
    602: polygen(602, 596, 594, 591),
    603: polygen(603, 600, 599, 597),
    604: polygen(604, 600, 598, 589),
    605: polygen(605, 600, 598, 595),
    606: polygen(606, 602, 599, 591),
    607: polygen(607, 502),
    608: polygen(608, 606, 602, 585),
    609: polygen(609, 578),
    610: polygen(610, 483),
    611: polygen(611, 609, 607, 601),
    612: polygen(612, 607, 602, 598),
    613: polygen(613, 609, 603, 594),
    614: polygen(614, 613, 612, 607),
    615: polygen(615, 404),
    616: polygen(616, 614, 602, 597),
    617: polygen(617, 417),
    618: polygen(618, 615, 604, 598),
    619: polygen(619, 614, 611, 610),
    620: polygen(620, 619, 618, 611),
    621: polygen(621, 616, 615, 609),
    622: polygen(622, 325),
    623: polygen(623, 555),
    624: polygen(624, 617, 615, 612),
    625: polygen(625, 492),
    626: polygen(626, 623, 621, 613),
    627: polygen(627, 622, 617, 613),
    628: polygen(628, 405),
    629: polygen(629, 627, 624, 623),
    630: polygen(630, 628, 626, 623),
    631: polygen(631, 324),
    632: polygen(632, 629, 619, 613),
    633: polygen(633, 532),
    634: polygen(634, 319),
    635: polygen(635, 631, 625, 621),
    636: polygen(636, 632, 628, 623),
    637: polygen(637, 636, 628, 623),
    638: polygen(638, 637, 633, 632),
    639: polygen(639, 623),
    640: polygen(640, 638, 637, 626),
    641: polygen(641, 630),
    642: polygen(642, 523),
    643: polygen(643, 641, 640, 632),
    644: polygen(644, 634, 633, 632),
    645: polygen(645, 641, 637, 634),
    646: polygen(646, 397),
    647: polygen(647, 642),
    648: polygen(648, 647, 626, 625),
    649: polygen(649, 612),
    650: polygen(650, 647),
    651: polygen(651, 646, 638, 637),
    652: polygen(652, 559),
    653: polygen(653, 646, 645, 643),
    654: polygen(654, 649, 643, 640),
    655: polygen(655, 567),
    656: polygen(656, 646, 638, 637),
    657: polygen(657, 619),
    658: polygen(658, 603),
    659: polygen(659, 657, 655, 644),
    660: polygen(660, 657, 656, 648),
    661: polygen(661, 657, 650, 649),
    662: polygen(662, 365),
    663: polygen(663, 406),
    664: polygen(664, 662, 660, 649),
    665: polygen(665, 632),
    666: polygen(666, 664, 659, 656),
    667: polygen(667, 664, 660, 649),
    668: polygen(668, 658, 656, 651),
    669: polygen(669, 667, 665, 664),
    670: polygen(670, 517),
    671: polygen(671, 656),
    672: polygen(672, 667, 666, 661),
    673: polygen(673, 645),
    674: polygen(674, 671, 665, 660),
    675: polygen(675, 674, 672, 669),
    676: polygen(676, 435),
    677: polygen(677, 674, 673, 669),
    678: polygen(678, 675, 673, 663),
    679: polygen(679, 613),
    680: polygen(680, 679, 650, 645),
    681: polygen(681, 678, 672, 670),
    682: polygen(682, 681, 679, 675),
    683: polygen(683, 682, 677, 672),
    684: polygen(684, 681, 671, 666),
    685: polygen(685, 684, 682, 681),
    686: polygen(686, 489),
    687: polygen(687, 674),
    688: polygen(688, 682, 674, 669),
    689: polygen(689, 675),
    690: polygen(690, 687, 683, 680),
    691: polygen(691, 689, 685, 678),
    692: polygen(692, 393),
    693: polygen(693, 691, 685, 678),
    694: polygen(694, 691, 681, 677),
    695: polygen(695, 483),
    696: polygen(696, 694, 686, 673),
    697: polygen(697, 430),
    698: polygen(698, 483),
    699: polygen(699, 698, 689, 684),
    700: polygen(700, 698, 695, 694),
    701: polygen(701, 699, 697, 685),
    702: polygen(702, 665),
    703: polygen(703, 702, 696, 691),
    704: polygen(704, 701, 699, 692),
    705: polygen(705, 686),
    706: polygen(706, 697, 695, 692),
    707: polygen(707, 702, 699, 692),
    708: polygen(708, 421),
    709: polygen(709, 708, 706, 705),
    710: polygen(710, 709, 696, 695),
    711: polygen(711, 619),
    712: polygen(712, 709, 708, 707),
    713: polygen(713, 672),
    714: polygen(714, 691),
    715: polygen(715, 714, 711, 708),
    716: polygen(716, 533),
    717: polygen(717, 716, 710, 701),
    718: polygen(718, 717, 716, 713),
    719: polygen(719, 569),
    720: polygen(720, 718, 712, 709),
    721: polygen(721, 712),
    722: polygen(722, 491),
    723: polygen(723, 717, 710, 707),
    724: polygen(724, 719, 716, 711),
    725: polygen(725, 720, 719, 716),
    726: polygen(726, 721),
    727: polygen(727, 547),
    728: polygen(728, 726, 725, 724),
    729: polygen(729, 671),
    730: polygen(730, 583),
    731: polygen(731, 729, 725, 723),
    732: polygen(732, 729, 728, 725),
    733: polygen(733, 731, 726, 725),
    734: polygen(734, 724, 721, 720),
    735: polygen(735, 691),
    736: polygen(736, 730, 728, 723),
    737: polygen(737, 732),
    738: polygen(738, 391),
    739: polygen(739, 731, 723, 721),
    740: polygen(740, 587),
    741: polygen(741, 738, 733, 732),
    742: polygen(742, 741, 738, 730),
    743: polygen(743, 653),
    744: polygen(744, 743, 733, 731),
    745: polygen(745, 487),
    746: polygen(746, 395),
    747: polygen(747, 743, 741, 737),
    748: polygen(748, 744, 743, 733),
    749: polygen(749, 748, 743, 742),
    750: polygen(750, 746, 741, 734),
    751: polygen(751, 733),
    752: polygen(752, 749, 732, 731),
    753: polygen(753, 595),
    754: polygen(754, 735),
    755: polygen(755, 754, 745, 743),
    756: polygen(756, 407),
    757: polygen(757, 756, 751, 750),
    758: polygen(758, 757, 746, 741),
    759: polygen(759, 661),
    760: polygen(760, 757, 747, 734),
    761: polygen(761, 758),
    762: polygen(762, 679),
    763: polygen(763, 754, 749, 747),
    764: polygen(764, 761, 759, 758),
    765: polygen(765, 760, 755, 754),
    766: polygen(766, 757, 747, 744),
    767: polygen(767, 599),
    768: polygen(768, 764, 751, 749),
    769: polygen(769, 649),
    770: polygen(770, 768, 765, 756),
    771: polygen(771, 765, 756, 754),
    772: polygen(772, 765),
    773: polygen(773, 767, 765, 763),
    774: polygen(774, 589),
    775: polygen(775, 408),
    776: polygen(776, 773, 764, 759),
    777: polygen(777, 748),
    778: polygen(778, 403),
    779: polygen(779, 776, 771, 769),
    780: polygen(780, 775, 772, 764),
    781: polygen(781, 779, 765, 764),
    782: polygen(782, 453),
    783: polygen(783, 715),
    784: polygen(784, 778, 775, 771),
    785: polygen(785, 693),
    786: polygen(786, 782, 780, 771),
    1024: polygen(1024, 1015, 1002, 1001),
    2048: polygen(2048, 2035, 2034, 2029),
    4096: polygen(4096, 4095, 4081, 4069),
}
'''All polynomials combined, with a bias for 2-tap polynomials when present.'''
