# Pipeline result processor (PRP)

*A collection of tools for working with [JASEN](https://github.com/genomic-medicine-sweden/jasen) results or uploading it to the visualization tool [Bonsai](https://github.com/Clinical-Genomics-Lund/bonsai).*

> [!WARNING]
> Bonsai-PRP is under development in an alpha stage. Expect uneven documentation, breaking changes, and bugs until the official 1.0 release.

## Using prp

Use the help argument for information on prp's functions.

```
prp --help
```

PRP takes a file with information on the sample and paths to the individual results generated by JASEN as input. The sample file is created by default by JASEN during the analysis but can be modified or extended. An example of the input file can be found among [the test files](./tests/fixtures/saureus/sample_1.cnf.yml).

## Parse

This commands combines the JASEN output into serialized json object. This is good for backuping or computational analysis of the data.

```sh
prp parse --sample /path/to/sample.cnf.yml -o dump.json
```

### Validate output format of result json file

```
prp validate -o OUTPUT_FILE [-h]
```

### Create CDM input from pipeline data

Calculate quality metrics and present them in a format compatible with [CDM](https://github.com/SMD-Bioinformatics-Lund/cmd-data-management).

```sh
prp cdm --sample /path/to/sample.cnf.yml -o dump.json
```

## Upload a sample to Bonsai

Use the sample config to upload a sample to Bonsai.

The username and password can be set using either flags or by setting the environment variables `BONSAI_USER` and `BONSAI_PASSWD`.

```sh
prp upload                         \
  --sample /path/to/sample.cnf.yml \
  --api http://bonsai/api          \
  --username admin                 \
  --password secret                \
```

## The sample file

The sample file is generated by JASEN and catalogs the different output files. Additionally, the sample file can also contain information on how the sample should be presented in Bonsai. For example, which groups the sample should be added to or which IGV tacks should be available.

The `groups` field should be a list of the different *group_ids*. These are set when creating a group in Bonsai.

```yaml
groups:  # list of Bonsai groups to add the sample to
  - bonsai_group_id_1
  - bonsai_group_id_2
```

Use the `igv_annotations` field to add one or more IGV annoatation tracks. It should be a list of mappings, where each mapping should contian the fields `name`, `type` and `uri`. The name is the track name, the is the type of annotation track (*annotation*, *variant*, *alignment*) and URI is how to access the resource. See the [IGV documentation](https://igv.org/doc/igvjs/#tracks/Tracks/) for more information on the tracks and supported file formats.

```yaml
igv_annotations:  # list of IGV tracks
  - name: Cool variants
    type: variant
    uri: file://rs-fe1/path/to/variants.vcf
```