# Code of Conduct

We are committed to fostering a welcoming, inclusive, and respectful environment for everyone involved in this project. This Code of Conduct outlines the expected behaviors within our community and the steps for reporting unacceptable actions. By participating, you agree to uphold these standards, helping to create a positive and collaborative space.

---

## Our Pledge

As members, contributors, and leaders of this community, we pledge to:

* Ensure participation in our project is free from harassment, discrimination, or exclusion.
* Treat everyone with respect and empathy, regardless of factors such as age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity or expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual orientation.
* Act in ways that contribute to a safe, welcoming, and supportive environment for all participants.

---

## Our Standards

We strive to create an environment where all members can thrive. Examples of positive behaviors include:

* Showing kindness, empathy, and consideration for others.
* Being respectful of differing opinions, experiences, and perspectives.
* Providing constructive feedback in a supportive manner.
* Taking responsibility for mistakes, apologizing when necessary, and learning from experiences.
* Prioritizing the success and well-being of the entire community over individual gains.

The following behaviors are considered unacceptable:

* Using sexualized language or imagery, or engaging in inappropriate sexual attention or advances.
* Making insulting, derogatory, or inflammatory comments, including trolling or personal attacks.
* Engaging in harassment, whether public or private.
* Publishing private or sensitive information about others without explicit consent.
* Engaging in behavior that disrupts discussions, events, or contributions in a negative way.
* Any conduct that could reasonably be deemed unprofessional or harmful to others.

---

## Scope

This Code of Conduct applies to all areas of interaction within the community, including but not limited to:

* Discussions on forums, repositories, or other official communication channels.
* Contributions made to the project, such as code, documentation, or issues.
* Public representation of the community, such as through official social media accounts or at events.

It also applies to actions outside these spaces if they negatively impact the health, safety, or inclusivity of the community.

---

## Enforcement Responsibilities

Community leaders are responsible for ensuring that this Code of Conduct is upheld. They may take appropriate and fair corrective actions in response to any behavior that violates these standards, including:

* Removing, editing, or rejecting comments, commits, issues, or other contributions not aligned with the Code of Conduct.
* Temporarily or permanently banning individuals for repeated or severe violations.

Leaders will always strive to communicate their decisions clearly and fairly.

---

## Reporting Issues

If you experience or witness unacceptable behavior, please report it to the project's owner [Roberto Rodriguez](https://www.linkedin.com/in/cyb3rward0g/). Your report will be handled with sensitivity, and we will respect your privacy and confidentiality while addressing the issue.

When reporting, please include:

* A description of the incident.
* When and where it occurred.
* Any additional context or supporting evidence, if available.

---

## Enforcement Process

We encourage resolving issues through dialogue when possible, but community leaders will intervene when necessary. Actions may include warnings, temporary bans, or permanent removal from the community, depending on the severity of the behavior.

---

## Attribution
This Code of Conduct is inspired by the [Contributor Covenant, version 2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html) and has drawn inspiration from open source community guidelines by Microsoft, Mozilla, and others.

For further context on best practices for open source codes of conduct, see the [Contributor Covenant FAQ](https://www.contributor-covenant.org/faq).

---

Thank you for helping to create a positive environment! ❤️