import argparse
import os
from typing import Final

import uvicorn
from dotenv import load_dotenv

from .app import app

load_dotenv()

DEFAULT_PORT: Final[int] = int(os.getenv("DEEPBRIEF_PORT", "8080"))
DEFAULT_HOST: Final[str] = os.getenv("DEEPBRIEF_HOST", "0.0.0.0")

__all__ = ["app", "main"]


def main() -> None:
    """CLI entrypoint for launching the FastAPI+Dapr runtime."""

    parser = argparse.ArgumentParser(description="DeepBrief Workflow API")
    parser.add_argument(
        "--port",
        type=int,
        default=DEFAULT_PORT,
        help=f"Port to listen on (default: {DEFAULT_PORT}).",
    )
    parser.add_argument(
        "--host",
        default=DEFAULT_HOST,
        help=f"Host interface to bind to (default: {DEFAULT_HOST}).",
    )
    args = parser.parse_args()

    uvicorn.run(app, host=args.host, port=args.port)
