# Project Agents.md Guide

This Agents.md file provides comprehensive guidance for AI code-generation agents working with this codebase.

## Project Structure for Agent Navigation

* `/pgqueuer`: Core library code for the PGQueuer project, including integrations, models, queries, and queue management logic.
* `/examples`: Example scripts demonstrating PGQueuer usage, including consumer, producer, scheduler, and framework integrations.
* `/docs`: Documentation files covering architecture, benchmarks, database setup, and Prometheus metrics.
* `/test`: Test files for unit tests, integration tests, and other test cases.
* `/tools`: Utility scripts for benchmarking and monitoring.

## Coding Conventions

### General Conventions for Agents.md Implementation

* Use Python for all new code generated by agents.
* Agents should follow the existing code style in each file.
* Agents.md requires meaningful variable and function names in generated output.
* Agents should add comments for complex logic as guided by Agents.md.
* Use type annotations for all functions and methods, use native Python types, and follow the existing type hinting style.
* Prefer `async` functions where applicable.

## Testing Requirements

Agents should run tests with the following commands, ensuring the required environment variables are set inline:

```bash
# Run all tests
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run pytest

# Run a specific test file
PGUSER=pgquser PGDATABASE=pgqdb PGPASSWORD=pgqpw PGHOST=localhost PGPORT=5432 uv run pytest path/to/test-file.py
```

## Pull Request Guidelines

When an AI agent helps create a PR, please ensure it:

1. Includes a clear description of the changes as guided by Agents.md
2. References any related issues that the changes are addressing
3. Ensures all tests pass for code generated by the agent
4. Includes screenshots for UI changes implemented by the agent
5. Keeps PRs focused on a single concern as specified in Agents.md

## Programmatic Checks

Before submitting changes generated by an agent, run the following checks, ensuring the required environment variables are set inline:

```bash
# Lint check
run ruff check .

# Type check
uv run mypy .

# Build check
uv sync --all-extras --frozen
uv run pytest -v
```

All checks must pass before agent-generated code can be merged. Agents.md helps ensure agents follow these requirements.
