from . import base as BASE_CT
# BC Consts:
from ..bc.base import BCct as BC_CT

SB_ID = BASE_CT.SB_ID
EE_ID = BASE_CT.EE_ID
EE_ADDR = 'EE_ADDR'

HOST = 'HOST'
TOPIC = 'TOPIC'
BROKER = 'BROKER'
PORT = 'PORT'
USER = 'USER'
PASS = 'PASS'
CERT_PATH = 'CERT_PATH'
VHOST = 'VHOST'
DEVICE_ID = 'DEVICE_ID'
ROUTING_KEY = 'ROUTING_KEY'
QOS = 'QOS'
SECURED = 'SECURED'
SUBTOPIC = 'SUBTOPIC'

DEFAULT_SUBTOPIC_VALUE = 'address'

EXCHANGE = 'EXCHANGE'
EXCHANGE_TYPE = 'EXCHANGE_TYPE'
QUEUE = 'QUEUE'
QUEUE_DURABLE = 'QUEUE_DURABLE'
QUEUE_EXCLUSIVE = 'QUEUE_EXCLUSIVE'
QUEUE_DEVICE_SPECIFIC = 'QUEUE_DEVICE_SPECIFIC'

COMMUNICATION_CONFIG_CHANNEL = 'CONFIG_CHANNEL'
COMMUNICATION_PAYLOADS_CHANNEL = 'PAYLOADS_CHANNEL'
COMMUNICATION_CTRL_CHANNEL = 'CTRL_CHANNEL'
COMMUNICATION_NOTIF_CHANNEL = 'NOTIF_CHANNEL'
COMMUNICATION_VALID_CHANNELS = [
    COMMUNICATION_CONFIG_CHANNEL, COMMUNICATION_PAYLOADS_CHANNEL,
    COMMUNICATION_CTRL_CHANNEL, COMMUNICATION_NOTIF_CHANNEL
]
COMMUNICATION_DEFAULT = 'DEFAULT'
COMMUNICATION_COMMAND_AND_CONTROL = 'COMMANDCONTROL'
COMMUNICATION_HEARTBEATS = 'HEARTBEATS'
COMMUNICATION_NOTIFICATIONS = 'NOTIFICATIONS'
COMMUNICATION_VALID_TYPES = [
    COMMUNICATION_DEFAULT, COMMUNICATION_COMMAND_AND_CONTROL,
    COMMUNICATION_HEARTBEATS, COMMUNICATION_NOTIFICATIONS
]


class TIMERS:
  TIMER_SEND_BUFFER_PAYLOAD = 'send_buffer_payload'


class COMM_SEND_MESSAGE:
  K_ACTION = 'ACTION'
  K_PAYLOAD = 'PAYLOAD'
  K_EE_ID = EE_ID
  K_INITIATOR_ID = 'INITIATOR_ID'
  K_SESSION_ID = 'SESSION_ID'
  K_SENDER_ADDR = BC_CT.SENDER
  K_TIME = 'TIME'
  K_EE_IS_ENCRYPTED = "EE_IS_ENCRYPTED"
  K_EE_ENCRYPTED_DATA = "EE_ENCRYPTED_DATA"

  ACTION_VALUE_PAYLOAD = K_PAYLOAD


class COMM_RECV_MESSAGE:
  K_ACTION = COMM_SEND_MESSAGE.K_ACTION
  K_PAYLOAD = COMM_SEND_MESSAGE.K_PAYLOAD
  K_EE_ID = COMM_SEND_MESSAGE.K_EE_ID
  K_INITIATOR_ID = COMM_SEND_MESSAGE.K_INITIATOR_ID
  K_SESSION_ID = COMM_SEND_MESSAGE.K_SESSION_ID
  K_SENDER_ADDR = COMM_SEND_MESSAGE.K_SENDER_ADDR
  K_EE_IS_ENCRYPTED = COMM_SEND_MESSAGE.K_EE_IS_ENCRYPTED
  K_EE_ENCRYPTED_DATA = COMM_SEND_MESSAGE.K_EE_ENCRYPTED_DATA

  K_VALIDATED = 'VALIDATED'  # this is a flag to indicate if the message was validated or not


COMM_SEND_BUFFER = 100
COMM_RECV_BUFFER = 100
COMM_SECS_SHOW_INFO = 180
