# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.run import Run
from .messages.client import AsyncMessagesClient, MessagesClient
from .raw_client import AsyncRawRunsClient, RawRunsClient
from .steps.client import AsyncStepsClient, StepsClient
from .usage.client import AsyncUsageClient, UsageClient


class RunsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRunsClient(client_wrapper=client_wrapper)
        self.messages = MessagesClient(client_wrapper=client_wrapper)

        self.usage = UsageClient(client_wrapper=client_wrapper)

        self.steps = StepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRunsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.list()
        """
        _response = self._raw_client.list(agent_ids=agent_ids, request_options=request_options)
        return _response.data

    def list_active(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all active runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.list_active()
        """
        _response = self._raw_client.list_active(agent_ids=agent_ids, request_options=request_options)
        return _response.data

    def retrieve(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Get the status of a run.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.retrieve(
            run_id="run_id",
        )
        """
        _response = self._raw_client.retrieve(run_id, request_options=request_options)
        return _response.data

    def delete(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Delete a run by its run_id.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.delete(
            run_id="run_id",
        )
        """
        _response = self._raw_client.delete(run_id, request_options=request_options)
        return _response.data


class AsyncRunsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRunsClient(client_wrapper=client_wrapper)
        self.messages = AsyncMessagesClient(client_wrapper=client_wrapper)

        self.usage = AsyncUsageClient(client_wrapper=client_wrapper)

        self.steps = AsyncStepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRunsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(agent_ids=agent_ids, request_options=request_options)
        return _response.data

    async def list_active(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all active runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.list_active()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_active(agent_ids=agent_ids, request_options=request_options)
        return _response.data

    async def retrieve(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Get the status of a run.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.retrieve(
                run_id="run_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(run_id, request_options=request_options)
        return _response.data

    async def delete(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Delete a run by its run_id.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.delete(
                run_id="run_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(run_id, request_options=request_options)
        return _response.data
