# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.provider_trace import ProviderTrace
from .raw_client import AsyncRawTelemetryClient, RawTelemetryClient


class TelemetryClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTelemetryClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTelemetryClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTelemetryClient
        """
        return self._raw_client

    def retrieve_provider_trace(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderTrace:
        """
        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderTrace
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.telemetry.retrieve_provider_trace(
            step_id="step_id",
        )
        """
        _response = self._raw_client.retrieve_provider_trace(step_id, request_options=request_options)
        return _response.data


class AsyncTelemetryClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTelemetryClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTelemetryClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTelemetryClient
        """
        return self._raw_client

    async def retrieve_provider_trace(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderTrace:
        """
        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderTrace
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.telemetry.retrieve_provider_trace(
                step_id="step_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_provider_trace(step_id, request_options=request_options)
        return _response.data
