# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .agents.client import AgentsClient, AsyncAgentsClient
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient
from .types.templates_list_response import TemplatesListResponse


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)
        self.agents = AgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        limit : typing.Optional[str]

        name : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.list()
        """
        _response = self._raw_client.list(
            offset=offset, limit=limit, name=name, project_id=project_id, request_options=request_options
        )
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        limit : typing.Optional[str]

        name : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            offset=offset, limit=limit, name=name, project_id=project_id, request_options=request_options
        )
        return _response.data
