# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .agent_schema_tool_rules_item import AgentSchemaToolRulesItem
from .core_memory_block_schema import CoreMemoryBlockSchema
from .embedding_config import EmbeddingConfig
from .llm_config import LlmConfig
from .message_schema import MessageSchema
from .tag_schema import TagSchema
from .tool_env_var_schema import ToolEnvVarSchema
from .tool_schema import ToolSchema


class AgentSchema(UncheckedBaseModel):
    agent_type: str
    core_memory: typing.List[CoreMemoryBlockSchema]
    created_at: str
    description: typing.Optional[str] = None
    embedding_config: EmbeddingConfig
    llm_config: LlmConfig
    message_buffer_autoclear: bool
    in_context_message_indices: typing.List[int]
    messages: typing.List[MessageSchema]
    metadata: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="metadata_")
    ] = None
    multi_agent_group: typing.Optional[typing.Any] = None
    name: str
    system: str
    tags: typing.List[TagSchema]
    tool_exec_environment_variables: typing.List[ToolEnvVarSchema]
    tool_rules: typing.List[AgentSchemaToolRulesItem]
    tools: typing.List[ToolSchema]
    updated_at: str
    version: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
