# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .message import Message
from .step_feedback import StepFeedback
from .stop_reason_type import StopReasonType


class Step(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The id of the step. Assigned by the database.
    """

    origin: typing.Optional[str] = pydantic.Field(default=None)
    """
    The surface that this agent step was initiated from.
    """

    provider_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the provider that was configured for this step
    """

    job_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the job that this step belongs to. Only included for async calls.
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the agent that performed the step.
    """

    provider_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the provider used for this step.
    """

    provider_category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The category of the provider used for this step.
    """

    model: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the model used for this step.
    """

    model_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    The model endpoint url used for this step.
    """

    context_window_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The context window limit configured for this step.
    """

    completion_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of tokens generated by the agent during this step.
    """

    prompt_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of tokens in the prompt during this step.
    """

    total_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of tokens processed by the agent during this step.
    """

    completion_tokens_details: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(
        default=None
    )
    """
    Metadata for the agent.
    """

    stop_reason: typing.Optional[StopReasonType] = pydantic.Field(default=None)
    """
    The stop reason associated with the step.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Metadata tags.
    """

    tid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the transaction that processed this step.
    """

    trace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The trace id of the agent step.
    """

    messages: typing.Optional[typing.List[Message]] = pydantic.Field(default=None)
    """
    The messages generated during this step.
    """

    feedback: typing.Optional[StepFeedback] = pydantic.Field(default=None)
    """
    The feedback for this step. Must be either 'positive' or 'negative'.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The project that the agent that executed this step belongs to (cloud only).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
