# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .tool_return_status import ToolReturnStatus


class ToolReturn(UncheckedBaseModel):
    status: ToolReturnStatus = pydantic.Field()
    """
    The status of the tool call
    """

    stdout: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Captured stdout (e.g. prints, logs) from the tool invocation
    """

    stderr: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Captured stderr from the tool invocation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
