import { PolicyStatement, IRole } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
export interface IDummyTaskDefinition {
    readonly executionRole: IRole;
    readonly family: string;
    readonly taskDefinitionArn: string;
}
export interface DummyTaskDefinitionProps {
    readonly family?: string;
    readonly image: string;
    readonly containerPort?: number;
}
export declare class DummyTaskDefinition extends Construct implements IDummyTaskDefinition {
    readonly executionRole: IRole;
    readonly family: string;
    readonly taskDefinitionArn: string;
    readonly containerPort: number;
    constructor(scope: Construct, id: string, props: DummyTaskDefinitionProps);
    /**
     * Adds a policy statement to the task execution IAM role.
     */
    addToExecutionRolePolicy(statement: PolicyStatement): void;
}
