Attribute VB_Name = "FemtetMacro"
Option Explicit

Dim Femtet As New CFemtet
Dim Als As CAnalysis
Dim BodyAttr As CBodyAttribute
Dim Bnd As CBoundary
Dim Mtl As CMaterial
Dim Gaudi As CGaudi
Dim Gogh As CGogh
'/////////////////////////null***̐/////////////////////////
'//L̎l̕ϐCGaudiNXMulti***gpꍇɗp܂B
'//ႦMultiFilletgpꍇɈłVertex(_)͎w肹
'//Edge()FilletꍇnullVertex()p܂B
'//uGaudi.MultiFillet nullVertex,EdgevƂ
'//EdgeFillet邱Ƃł܂B
'/////////////////////////////////////////////////////////////
Global nullVertex() As CGaudiVertex
Global nullEdge() As CGaudiEdge
Global nullFace() As CGaudiFace
Global nullBody() As CGaudiBody

'///////////////////////////////////////////////////

'ϐ̐錾
Private pi as Double
Private c_pi as Double
Private section_radius as Double
Private coil_radius as Double
Private helical_pitch as Double
Private spiral_pitch as Double
Private n_turns as Double
'///////////////////////////////////////////////////


'////////////////////////////////////////////////////////////
'    Main֐
'////////////////////////////////////////////////////////////
Sub FemtetMain() 
    '------- FemtetN (svȏꍇExcelŎsȂꍇ͉sRgAEgĂ) -------
    Workbooks("FemtetRef.xla").AutoExecuteFemtet

    '------- VKvWFNg -------
    If Femtet.OpenNewProject() = False Then
        Femtet.ShowLastError
    End If

    '------- ϐ̒` -------
    InitVariables

    '------- f[^x[X̐ݒ -------
    AnalysisSetUp
    BodyAttributeSetUp
    MaterialSetUp
    BoundarySetUp

    '------- f̍쐬 -------
    Set Gaudi = Femtet.Gaudi
    MakeModel

    '------- WbVTCY̐ݒ -------
    '<<<<<<< vZɐݒ肷ꍇ-1ݒ肵Ă >>>>>>>
    Gaudi.MeshSize = 2.0

    '------- vWFNg̕ۑ -------
    Dim ProjectFilePath As String
    ProjectFilePath = "E:\pyfemtet\pyfemtet\pyfemtet\opt\meta_script\sample\sample"
    '<<<<<<< vWFNgۑꍇ͈ȉ̃RgOĂ >>>>>>>
    'If Femtet.SaveProject(ProjectFilePath & ".femprj", True) = False Then
    '    Femtet.ShowLastError
    'End If

    '------- bV̐ -------
    '<<<<<<< bV𐶐ꍇ͈ȉ̃RgOĂ >>>>>>>
    'Gaudi.Mesh

    '------- ͂̎s -------
    '<<<<<<< ͂sꍇ͈ȉ̃RgOĂ >>>>>>>
    'Femtet.Solve

    '------- ͌ʂ̒o -------
    '<<<<<<< vZʂ𒊏oꍇ͈ȉ̃RgOĂ >>>>>>>
    'SamplingResult

    '------- vZʂ̕ۑ -------
    '<<<<<<< vZ(.pdt)t@Cۑꍇ͈ȉ̃RgOĂ >>>>>>>
    'If Femtet.SavePDT(Femtet.ResultFilePath & ".pdt", True) = False Then
    '    Femtet.ShowLastError
    'End If

End Sub

'////////////////////////////////////////////////////////////
'    ͏̐ݒ
'////////////////////////////////////////////////////////////
Sub AnalysisSetUp()

    '------- ϐɃIuWFNg̐ݒ -------
    Set Als = Femtet.Analysis

    '------- ͏(Common) -------
    Als.AnalysisType = GAUSS_C

    '------- (Gauss) -------
    Als.Gauss.b2ndEdgeElement = True

    '------- dg(Hertz) -------
    Als.Hertz.b2ndEdgeElement = True

    '------- d(Rayleigh) -------
    Als.Rayleigh.bConstantTemp = True

    '------- JE(Open) -------
    Als.Open.OpenMethod = ABC_C
    Als.Open.ABCOrder = ABC_2ND_C

    '------- a(Harmonic) -------
    Als.Harmonic.FreqSweepType = LINEAR_INTERVAL_C

    '------- gH(WaveGuide) -------
    Als.WaveGuide.Result = FREQUENCY_C

    '------- xȐݒ(HighLevel) -------
    Als.HighLevel.nNonL = (20)
    Als.HighLevel.bATS = False
    Als.HighLevel.FactorType = RADIO_ANALYTICAL_C
    Als.HighLevel.bUseDeathMaterial = False

    '------- bV̐ݒ(MeshProperty) -------
    Als.MeshProperty.nMGElementIncRate = (50)
    Als.MeshProperty.nMG = (100)
    Als.MeshProperty.nMaxAdaptive = (10)
    Als.MeshProperty.nMaxAdaptivePort = (15)
    Als.MeshProperty.AdaptiveTolPort = (1.0) * 10 ^ (-2)
    Als.MeshProperty.AdaptiveEnergyType = IND_C
    Als.MeshProperty.bAutoAir = True
    Als.MeshProperty.AutoAirMeshSize = (22.77826356331989)
    Als.MeshProperty.bChangePlane = True
    Als.MeshProperty.bMeshG2 = True
    Als.MeshProperty.bPeriodMesh = False

    '------- Xebvݒ(StepAnalysis) -------
    Als.StepAnalysis.bSetTime = True
    Als.StepAnalysis.Set_Table_withTime 0, (1.0), (20), (0.0)
    Als.StepAnalysis.BreakStep = (100)

    '------- ꍂ(LuvensSteadyState) -------
    Als.LuvensSteadyState.nEocn = (1000)

    '------- (Bernoulli) -------
    Als.Bernoulli.TurbulentModel = STANDARD_K_EPSILON_C
End Sub

'////////////////////////////////////////////////////////////
'    BodyŜ̐ݒ
'////////////////////////////////////////////////////////////
Sub BodyAttributeSetUp()

    '------- ϐɃIuWFNg̐ݒ -------
    Set BodyAttr = Femtet.BodyAttribute

    '------- Body̐ݒ -------
    BodyAttributeSetUp_Coil

    '+++++++++++++++++++++++++++++++++++++++++
    '++gpĂȂBodyAttributef[^ł
    '++gpۂ̓RgOĉ
    '+++++++++++++++++++++++++++++++++++++++++
    'BodyAttributeSetUp_Fe
    'BodyAttributeSetUp_Air
    'BodyAttributeSetUp_Air_Auto
End Sub

'////////////////////////////////////////////////////////////
'    Body̐ݒ BodyFCoil
'////////////////////////////////////////////////////////////
Sub BodyAttributeSetUp_Coil()
    '------- BodyIndexۑϐ -------
    Dim Index As Integer

    '------- Body̒ǉ -------
    BodyAttr.Add "Coil" 

    '------- Body Index̐ݒ -------
    Index = BodyAttr.Ask ( "Coil" ) 

    '------- V[g{fB̌ or 2͂̉s(BodyThickness)/C[{fB(WireWidth) -------
    BodyAttr.Length(Index).bUseAnalysisThickness2D = False
    BodyAttr.Length(Index).BodyThickness = (1.0) * 10 ^ (-3)

    '------- d(Current) -------
    BodyAttr.Current(Index).I = (1)

    '------- g`(Waveform) -------
    BodyAttr.Current(Index).CurrentDirType = COIL_NORMAL_INOUTFLOW_INTERNAL_C
    BodyAttr.Current(Index).InFaceBodyKey = 0
    BodyAttr.Current(Index).InFaceTopolID = 26
    BodyAttr.Current(Index).OutFaceBodyKey = 0
    BodyAttr.Current(Index).OutFaceTopolID = 37

    '------- x(InitialVelocity) -------
    BodyAttr.InitialVelocity(Index).bAnalysisUse = False

    '------- d(Electrode) -------
    BodyAttr.Electrode(Index).ElectricCondition = VOLT_C

    '------- t(Emittivity) -------
    BodyAttr.ThermalSurface(Index).Emittivity.Eps = (0.8)
End Sub

'////////////////////////////////////////////////////////////
'    Body̐ݒ BodyFFe
'////////////////////////////////////////////////////////////
Sub BodyAttributeSetUp_Fe()
    '------- BodyIndexۑϐ -------
    Dim Index As Integer

    '------- Body̒ǉ -------
    BodyAttr.Add "Fe" 

    '------- Body Index̐ݒ -------
    Index = BodyAttr.Ask ( "Fe" ) 

    '------- V[g{fB̌ or 2͂̉s(BodyThickness)/C[{fB(WireWidth) -------
    BodyAttr.Length(Index).bUseAnalysisThickness2D = False
    BodyAttr.Length(Index).BodyThickness = (1.0) * 10 ^ (-3)

    '------- x(InitialVelocity) -------
    BodyAttr.InitialVelocity(Index).bAnalysisUse = False

    '------- d(Electrode) -------
    BodyAttr.Electrode(Index).ElectricCondition = VOLT_C

    '------- t(Emittivity) -------
    BodyAttr.ThermalSurface(Index).Emittivity.Eps = (0.8)
End Sub

'////////////////////////////////////////////////////////////
'    Body̐ݒ BodyFAir
'////////////////////////////////////////////////////////////
Sub BodyAttributeSetUp_Air()
    '------- BodyIndexۑϐ -------
    Dim Index As Integer

    '------- Body̒ǉ -------
    BodyAttr.Add "Air" 

    '------- Body Index̐ݒ -------
    Index = BodyAttr.Ask ( "Air" ) 

    '------- V[g{fB̌ or 2͂̉s(BodyThickness)/C[{fB(WireWidth) -------
    BodyAttr.Length(Index).bUseAnalysisThickness2D = False
    BodyAttr.Length(Index).BodyThickness = (1.0) * 10 ^ (-3)

    '------- x(InitialVelocity) -------
    BodyAttr.InitialVelocity(Index).bAnalysisUse = False

    '------- d(Electrode) -------
    BodyAttr.Electrode(Index).ElectricCondition = VOLT_C

    '------- (FluidBern) -------
    BodyAttr.FluidAttribute(Index).FlowCondition.bSpline = True

    '------- t(Emittivity) -------
    BodyAttr.ThermalSurface(Index).Emittivity.Eps = (0.8)
End Sub

'////////////////////////////////////////////////////////////
'    Body̐ݒ BodyFAir_Auto
'////////////////////////////////////////////////////////////
Sub BodyAttributeSetUp_Air_Auto()
    '------- BodyIndexۑϐ -------
    Dim Index As Integer

    '------- Body̒ǉ -------
    BodyAttr.Add "Air_Auto" 

    '------- Body Index̐ݒ -------
    Index = BodyAttr.Ask ( "Air_Auto" ) 

    '------- V[g{fB̌ or 2͂̉s(BodyThickness)/C[{fB(WireWidth) -------
    BodyAttr.Length(Index).bUseAnalysisThickness2D = True

    '------- ͗̈(ActiveSolver) -------
    BodyAttr.ActiveSolver(Index).bWatt = False
    BodyAttr.ActiveSolver(Index).bGalileo = False

    '------- x(InitialVelocity) -------
    BodyAttr.InitialVelocity(Index).bAnalysisUse = True

    '------- Xe[^/[^(StatorRotor) -------
    BodyAttr.StatorRotor(Index).State = AIR_C

    '------- t(Emittivity) -------
    BodyAttr.ThermalSurface(Index).Emittivity.Eps = (0.8)
End Sub

'////////////////////////////////////////////////////////////
'    MaterialŜ̐ݒ
'////////////////////////////////////////////////////////////
Sub MaterialSetUp()

    '------- ϐɃIuWFNg̐ݒ -------
    Set Mtl = Femtet.Material

    '------- Material̐ݒ -------
    MaterialSetUp_008_Copper

    '+++++++++++++++++++++++++++++++++++++++++
    '++gpĂȂMaterialf[^ł
    '++gpۂ̓RgOĉ
    '+++++++++++++++++++++++++++++++++++++++++
    'MaterialSetUp_Air_Auto
End Sub

'////////////////////////////////////////////////////////////
'    Material̐ݒ MaterialF008_Copper
'////////////////////////////////////////////////////////////
Sub MaterialSetUp_008_Copper()
    '------- MaterialIndexۑϐ -------
    Dim Index As Integer

    '------- Material̒ǉ -------
    Mtl.Add "008_Copper" 

    '------- Material Index̐ݒ -------
    Index = Mtl.Ask ( "008_Copper" ) 

    '------- (Permeability) -------
    Mtl.Permeability(Index).BHExtrapolationType = BH_GRADIENT_LASTTWOPOINT_C

    '------- R(Resistivity) -------
    Mtl.Resistivity(Index).sRho = (1.673) * 10 ^ (-8)
    Mtl.Resistivity(Index).Set_mRho 0, (1.0)
    Mtl.Resistivity(Index).Set_mRho 2, (1.0)
    Mtl.Resistivity(Index).Set_mRho 5, (1.0)
    Mtl.Resistivity(Index).Set_Table 0, (-195), (0.2) * 10 ^ (-8)
    Mtl.Resistivity(Index).Set_Table 1, (0), (1.55) * 10 ^ (-8)
    Mtl.Resistivity(Index).Set_Table 2, (100), (2.23) * 10 ^ (-8)
    Mtl.Resistivity(Index).Set_Table 3, (300), (3.6) * 10 ^ (-8)
    Mtl.Resistivity(Index).Set_Table 4, (700), (6.7) * 10 ^ (-8)

    '------- d(ElectricConductivity) -------
    Mtl.ElectricConductivity(Index).ConductorType = CONDUCTOR_C
    Mtl.ElectricConductivity(Index).sSigma = (5.977) * 10 ^ (7)

    '------- M(SpecificHeat) -------
    Mtl.SpecificHeat(Index).C = (0.385075378466) * 10 ^ (3)
    Mtl.SpecificHeat(Index).Set_Table 0, (-173), (0.2533597708746) * 10 ^ (3)
    Mtl.SpecificHeat(Index).Set_Table 1, (-73), (0.3575362729361) * 10 ^ (3)
    Mtl.SpecificHeat(Index).Set_Table 2, (20), (0.385075378466) * 10 ^ (3)
    Mtl.SpecificHeat(Index).Set_Table 3, (127), (0.3997104459761) * 10 ^ (3)
    Mtl.SpecificHeat(Index).Set_Table 4, (327), (0.4217417304) * 10 ^ (3)

    '------- x(Density) -------
    Mtl.Density(Index).Dens = (8.96) * 10 ^ (3)

    '------- M`(ThermalConductivity) -------
    Mtl.ThermalConductivity(Index).sRmd = (401.9999999999999)
    Mtl.ThermalConductivity(Index).Set_Table 0, (-173), (482)
    Mtl.ThermalConductivity(Index).Set_Table 1, (-73), (415.0000000000001)
    Mtl.ThermalConductivity(Index).Set_Table 2, (27), (401.9999999999999)
    Mtl.ThermalConductivity(Index).Set_Table 3, (127), (393)
    Mtl.ThermalConductivity(Index).Set_Table 4, (227), (387)

    '------- cW(Expansion) -------
    Mtl.Expansion(Index).sAlf = (1.65) * 10 ^ (-5)
    Mtl.Expansion(Index).Set_vAlf 0, (0.0)
    Mtl.Expansion(Index).Set_vAlf 1, (0.0)
    Mtl.Expansion(Index).Set_vAlf 2, (0.0)

    '------- e萔(Elasticity) -------
    Mtl.Elasticity(Index).sY = (123) * 10 ^ (9)
    Mtl.Elasticity(Index).Nu = (0.35)

    '------- d萔(PiezoElectricity) -------
    Mtl.PiezoElectricity(Index).bPiezo = False

    '------- (SoundVelocity) -------
    Mtl.SoundVelocity(Index).Vel0 = (331.0)

    '------- Sx(Viscosity) -------
    Mtl.Viscosity(Index).Mu = (1.002) * 10 ^ (-3)

    '------- (Magnetize) -------
    Mtl.Magnetize(Index).MagRatioType = MAGRATIO_BR_C

    '-------  -------
    Mtl.Comment(Index).Comment = "soTt " & Chr(13) & Chr(10) & "@xF [C2]P.26" & Chr(13) & Chr(10) & "@e萔F [C2]P.26" & Chr(13) & Chr(10) & "@cWF [S]P.484" & Chr(13) & Chr(10) & "@F [C2]P.507" & Chr(13) & Chr(10) & "@RF [C2]P.490, [S]P.527" & Chr(13) & Chr(10) & "@MF [S]P.473" & Chr(13) & Chr(10) & "@M`F [C2]P.70" & Chr(13) & Chr(10) & "@@" & Chr(13) & Chr(10) & "sQlt@" & Chr(13) & Chr(10) & "@[C2] w֗ bII 4 {ww ۑP(1993)" & Chr(13) & Chr(10) & "@[S] ȔN\ 8N V ۑP(1996)"
End Sub

'////////////////////////////////////////////////////////////
'    Material̐ݒ MaterialFAir_Auto
'////////////////////////////////////////////////////////////
Sub MaterialSetUp_Air_Auto()
    '------- MaterialIndexۑϐ -------
    Dim Index As Integer

    '------- Material̒ǉ -------
    Mtl.Add "Air_Auto" 

    '------- Material Index̐ݒ -------
    Index = Mtl.Ask ( "Air_Auto" ) 

    '------- Ud(Permittivity) -------
    Mtl.Permittivity(Index).sEps = (1.000517)

    '------- ő/(SolidFluid) -------
    Mtl.SolidFluid(Index).State = FLUID_C
End Sub

'////////////////////////////////////////////////////////////
'    BoundaryŜ̐ݒ
'////////////////////////////////////////////////////////////
Sub BoundarySetUp()

    '------- ϐɃIuWFNg̐ݒ -------
    Set Bnd = Femtet.Boundary

    '------- Boundary̐ݒ -------
    BoundarySetUp_RESERVED_default

    '+++++++++++++++++++++++++++++++++++++++++
    '++gpĂȂBoundaryf[^ł
    '++gpۂ̓RgOĉ
    '+++++++++++++++++++++++++++++++++++++++++
    'BoundarySetUp_Port1
    'BoundarySetUp_Port2
    'BoundarySetUp_Coil_AutoPortIn
    'BoundarySetUp_Coil_AutoPortOut
    'BoundarySetUp_Coil_PortInAuto
    'BoundarySetUp_Coil_PortOutAuto
    'BoundarySetUp_Coil_InAuto
    'BoundarySetUp_Coil_OutAuto
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFRESERVED_default (OE)
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_RESERVED_default()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "RESERVED_default" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "RESERVED_default" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = ELECTRIC_WALL_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).Con = (2.33)
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C
    Bnd.Thermal(Index).RoomTemp.Temp = (0.0)

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (Fluid) -------
    Bnd.Fluid(Index).VelocityCondition = XYZ_VELOCITY_C

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFPort1
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Port1()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Port1" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Port1" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).Con = (2.33)
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C
    Bnd.Thermal(Index).RoomTemp.Temp = (0.0)

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (Fluid) -------
    Bnd.Fluid(Index).VelocityCondition = XYZ_VELOCITY_C

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFPort2
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Port2()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Port2" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Port2" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).Con = (2.33)
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C
    Bnd.Thermal(Index).RoomTemp.Temp = (0.0)

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (Fluid) -------
    Bnd.Fluid(Index).VelocityCondition = XYZ_VELOCITY_C

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_AutoPortIn
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_AutoPortIn()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_AutoPortIn" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_AutoPortIn" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_AutoPortOut
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_AutoPortOut()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_AutoPortOut" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_AutoPortOut" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_PortInAuto
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_PortInAuto()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_PortInAuto" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_PortInAuto" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_PortOutAuto
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_PortOutAuto()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_PortOutAuto" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_PortOutAuto" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_InAuto
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_InAuto()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_InAuto" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_InAuto" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    Boundary̐ݒ BoundaryFCoil_OutAuto
'////////////////////////////////////////////////////////////
Sub BoundarySetUp_Coil_OutAuto()
    '------- BoundaryIndexۑϐ -------
    Dim Index As Integer

    '------- Boundary̒ǉ -------
    Bnd.Add "Coil_OutAuto" 

    '------- Boundary Index̐ݒ -------
    Index = Bnd.Ask ( "Coil_OutAuto" ) 

    '------- dC(Electrical) -------
    Bnd.Electrical(Index).Condition = PORT_C

    '------- M(Thermal) -------
    Bnd.Thermal(Index).bConAuto = False
    Bnd.Thermal(Index).bSetRadioSetting = False

    '------- _x(RoomTemp) -------
    Bnd.Thermal(Index).RoomTemp.TempType = TEMP_AMBIENT_C

    '------- t(Emittivity) -------
    Bnd.Thermal(Index).Emittivity.Eps = (0.999)

    '------- (FluidBern) -------
    Bnd.FluidBern(Index).P = (0.0)

    '------- z(Distribution) -------
    Bnd.FluidBern(Index).TempType = TEMP_DIRECT_C
End Sub

'////////////////////////////////////////////////////////////
'    IF֐
'////////////////////////////////////////////////////////////
Function F_IF(expression As Double, val_true As Double, val_false As Double) As Double
    If expression Then
        F_IF = val_true
    Else
        F_IF = val_false
    End If

End Function

'////////////////////////////////////////////////////////////
'    ϐ`֐
'////////////////////////////////////////////////////////////
Sub InitVariables()


    'VB̕ϐ̒`
    pi = 3.1415926535897932
    c_pi = 3.1415926535897932
    section_radius = 2
    coil_radius = 10
    helical_pitch = 6
    spiral_pitch = 0
    n_turns = 5

    'FemtetGUI̕ϐ̓o^if̕ϐ䓙ł̂ݗpj
    'Femtet.AddNewVariable "c_pi", 3.14159265e+00
    'Femtet.AddNewVariable "section_radius", 2.00000000e+00
    'Femtet.AddNewVariable "coil_radius", 1.00000000e+01
    'Femtet.AddNewVariable "helical_pitch", 6.00000000e+00
    'Femtet.AddNewVariable "spiral_pitch", 0.00000000e+00
    'Femtet.AddNewVariable "n_turns", 5.00000000e+00

End Sub

'////////////////////////////////////////////////////////////
'    f쐬֐
'////////////////////////////////////////////////////////////
Sub MakeModel()

    '------- Bodyzϐ̒` -------
    Dim Body() as CGaudiBody

    '------- f`悳Ȃݒ -------
    Femtet.RedrawMode = False


    '------- CreateHelicalCylinder -------
    ReDim Preserve Body(0)
    Dim Point0 As new CGaudiPoint
    Dim Point1 As new CGaudiPoint
    Point0.SetCoord 0, 0, 0
    Point1.SetCoord coil_radius, 0, 0
    Set Body(0) = Gaudi.CreateHelicalCylinder(Point0, section_radius, Point1, helical_pitch, spiral_pitch, n_turns, True)

    '------- SetName -------
    Body(0).SetName "Coil", "008_Cu"

    '------- SetName -------
    Body(0).SetName "", "008_Copper"


    '------- fĕ`悵܂ -------
    Femtet.Redraw

End Sub

'////////////////////////////////////////////////////////////
'    vZʒo֐
'////////////////////////////////////////////////////////////
Sub SamplingResult()

    '------- ϐɃIuWFNg̐ݒ -------
    Set Gogh = Femtet.Gogh

    '------- ݂̌vZʂ𒆊ԃt@CJ -------
    If Femtet.OpenCurrentResult(True) = False Then
        Femtet.ShowLastError
    End If

    '------- tB[h̐ݒ -------
    Gogh.Gauss.Vector = GAUSS_MAGNETIC_FLUX_DENSITY_C

    '------- ől̎擾 -------
    Dim PosMax() As Double 'ől̍W
    Dim ResultMax As Double ' ől

    If Gogh.Gauss.GetMAXVectorPoint(VEC_C, CMPX_REAL_C, PosMax, ResultMax) = False Then
        Femtet.ShowLastError
    End If

    '------- ŏl̎擾 -------
    Dim PosMin() As Double 'ŏl̍W
    Dim ResultMin As Double 'ŏl

    If Gogh.Gauss.GetMINVectorPoint(VEC_C, CMPX_REAL_C, PosMin, ResultMin) = False Then
        Femtet.ShowLastError
    End If

    '------- CӍW̌vZʂ̎擾 -------
    Dim Value() As New CComplex

    If Gogh.Gauss.GetVectorAtPoint(0, 0, 0, Value()) = False Then
        Femtet.ShowLastError
    End If

    ' ̍W̌ʂ܂Ƃ߂Ď擾ꍇ́AMultiGetVectorAtPoint֐pB

End Sub

