# mypy-boto3-storagegateway

[![PyPI - mypy-boto3-storagegateway](https://img.shields.io/pypi/v/mypy-boto3-storagegateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-storagegateway)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-storagegateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-storagegateway)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.StorageGateway 1.12.16](https://boto3.amazonaws.com/v1/documentation/api/1.12.16/reference/services/storagegateway.html#StorageGateway) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-storagegateway](#mypy-boto3-storagegateway)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `StorageGateway` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-storagegateway]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import storagegateway
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_storagegateway as storagegateway

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("storagegateway")
client: storagegateway.StorageGatewayClient = boto3.client("storagegateway")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: storagegateway.StorageGatewayClient = session.client("storagegateway")


# Paginators need type annotation on creation
describe_tape_archives_paginator: storagegateway.DescribeTapeArchivesPaginator = client.get_paginator("describe_tape_archives")
describe_tape_recovery_points_paginator: storagegateway.DescribeTapeRecoveryPointsPaginator = client.get_paginator("describe_tape_recovery_points")
describe_tapes_paginator: storagegateway.DescribeTapesPaginator = client.get_paginator("describe_tapes")
describe_vtl_devices_paginator: storagegateway.DescribeVTLDevicesPaginator = client.get_paginator("describe_vtl_devices")
list_file_shares_paginator: storagegateway.ListFileSharesPaginator = client.get_paginator("list_file_shares")
list_gateways_paginator: storagegateway.ListGatewaysPaginator = client.get_paginator("list_gateways")
list_tags_for_resource_paginator: storagegateway.ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_tapes_paginator: storagegateway.ListTapesPaginator = client.get_paginator("list_tapes")
list_volumes_paginator: storagegateway.ListVolumesPaginator = client.get_paginator("list_volumes")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.