<p align="center">
  <a href="https://yadism.readthedocs.io/en/latest/"><img alt="Yadism" src="https://raw.githubusercontent.com/NNPDF/yadism/master/docs/_assets/logo/logo.png" width=600></a>
</p>

<p align="center">
  <a href='https://github.com/NNPDF/yadism/actions/workflows/unittests.yml'><img alt="Tests" src='https://github.com/NNPDF/yadism/actions/workflows/unittests.yml/badge.svg' /></a>
  <a href='https://yadism.readthedocs.io/en/latest/?badge=latest'><img src='https://readthedocs.org/projects/yadism/badge/?version=latest' alt='Documentation Status' /></a>
  <a href="https://pypi.org/project/yadism/"><img alt="PyPI" src="https://img.shields.io/pypi/v/yadism"/></a>
  <a href="https://codecov.io/gh/NNPDF/yadism"><img src="https://codecov.io/gh/NNPDF/yadism/branch/master/graph/badge.svg?token=qgCFyUQ6oG" /></a>
  <a href="https://www.codefactor.io/repository/github/nnpdf/yadism"><img src="https://www.codefactor.io/repository/github/nnpdf/yadism/badge?s=e5a00668b58574b5b056e1aca01c7b25d2c203f8" alt="CodeFactor" /></a>
  <a href="https://zenodo.org/badge/latestdoi/219968694"><img src="https://zenodo.org/badge/219968694.svg" alt="DOI"></a>
</p>

## Scope of the project

Provide all necessary tools to compute the DIS structure functions and related objects. This project is linked closely to [EKO](https://github.com/NNPDF/eko).

## Installation

As a user please use [the released version on PyPI](https://pypi.org/project/yadism/),
through your python package manager, e.g. with `pip`:

```sh
pip install yadism
```

### Dev

For development just use [`poetry`](https://python-poetry.org/):

```sh
poetry install
```

To install `poetry` and the other recommended tools, follow the
[instructions](.github/CONTRIBUTING.md#development-tools).

## Development

Members of the development team should always follow the [contribution
guidelines](.github/contributing.md), to have a uniform strategy in code
development and improve collaboration.

## Contributing or contacting the authors

For any kind of interaction consider before to read [external contribution
guidelines](.github/contributing.md#external-contributions), otherwise just send
an email to the authors:

- [Alessandro Candido](mailto:alessandro.candido@mi.infn.it)
- [Felix Hekhorn](mailto:felix.hekhorn@mi.infn.it)
- [Giacomo Magni](mailto:gmagni@nikhef.nl)
