#: number of seconds in one solar day in :math:`\frac{sec}{day}`
SECONDS_IN_DAY: float = 86400

#: number of hours in one solar day in :math:`\frac{hr}{day}`
HOURS_IN_DAY: float = 24

#: number of minutes equal to one solar day in :math:`\frac{min}{day}`
MINUTES_IN_DAY: float = 1440

#: number of minutes equal to one hour in :math:`\frac{min}{hr}`
MINUTES_IN_HOUR: float = 60

#: number of seconds equal to one hour in :math:`\frac{sec}{hr}`
SECONDS_IN_HOUR: float = 3600

#: number of seconds equal to one minute in :math:`\frac{sec}{min}`
SECONDS_IN_MINUTE: float = 60

#: number of degrees equal to one hour in :math:`\frac{\deg}{hr}`
DEGREES_IN_HOUR: float = 15

#: gravity at sea level in :math:`\frac{km}{sec^2}`
SEA_LEVEL_G: float = 0.00981

#: number of base units in a kilo in :math:`\frac{(base)}{kilo(base)}`
BASE_IN_KILO: float = 1000

#: number of seconds for Earth to complete one rotation in :math:`sec` (found on page 31 of Vallado 4th Edition)
SECONDS_IN_SIDEREAL_DAY: float = 86164.090518
