# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['namer', 'namer.models', 'namer.videophash', 'namer.web', 'namer.web.routes']

package_data = \
{'': ['*'],
 'namer': ['tools/*'],
 'namer.web': ['public/*',
               'public/assets/*',
               'public/assets/fonts/*',
               'templates/components/*',
               'templates/pages/*',
               'templates/partials/*',
               'templates/render/*']}

install_requires = \
['ConfigUpdater>=3.1.1,<4.0.0',
 'Flask-Compress>=1.12,<2.0',
 'Pillow>=10.0.0,<11.0.0',
 'Unidecode>=1.3.4,<2.0.0',
 'ffmpeg-python>=0.2.0,<0.3.0',
 'flask>=3.0.0,<4.0.0',
 'jsonpickle>=3.0.1,<4.0.0',
 'loguru>=0.7.0,<0.8.0',
 'mutagen>=1.45.1,<2.0.0',
 'numpy>=1.26.1,<2.0.0',
 'oshash>=0.1.1,<0.2.0',
 'pathvalidate>=3.0.0,<4.0.0',
 'pony>=0.7.16,<0.8.0',
 'rapidfuzz>=3.0.0,<4.0.0',
 'requests-cache>=1.0.0,<2.0.0',
 'requests>=2.27.1,<3.0.0',
 'schedule>=1.1.0,<2.0.0',
 'scipy>=1.11.3,<2.0.0',
 'waitress>=3.0.0,<4.0.0',
 'watchdog>=4.0.0,<5.0.0']

entry_points = \
{'console_scripts': ['namer = namer.__main__:main']}

setup_kwargs = {
    'name': 'namer',
    'version': '1.18.4',
    'description': 'A namer of video files based on metadata from the porndb.',
    'long_description': '.. |logo| image:: ./logo/namer.png\n  :width: 80\n  :class: display: inline flow; align: left\n\n##############\n|logo| Namer\n##############\n\n|_ci_badge| |_codecov_badge| |_pypi_badge| |_pypi_download_badge| |_download_badge| |_download_month_badge|\n\nNamer is a powerful web app, folder watchdog and command line tool for renaming video files and tagging mp4 video files in a way that helps plex/jellyfin/emby and related plugins extract that data or lookup data with the PornDB_\'s plugins for plex or jellyfin/emby.\n\nNamer is easily installed as a python pip and can:\n\n* namer now support perceptual hashes by default and can identify video files that don\'t have parsable names.\n\n* can be run watching a directory for new files to name, tag and move to an output location, possible setting file permissions, writing .nfo files with downloaded images, attempting to grab trailers, and retrying failed files nightly.\n\n  ``python -m namer watchdog``\n\n* while running watchdog, will also have a webui that can be used to manually match and rename any files that could not be automatically matched.  You can set the webroot, port, bound ip, enable/disable in your namer.cfg file.\n\n  ``http://<ip>:6980/``\n\n* can be used to name and embed tags in individual files with metadata from porndb:\n\n  ``python -m namer rename -f /path/to/file/Site.[YY]YY.MM.DD.MessOfText.XXX.2160.mp4 [-v]``\n\n* can be used to name and tag files with metadata from a jellyfin/emby/kodi .nfo file (should be named the same as the file except for extension).\n\n  ``python -m namer rename -f /path/to/file/Site.[YY]YY.MM.DD.MessOfText.XXX.2160.mp4 -i [-v]``\n\n* can be used to rename a tag a file based on the directory name, so if you have a file like ``/Site.[YY]YY.MM.DD.MessOfText.XXX.2160/abc.mp4``\n\n  ``python -m namer rename -d /path/to/dir/Site.[YY]YY.MM.DD.MessOfText.XXX.2160/``\n\n* can be used to rename a tag a whole mess of dirs and files in a directory (using -m, meaning "many").\n\n  ``python -m namer rename -m -d /path/to/dir/``\n\n* can be used to just suggest a possible name.  The file doesn\'t need to exist but should have an extension.\n\n  ``python -m namer suggest -f Site.[YY]YY.MM.DD.MessOfText.XXX.2160.mp4``\n\n\nFor all of the above it\'s recommended to have a config file in your home directory (copied from namer/namer.cfg.default in this git repo)\n\nAlso provided is a docker file if you prefer.\n\nIt is possible to ignore and not need to parse dates for studios added to a list in the configuration file.  This is mostly used for studios that do not list dates on videos.\n\nWhy should I use this?\n----------------------\n\n1.  You have partially well structured file names (say from an rss feed, etc) and you never want to have to manually match files in plex/jellyfin/emby with the PornDB_\'s plugin.\n2.  You don\'t want your recent videos to be added to your library until they are matchable in the PornDB_.\n3.  You want to store the metadata about a file in mp4 files, in a way that can be read by Apple TV app, including information like: Studio, date created, name, performers, original url, proper HD tags, ratings, and movie poster.   All of this data is readable by Plex, and most by Jellyfin/Emby in case you want to standard Apple video players or your library\'s metadata storage is ever damaged.\n\nHow successful at matching videos is this tool?\n------------------------------------------------\n\nFor data pulled from the internet with rss feeds (which are often in the file format listed below) .... very near perfect.  The author and others have only experienced two mismatches, and those type of failures can never occur again.\n\nIf running in a background watchdog mode, files that were failed to match are retried every 24 hours, letting the PornDB_ scrapers catch up with any metadata they may be missing.\n\nOptionally, a log file can be enabled to show the original file name parts, what options were evaluated, and which match was used to name the file, it will be written next to your video file with the same name as the file (with a _namer.log) suffix rather than an mp4/mkv/avi/mov/flv extension.   This is very useful for sanity checking matches, and if ever a mismatch does occur the original file name is available in the log.\n\n\nFor the curious, how is a match made?\n------------------------------------------------\n\nNamer assumes that file names exist as in a format like ```sitename-[YY]YY-MM-DD-Scene.and.or.performer.name.mp4.```.  A powerful regex tries to determine the various parts of a file\'s name.   Note that the separating dashes and dots above are interchangeable, and spaces may also be used as separators (or any number of any combo of the three.)   This regex is overridable, but you really need to know what you\'re doing and if you don\'t have all the match groups for the regex, the match from the the PornDB_ will likely not be any where near as robust as it is with a site, a date, and a scene/perform name section.\nYou\'ll have to read the code to figure out how to set this.   You really shouldn\'t do it.\n\nWhen determining a possible queried match from the PornDB_:\n\nSitename my not need be the full name of the site, as long as a the looked up sitename starts with file\'s sitename it could be a valid match.\n\nThe date may have a four digit or two digit year.  If two digit, "20" is assumed as the default century, not "19".  A potential match must be with one day plus/minus the file\'s date to be considered a match.\n\nFinally the looked up scene name and all performers first and last names are combined in to what is called a powerset (every combo of including or not including each artist and/or scene name), and that is compared against the file\'s \'Scene.and.or.performer.name\' section with a tool called rapidfuzz.   A name must be 95% similar to a member of the powerset to be considered a match, though all potential matches are evaluated and sorted before selecting the best match.   Information about all potential matches are stored in the local log file if it is enabled.\n\nAt the same time name based matching is occurring, a perceptual hash is built and queried against the PornDB_.\n\nAll matches, regardless of source are made unique with the PornDB_\'s UUID (universally unique identifier).   If more than one unique match exist, or no match exists but partial name matches exist, all data is available in the web ui for users to select the correct match.\n\nI\'m sold how do I install it!\n--------------------------------------------------\n\nYou have two choices.   Do you use docker?  Pull the docker image, here\'s docker-compose snippet to help you out.\n\n\n.. code-block:: yaml\n\n  version: "3"\n  services:\n    namer:\n      container_name: namer\n      image: ghcr.io/theporndatabase/namer:latest\n      environment:\n        - PUID=1001\n        - PGID=1000\n        - TZ=America/Los_Angeles\n        - NAMER_CONFIG=/config/namer.cfg\n      volumes:\n        - /apps/namer/:/config <- this will store the namer.cfg file copied by you from the git repo ( namer/namer.cfg.default )\n        - /media:/data <- this will have the four folders namer needs to work, referenced in the namer.cfg file you create.\n    healthcheck: <- if on a qnap nas, the default health check will not work for you, domain name is the container_name\n      test: [ "CMD-SHELL", "curl -f http://namer:6980/<replace with your webroot>/api/healthcheck || exit 1" ]\n      interval: 1m\n      timeout: 30s\n      # retries: 3\n      # start_period: 40s\n    restart: always\n\nCopy namer.cfg to your config location (a path mapped to /config/namer.cfg above), and set values for your setup.\nThe config is well commented and you should only need to add a token for the porndb and change file locations.\n\nRunning a service will occur automatically once you call ``docker-compose up``.  Now check out the configuration section below.\n\n\nPip/Python usage\n--------------------\n\nA detailed install tutorial can be found at `Install Instructions`_\n\n---------------------------\n\nThere is a well documented template of namer.cfg in this git repo, which is broken up in to three sections.\nOne section is related to command line renaming, the `namer section`_, one related to tagging mp4s `metadata section`_,\nand finally one related to the watchdog process `watchdog section`_.\nPlease note that the `namer section`_ section and the `watchdog section`_\nsection both have a field to describe the new name of a file based on looked up metadata from the PornDB_.\nThey differ because when run from the command line namer will keep the file "in place".\nIf namer is passed a dir on the command line as input it can operate in one of two modes,\nthe default mode is to look for the largest mp4 file, or other configured movie file extension if no mp4 exists,\nand rename and move that file to the root of the folder (if it\'s in a sub-folder).\nIn this case, by default the assumption is the name of the folder should be parsed to look for information to\nsearch the PornDB_ for matching rather than the file name.   Meaning,\nif you pass a file to namer on the commandline it will be renamed but stay in the same directory.\n\n\nTypical Watchdog Behavior:\n----------------------------\n\nThe watchdog process will watch a single folder, configured with watch_dir_ in the ``namer.cfg`` file.   Any new files and directories that appear in the watch_dir_\nwill be processed once an mp4/mkv/avi/mov/flv file has been fully copied in to it.\n\nThe first step in processing is to more the newly appearing directory or file in to the work_dir_.\n\nOnce moved the processing is highly dependant on the namer.cfg file, but in general, the name of video file or the directory file (configured with ``prefer_dir_name_if_available`` flag)\nis parsed and matched with a scene from the PornDB_.   See `For the curious, how is a match made?`_.  If a match cannot be made the general assumption is that the PornDB_ doesn\'t have metadata for that file yet.\nThe file is move to the failed dir fail_dir_ to be retried once a day at a time configured with retry_time_,\nwhich by default will be a random selected minute in the 3am hour of your timezone.   If enabled_tagging_ flag is set to true then\nthe metadata (including cover art if enable_poster_ is set) will be embedded in the mp4 file.  Please read the comments in the namer.cfg to find out about genres, tags, performers, etc.\n\nFinally, the file is moved to a location defined by dest_dir_ and new_relative_path_name_.\n\n\nDevelopment\n------------------------------\n\n.. code-block:: sh\n\n  # Install Python\n  # Install poetry\n  # Install pnpm\n  # Install golang\n\n  # Install poe the poet\n  poetry self add \'poethepoet[poetry_plugin]\'\n  # or\n  pip add poethepoet\n\n  # Set python version if not using the latest python as your default\n  poetry env use 3.11\n\n  # Build everything\n  poetry run poe build_all\n\n  # Code Coverage:\n  poetry run pytest --cov\n\n  # Html Coverage report:\n  poetry run coverage html\n\n  # Local python install\n  pip install ./dist/namer-<version>.tar.gz\n\n  # Publishing:\n  # First make sure you have set gotten a token from pypi and set it on your machine.\n  poetry config pypi-token.pypi <token>\n\n  # Perhaps update the version number?\n  poetry version <new number>\n\n  # Publishing a release to pypi.org:\n  poetry publish\n\n  # build docker file with:\n  ./docker_build.sh\n\nPull Requests Are Welcome!\n---------------------------\n\nJust be sure to pay attention to the tests and any failing pylint results.   If you want to vet a pr will be accepted before building code, file an new feature request issue, and 4c0d3r will comment on it and set you up for success.   Tests are must.\n\n.. _PornDB: http://theporndb.net/\n.. _namer section: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L1\n.. _metadata section: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L59\n.. _watchdog section: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L89\n.. _watch_dir: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L100\n.. _work_dir: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L104\n.. _fail_dir: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L109\n.. _dest_dir: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L112\n.. _retry_time: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L115\n.. _new_relative_path_name: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L97\n.. _enabled_tagging: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L67\n.. _enable_poster: https://github.com/ThePornDatabase/namer/blob/main/namer/namer.cfg.default#L72\n.. _Homebrew: https://docs.brew.sh/Installation\n.. _Chocolatey: https://chocolatey.org/install\n.. _Install Instructions: https://github.com/ThePornDatabase/namer/blob/main/install_instructions.md\n\n.. |_ci_badge| image:: https://github.com/ThePornDatabase/namer/actions/workflows/ci.yml/badge.svg?\n  :target: https://github.com/ThePornDatabase/namer/actions/workflows/ci.yml/\n.. |_codecov_badge| image:: https://codecov.io/gh/ThePornDatabase/namer/branch/main/graph/badge.svg?token=4MQEN2NUKZ\n  :target: https://codecov.io/gh/ThePornDatabase/namer\n.. |_pypi_badge| image:: https://badge.fury.io/py/namer.svg?\n  :target: https://badge.fury.io/py/namer\n.. |_pypi_download_badge| image:: https://img.shields.io/pypi/dm/namer?logo=pypi&logoColor=fff\n  :target: https://pypi.org/project/namer\n.. |_download_badge| image:: https://static.pepy.tech/personalized-badge/namer?period=total&units=international_system&left_color=grey&right_color=yellowgreen&left_text=Downloads\n  :target: https://pepy.tech/project/namer\n.. |_download_month_badge| image:: https://static.pepy.tech/personalized-badge/namer?period=month&units=international_system&left_color=grey&right_color=yellowgreen&left_text=Downloads/Month\n  :target: https://pepy.tech/project/namer\n',
    'author': '4c0d3r',
    'author_email': '4c0d3r@protonmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<3.13',
}


setup(**setup_kwargs)
