# mypy-boto3-personalize

[![PyPI - mypy-boto3-personalize](https://img.shields.io/pypi/v/mypy-boto3-personalize.svg?color=blue)](https://pypi.org/project/mypy-boto3-personalize)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-personalize.svg?color=blue)](https://pypi.org/project/mypy-boto3-personalize)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-personalize?color=blue)](https://pypistats.org/packages/mypy-boto3-personalize)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Personalize 1.17.64](https://boto3.amazonaws.com/v1/documentation/api/1.17.64/reference/services/personalize.html#Personalize)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-personalize docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_personalize/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-personalize](#mypy-boto3-personalize)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `Personalize` service.

```bash
python -m pip install boto3-stubs[personalize]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[personalize]` in your environment:
  `python -m pip install 'boto3-stubs[personalize]'`

Both type checking and auto-complete should work for `Personalize` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[personalize]` in your environment:
  `python -m pip install 'boto3-stubs[personalize]'`

Both type checking and auto-complete should work for `Personalize` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[personalize]` in your environment:
  `python -m pip install 'boto3-stubs[personalize]'`
- Run `mypy` as usual

Type checking should work for `Personalize` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[personalize]` in your environment:
  `python -m pip install 'boto3-stubs[personalize]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Personalize` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`PersonalizeClient` provides annotations for `boto3.client("personalize")`.

```python
import boto3

from mypy_boto3_personalize import PersonalizeClient

client: PersonalizeClient = boto3.client("personalize")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: PersonalizeClient = session.client("personalize")
```

### Paginators annotations

`mypy_boto3_personalize.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_personalize import PersonalizeClient
from mypy_boto3_personalize.paginator import (
    ListBatchInferenceJobsPaginator,
    ListCampaignsPaginator,
    ListDatasetExportJobsPaginator,
    ListDatasetGroupsPaginator,
    ListDatasetImportJobsPaginator,
    ListDatasetsPaginator,
    ListEventTrackersPaginator,
    ListFiltersPaginator,
    ListRecipesPaginator,
    ListSchemasPaginator,
    ListSolutionVersionsPaginator,
    ListSolutionsPaginator,
)

client: PersonalizeClient = boto3.client("personalize")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_batch_inference_jobs_paginator: ListBatchInferenceJobsPaginator = client.get_paginator("list_batch_inference_jobs")
list_campaigns_paginator: ListCampaignsPaginator = client.get_paginator("list_campaigns")
list_dataset_export_jobs_paginator: ListDatasetExportJobsPaginator = client.get_paginator("list_dataset_export_jobs")
list_dataset_groups_paginator: ListDatasetGroupsPaginator = client.get_paginator("list_dataset_groups")
list_dataset_import_jobs_paginator: ListDatasetImportJobsPaginator = client.get_paginator("list_dataset_import_jobs")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_event_trackers_paginator: ListEventTrackersPaginator = client.get_paginator("list_event_trackers")
list_filters_paginator: ListFiltersPaginator = client.get_paginator("list_filters")
list_recipes_paginator: ListRecipesPaginator = client.get_paginator("list_recipes")
list_schemas_paginator: ListSchemasPaginator = client.get_paginator("list_schemas")
list_solution_versions_paginator: ListSolutionVersionsPaginator = client.get_paginator("list_solution_versions")
list_solutions_paginator: ListSolutionsPaginator = client.get_paginator("list_solutions")
```

### Literals

`mypy_boto3_personalize.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_personalize.literals import (
    IngestionMode,
    ListBatchInferenceJobsPaginatorName,
    ListCampaignsPaginatorName,
    ListDatasetExportJobsPaginatorName,
    ListDatasetGroupsPaginatorName,
    ListDatasetImportJobsPaginatorName,
    ListDatasetsPaginatorName,
    ListEventTrackersPaginatorName,
    ListFiltersPaginatorName,
    ListRecipesPaginatorName,
    ListSchemasPaginatorName,
    ListSolutionVersionsPaginatorName,
    ListSolutionsPaginatorName,
    RecipeProvider,
    TrainingMode,
)

def check_value(value: IngestionMode) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_personalize.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_personalize.type_defs import (
    AlgorithmImageTypeDef,
    AlgorithmTypeDef,
    AutoMLConfigTypeDef,
    AutoMLResultTypeDef,
    BatchInferenceJobConfigTypeDef,
    BatchInferenceJobInputTypeDef,
    BatchInferenceJobOutputTypeDef,
    BatchInferenceJobSummaryTypeDef,
    BatchInferenceJobTypeDef,
    CampaignConfigTypeDef,
    CampaignSummaryTypeDef,
    CampaignTypeDef,
    CampaignUpdateSummaryTypeDef,
    CategoricalHyperParameterRangeTypeDef,
    ContinuousHyperParameterRangeTypeDef,
    CreateBatchInferenceJobResponseTypeDef,
    CreateCampaignResponseTypeDef,
    CreateDatasetExportJobResponseTypeDef,
    CreateDatasetGroupResponseTypeDef,
    CreateDatasetImportJobResponseTypeDef,
    CreateDatasetResponseTypeDef,
    CreateEventTrackerResponseTypeDef,
    CreateFilterResponseTypeDef,
    CreateSchemaResponseTypeDef,
    CreateSolutionResponseTypeDef,
    CreateSolutionVersionResponseTypeDef,
    DataSourceTypeDef,
    DatasetExportJobOutputTypeDef,
    DatasetExportJobSummaryTypeDef,
    DatasetExportJobTypeDef,
    DatasetGroupSummaryTypeDef,
    DatasetGroupTypeDef,
    DatasetImportJobSummaryTypeDef,
    DatasetImportJobTypeDef,
    DatasetSchemaSummaryTypeDef,
    DatasetSchemaTypeDef,
    DatasetSummaryTypeDef,
    DatasetTypeDef,
    DefaultCategoricalHyperParameterRangeTypeDef,
    DefaultContinuousHyperParameterRangeTypeDef,
    DefaultHyperParameterRangesTypeDef,
    DefaultIntegerHyperParameterRangeTypeDef,
    DescribeAlgorithmResponseTypeDef,
    DescribeBatchInferenceJobResponseTypeDef,
    DescribeCampaignResponseTypeDef,
    DescribeDatasetExportJobResponseTypeDef,
    DescribeDatasetGroupResponseTypeDef,
    DescribeDatasetImportJobResponseTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeEventTrackerResponseTypeDef,
    DescribeFeatureTransformationResponseTypeDef,
    DescribeFilterResponseTypeDef,
    DescribeRecipeResponseTypeDef,
    DescribeSchemaResponseTypeDef,
    DescribeSolutionResponseTypeDef,
    DescribeSolutionVersionResponseTypeDef,
    EventTrackerSummaryTypeDef,
    EventTrackerTypeDef,
    FeatureTransformationTypeDef,
    FilterSummaryTypeDef,
    FilterTypeDef,
    GetSolutionMetricsResponseTypeDef,
    HPOConfigTypeDef,
    HPOObjectiveTypeDef,
    HPOResourceConfigTypeDef,
    HyperParameterRangesTypeDef,
    IntegerHyperParameterRangeTypeDef,
    ListBatchInferenceJobsResponseTypeDef,
    ListCampaignsResponseTypeDef,
    ListDatasetExportJobsResponseTypeDef,
    ListDatasetGroupsResponseTypeDef,
    ListDatasetImportJobsResponseTypeDef,
    ListDatasetsResponseTypeDef,
    ListEventTrackersResponseTypeDef,
    ListFiltersResponseTypeDef,
    ListRecipesResponseTypeDef,
    ListSchemasResponseTypeDef,
    ListSolutionVersionsResponseTypeDef,
    ListSolutionsResponseTypeDef,
    PaginatorConfigTypeDef,
    RecipeSummaryTypeDef,
    RecipeTypeDef,
    ResponseMetadata,
    S3DataConfigTypeDef,
    SolutionConfigTypeDef,
    SolutionSummaryTypeDef,
    SolutionTypeDef,
    SolutionVersionSummaryTypeDef,
    SolutionVersionTypeDef,
    TunedHPOParamsTypeDef,
    UpdateCampaignResponseTypeDef,
)

def get_structure() -> AlgorithmImageTypeDef:
    return {
      ...
    }
```
