# mypy-boto3-logs

[![PyPI - mypy-boto3-logs](https://img.shields.io/pypi/v/mypy-boto3-logs.svg?color=blue)](https://pypi.org/project/mypy-boto3-logs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-logs.svg?color=blue)](https://pypi.org/project/mypy-boto3-logs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-logs](#mypy-boto3-logs)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.CloudWatchLogs 1.13.24](https://boto3.amazonaws.com/v1/documentation/api/1.13.24/reference/services/logs.html#CloudWatchLogs) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-logs](#mypy-boto3-logs)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudWatchLogs` service.

```bash
python -m pip install boto3-stubs[logs]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_logs` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_logs import CloudWatchLogsClient

# Now mypy can check if your code is valid.
client: CloudWatchLogsClient = boto3.client("logs")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudWatchLogsClient = session.client("logs")



# Annotated paginators are included as well

import mypy_boto3_logs.paginator as logs_paginators

describe_destinations_paginator: logs_paginators.DescribeDestinationsPaginator = client.get_paginator("describe_destinations")
describe_export_tasks_paginator: logs_paginators.DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_log_groups_paginator: logs_paginators.DescribeLogGroupsPaginator = client.get_paginator("describe_log_groups")
describe_log_streams_paginator: logs_paginators.DescribeLogStreamsPaginator = client.get_paginator("describe_log_streams")
describe_metric_filters_paginator: logs_paginators.DescribeMetricFiltersPaginator = client.get_paginator("describe_metric_filters")
describe_queries_paginator: logs_paginators.DescribeQueriesPaginator = client.get_paginator("describe_queries")
describe_resource_policies_paginator: logs_paginators.DescribeResourcePoliciesPaginator = client.get_paginator("describe_resource_policies")
describe_subscription_filters_paginator: logs_paginators.DescribeSubscriptionFiltersPaginator = client.get_paginator("describe_subscription_filters")
filter_log_events_paginator: logs_paginators.FilterLogEventsPaginator = client.get_paginator("filter_log_events")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_logs` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_logs as logs
from mypy_boto3_logs import CloudWatchLogsClient

# with these
from mypy_boto3 import logs
from mypy_boto3.logs import CloudWatchLogsClient
```