# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-02-04 19:33
from __future__ import unicode_literals

import bursary.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Bursary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('request_food', models.BooleanField()),
                ('request_accommodation', models.BooleanField()),
                ('request_travel', models.BooleanField()),
                ('reason_contribution', models.TextField(blank=True)),
                ('reason_plans', models.TextField(blank=True)),
                ('reason_diversity', models.TextField(blank=True)),
                ('need', models.CharField(blank=True, choices=[('unable', 'Without this funding, I will be absolutely unable to attend'), ('sacrifice', 'Without the requested funding, I will have to make financial sacrifices to attend'), ('inconvenient', 'Without the requested funding, attending will be inconvenient for me'), ('non-financial', 'I am not applying based on financial need')], max_length=16)),
                ('travel_bursary', models.IntegerField(blank=True, null=True)),
                ('travel_from', models.TextField(blank=True)),
                ('food_status', models.CharField(choices=[('submitted', 'The bursary request has been submitted'), ('ranked', 'The bursary request has been ranked'), ('pending', 'The bursary request has been granted and is pending your acceptance'), ('accepted', 'The bursary has been accepted'), ('denied', 'The bursary has been denied'), ('expired', 'The bursary grant has expired'), ('canceled', 'The bursary request has been canceled')], default='submitted', max_length=32)),
                ('food_accept_before', models.DateField(blank=True, null=True)),
                ('accommodation_status', models.CharField(choices=[('submitted', 'The bursary request has been submitted'), ('ranked', 'The bursary request has been ranked'), ('pending', 'The bursary request has been granted and is pending your acceptance'), ('accepted', 'The bursary has been accepted'), ('denied', 'The bursary has been denied'), ('expired', 'The bursary grant has expired'), ('canceled', 'The bursary request has been canceled')], default='submitted', max_length=32)),
                ('accommodation_accept_before', models.DateField(blank=True, null=True)),
                ('travel_status', models.CharField(choices=[('submitted', 'The bursary request has been submitted'), ('ranked', 'The bursary request has been ranked'), ('pending', 'The bursary request has been granted and is pending your acceptance'), ('accepted', 'The bursary has been accepted'), ('denied', 'The bursary has been denied'), ('expired', 'The bursary grant has expired'), ('canceled', 'The bursary request has been canceled')], default='submitted', max_length=32)),
                ('travel_accept_before', models.DateField(blank=True, null=True)),
                ('reimbursed_amount', models.IntegerField(blank=True, default=0)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name='bursary', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'bursary request',
            },
        ),
        migrations.CreateModel(
            name='BursaryReferee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contrib_score', models.DecimalField(blank=True, decimal_places=2, help_text='\n\nDecimal value from 0 to 5; Please try to conform to the following scale for\nyour assessment.\n\n<dl>\n<dt>5 "Must fund"</dt>\n<dd>\nIf this person does not attend DebConf, there will be significant\nnegative impact for DebConf or Debian more generally.\n</dd>\n<dt>4 "Priority funding"</dt>\n<dd>\nThere are clear benefits to Debian or to DebConf of this person attending\ndebconf. This might be an accepted talk that seems particularly important.\n</dd>\n<dt>3 "Good initiative"</dt>\n<dd>\nWe should fund this person because they propose something interesting.\n</dd>\n<dt>2 "Good record"</dt>\n<dd>\nThis person has a record of substantial contribution to Debian.this should\ngenerally be recent contribution, i.e. within the last two years.\n</dd>\n<dt>1 "OK"</dt>\n<dd>\nIf we have budget, I don\'t object to funding this request.\n</dd>\n<dt>0 "Deny"</dt>\n<dd>\nEven if we have budget, I think we should not fund this request.\n</dd>\n</dl>\n', max_digits=3, null=True, validators=[bursary.models.validate_score], verbose_name='Contribution score')),
                ('outreach_score', models.DecimalField(blank=True, decimal_places=2, help_text='\n\nDecimal value from 0 to 5; Please try to assess applicants according to the\nfollowing criteria, and to use the full scale across your (non-null) ratings.\n\n<ul>\n<li>Gender (favoring women (cis, trans, queer), non-binary and genderqueer\nindividuals, as well as trans men)</li>\n<li>Age (favoring individuals over 35 years old)</li>\n<li>Country of origin / ethnic diversity</li>\n<li>Whether the applicant is a newcomer to Debian (yes should rank higher)</li>\n</ul>\n\n', max_digits=3, null=True, validators=[bursary.models.validate_score], verbose_name='Diversity and Inclusion score')),
                ('notes', models.TextField(blank=True, default='', help_text='Let us know how you came to your decision', verbose_name='Notes for evaluation')),
                ('final', models.BooleanField(default=False, verbose_name='Final assessment')),
                ('bursary', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='referees', to='bursary.Bursary')),
                ('referee', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='bursaryreferee',
            unique_together=set([('bursary', 'referee')]),
        ),
    ]
