from wafer.management.commands.wafer_add_default_groups import Command as AddGroupsCommand


class Command(AddGroupsCommand):
    help = "Add Django groups for DebConf teams"

    GROUPS = {
        # Permissions are specified as (app, code_name) pairs
        'Bursary Admins': (
            ('bursary', 'add_bursaryreferee'),
            ('bursary', 'change_bursaryreferee'),
            ('bursary', 'add_bursary'),
            ('bursary', 'change_bursary'),
            ('bursary', 'review_attendance'),
        ),
        'Bursary Referees': (
            ('bursary', 'change_bursaryreferee'),
            ('talks', 'view_all_talks'),
        ),
        'Content Admin': (
            ('auth', 'view_user'),
            ('schedule', 'add_scheduleblock'),
            ('schedule', 'add_scheduleitem'),
            ('schedule', 'add_slot'),
            ('schedule', 'add_venue'),
            ('schedule', 'change_scheduleblock'),
            ('schedule', 'change_scheduleitem'),
            ('schedule', 'change_slot'),
            ('schedule', 'change_venue'),
            ('schedule', 'delete_scheduleblock'),
            ('schedule', 'delete_scheduleitem'),
            ('schedule', 'delete_slot'),
            ('schedule', 'delete_venue'),
            ('talks', 'add_review'),
            ('talks', 'add_reviewaspect'),
            ('talks', 'add_score'),
            ('talks', 'add_talk'),
            ('talks', 'add_talktype'),
            ('talks', 'add_talkurl'),
            ('talks', 'add_track'),
            ('talks', 'change_review'),
            ('talks', 'change_reviewaspect'),
            ('talks', 'change_score'),
            ('talks', 'change_talk'),
            ('talks', 'change_talktype'),
            ('talks', 'change_talkurl'),
            ('talks', 'change_track'),
            ('talks', 'delete_review'),
            ('talks', 'delete_reviewaspect'),
            ('talks', 'delete_score'),
            ('talks', 'delete_talktype'),
            ('talks', 'delete_talkurl'),
            ('talks', 'delete_track'),
            ('talks', 'edit_private_notes'),
            ('talks', 'view_all_talks'),
        ),
        'FD Volunteer': (
            ('volunteers', 'accept_fd_tasks'),
        ),
        'FD Laptop': (
            ('front_desk', 'add_checkin'),
            ('front_desk', 'change_checkin'),
            ('register', 'view_attendee'),
        ),
        'Local Orga': (
            ('register', 'view_accomm'),
            ('register', 'view_attendee'),
            ('register', 'view_childcare'),
            ('register', 'view_food'),
            ('register', 'view_visa'),
        ),
        'Registration': (
            ('front_desk', 'add_checkin'),
            ('front_desk', 'change_checkin'),
            ('invoices', 'view_invoice'),
            ('register', 'change_accomm'),
            ('register', 'change_attendee'),
            ('register', 'change_food'),
            ('register', 'view_accomm'),
            ('register', 'view_attendee'),
            ('register', 'view_childcare'),
            ('register', 'view_food'),
            ('volunteers', 'accept_fd_tasks'),
        ),
        'Registration Admin': (
            ('auth', 'add_user'),
            ('auth', 'change_user'),
            ('auth', 'delete_user'),
            ('bursary', 'review_attendance'),
            ('front_desk', 'add_checkin'),
            ('front_desk', 'change_checkin'),
            ('front_desk', 'delete_checkin'),
            ('invoices', 'change_invoice'),
            ('invoices', 'view_invoice'),
            ('register', 'add_accomm'),
            ('register', 'add_attendee'),
            ('register', 'add_food'),
            ('register', 'change_accomm'),
            ('register', 'change_attendee'),
            ('register', 'change_food'),
            ('register', 'delete_accomm'),
            ('register', 'delete_attendee'),
            ('register', 'delete_food'),
            ('register', 'delete_queueslot'),
            ('register', 'orga_early_arrival'),
            ('register', 'view_accomm'),
            ('register', 'view_attendee'),
            ('register', 'view_childcare'),
            ('register', 'view_food'),
            ('users', 'add_userprofile'),
            ('users', 'change_userprofile'),
            ('users', 'delete_userprofile'),
            ('volunteers', 'accept_fd_tasks'),
        ),
        'Talkmeisters': (
            ('volunteers', 'accept_talkmeister_tasks'),
        ),
        'Video Team': (
            ('talks', 'view_all_talks'),
            ('volunteers', 'accept_video_tasks'),
        ),
        'Visa Team': (
            ('invoices', 'view_invoice'),
            ('register', 'view_attendee'),
            ('register', 'view_visa'),
        ),
        'Volunteer Admin': (
            ('volunteers', 'add_task'),
            ('volunteers', 'add_taskcategory'),
            ('volunteers', 'add_tasktemplate'),
            ('volunteers', 'add_volunteer'),
            ('volunteers', 'change_task'),
            ('volunteers', 'change_taskcategory'),
            ('volunteers', 'change_tasktemplate'),
            ('volunteers', 'change_volunteer'),
            ('volunteers', 'delete_task'),
            ('volunteers', 'delete_taskcategory'),
            ('volunteers', 'delete_tasktemplate'),
            ('volunteers', 'delete_volunteer'),
        ),
    }
