from django.conf import settings
from minidebconf.models import Registration

def expose_settings(request):
    registration = None
    try:
        if request.user.is_authenticated:
            registration = Registration.objects.get(user=request.user)
    except Registration.DoesNotExist:
        pass

    return {
        'MINIDEBCONF': True,
        'MINIDEBCONF_REGISTRATION': registration,
        'MINIDEBCONF_REGISTER_BURSARY_CONTRIBUTORS_ONLY': getattr(settings, "MINIDEBCONF_REGISTER_BURSARY_CONTRIBUTORS_ONLY", False),
    }
