from django.contrib import admin
from django.contrib.admin.templatetags.admin_list import _boolean_icon

from register.models.address import Address


class AddressAdmin(admin.ModelAdmin):
    list_display = ('attendee', 'role', 'full_name', 'email', 'confirmed',)
    list_filter = ('attendee__reconfirm',)
    search_fields = (
        'attendee__user__username', 'attendee__user__first_name',
        'attendee__user__last_name'
    )

    def full_name(self, instance):
        return instance.attendee.user.get_full_name()
    full_name.admin_order_field = 'attendee__user__last_name'

    def email(self, instance):
        return instance.attendee.user.email
    email.admin_order_field = 'attendee__user__email'

    def confirmed(self, instance):
        return _boolean_icon(instance.attendee.confirmed())
    confirmed.short_description = 'Confirmed?'
    confirmed.admin_order_field = 'attendee__reconfirm'


admin.site.register(Address, AddressAdmin)
