<p align="center"><img src="/assets/investos-banner.png" alt="InvestOS Banner"></p>
<h1 align="center">InvestOS</h1>

Welcome to the **InvestOS** portfolio engineering and backtesting framework!

InvestOS is an opinionated framework for constructing and backtesting portfolios in a consistent, albeit flexible way. We built it to make institutional-grade backtesting and portfolio optimization simple, extensible, and open-source.

<br/>

|         |                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Docs    | [![website - investos.io](https://img.shields.io/badge/website-investos.io-black)](https://investos.io/) [![docs](https://img.shields.io/readthedocs/investos)](https://investos.readthedocs.io/en/latest/)                                                                                                                                                                                                                              |
| Package | [![PyPI - Version](https://img.shields.io/pypi/v/investos.svg?logo=pypi&label=PyPI&logoColor=gold)](https://pypi.python.org/pypi/investos) [![PyPI - Python Versions](https://img.shields.io/pypi/pyversions/investos.svg?logo=python&label=Python&logoColor=gold)](https://pypi.org/project/investos/)                                                                                                                                  |
| Meta    | [![Poetry](https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json)](https://python-poetry.org/) [![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff) [![license - MIT](https://img.shields.io/badge/license-MIT-blue)](https://spdx.org/licenses/MIT.html) |

<br/>

## Getting Started

### 🔗 [Read the full Getting Started guides Here](https://investos.io/guides/introduction/getting_started)

### Prerequisites

**To run InvestOS you'll need**:

- [Python +3.8](https://www.python.org/doc/)
  - You can [download it here](https://www.python.org/downloads/)
  - If you're working on MacOS, you may wish to [install it via Homebrew](https://docs.python-guide.org/starting/install3/osx/)
- [pip](https://packaging.python.org/en/latest/key_projects/#pip)
  - For installing InvestOS (and any other Python packages)
  - [pip installation instructions here](https://packaging.python.org/en/latest/tutorials/installing-packages/)

**Although not required, running InvestOS might be easier if you have**:

- [Poetry](https://python-poetry.org/), a package and dependency manager
- Familiarity with [pandas](https://pandas.pydata.org/)
  - The popular Python data analysis package (originally) released by AQR Capital Management

## Installation

If you're using pip:

```bash
$ pip install investos
```

If you're using poetry:

```bash
$ poetry add investos
```

## Importing InvestOS

At the top of your python file or .ipynb, add:

```python
import investos as inv
```

Congratulations on setting up InvestOS!

### Let's move on to our next guide: [How InvestOS Works](https://investos.io/guides/introduction/how_investos_works)

## Contributing

InvestOS is an open-source project and we welcome contributions from the community.

If you'd like to contribute, please fork the repository and make changes as you'd like. Pull requests are warmly welcome.

### Contributors ✨

<a href="https://github.com/forecastos/investos/contributors">
  <img src="https://contrib.rocks/image?repo=forecastos/investos" />
</a>
