"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosServiceMesh = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosServiceMeshProps`
 *
 * @param properties - the TypeScript properties of a `RosServiceMeshProps`
 *
 * @returns the result of the validation.
 */
function RosServiceMeshPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('excludeInboundPorts', ros.validateString)(properties.excludeInboundPorts));
    errors.collect(ros.propertyValidator('opa', RosServiceMesh_OPAPropertyValidator)(properties.opa));
    errors.collect(ros.propertyValidator('dubboFilterEnabled', ros.validateBoolean)(properties.dubboFilterEnabled));
    errors.collect(ros.propertyValidator('prometheusUrl', ros.validateString)(properties.prometheusUrl));
    errors.collect(ros.propertyValidator('localityLoadBalancing', ros.validateBoolean)(properties.localityLoadBalancing));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    if (properties.accessLogServicePort && (typeof properties.accessLogServicePort) !== 'object') {
        errors.collect(ros.propertyValidator('accessLogServicePort', ros.validateRange)({
            data: properties.accessLogServicePort,
            min: 0,
            max: 65535,
        }));
    }
    errors.collect(ros.propertyValidator('accessLogServicePort', ros.validateNumber)(properties.accessLogServicePort));
    if (properties.apiServerLoadBalancerSpec && (typeof properties.apiServerLoadBalancerSpec) !== 'object') {
        errors.collect(ros.propertyValidator('apiServerLoadBalancerSpec', ros.validateAllowedValues)({
            data: properties.apiServerLoadBalancerSpec,
            allowedValues: ["slb.s1.small", "slb.s2.small", "slb.s2.medium", "slb.s3.small", "slb.s3.medium", "slb.s3.large"],
        }));
    }
    errors.collect(ros.propertyValidator('apiServerLoadBalancerSpec', ros.validateString)(properties.apiServerLoadBalancerSpec));
    errors.collect(ros.propertyValidator('multiBufferEnabled', ros.validateBoolean)(properties.multiBufferEnabled));
    errors.collect(ros.propertyValidator('dnsProxyingEnabled', ros.validateBoolean)(properties.dnsProxyingEnabled));
    errors.collect(ros.propertyValidator('opaEnabled', ros.validateBoolean)(properties.opaEnabled));
    errors.collect(ros.propertyValidator('existingCaType', ros.validateString)(properties.existingCaType));
    errors.collect(ros.propertyValidator('excludeIpRanges', ros.validateString)(properties.excludeIpRanges));
    errors.collect(ros.propertyValidator('vSwitches', ros.requiredValidator)(properties.vSwitches));
    errors.collect(ros.propertyValidator('vSwitches', ros.listValidator(ros.validateAny))(properties.vSwitches));
    errors.collect(ros.propertyValidator('guestCluster', ros.validateString)(properties.guestCluster));
    errors.collect(ros.propertyValidator('accessLogServiceEnabled', ros.validateBoolean)(properties.accessLogServiceEnabled));
    errors.collect(ros.propertyValidator('localityLbConf', ros.validateString)(properties.localityLbConf));
    errors.collect(ros.propertyValidator('mseEnabled', ros.validateBoolean)(properties.mseEnabled));
    errors.collect(ros.propertyValidator('istioVersion', ros.validateString)(properties.istioVersion));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateRange)({
            data: properties.period,
            min: 1,
            max: 36,
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('accessLogServiceHost', ros.validateString)(properties.accessLogServiceHost));
    errors.collect(ros.propertyValidator('outboundTrafficPolicy', ros.validateString)(properties.outboundTrafficPolicy));
    errors.collect(ros.propertyValidator('playgroundScene', ros.validateString)(properties.playgroundScene));
    errors.collect(ros.propertyValidator('edition', ros.validateString)(properties.edition));
    errors.collect(ros.propertyValidator('gatewayApiEnabled', ros.validateBoolean)(properties.gatewayApiEnabled));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('includeIpRanges', ros.validateString)(properties.includeIpRanges));
    errors.collect(ros.propertyValidator('controlPlaneLogEnabled', ros.validateBoolean)(properties.controlPlaneLogEnabled));
    errors.collect(ros.propertyValidator('tracing', ros.validateBoolean)(properties.tracing));
    errors.collect(ros.propertyValidator('configSourceNacosId', ros.validateString)(properties.configSourceNacosId));
    errors.collect(ros.propertyValidator('accessLogEnabled', ros.validateBoolean)(properties.accessLogEnabled));
    errors.collect(ros.propertyValidator('certChain', ros.validateString)(properties.certChain));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('pilotLoadBalancerSpec', ros.validateString)(properties.pilotLoadBalancerSpec));
    errors.collect(ros.propertyValidator('existingRootCaCert', ros.validateString)(properties.existingRootCaCert));
    errors.collect(ros.propertyValidator('proxy', RosServiceMesh_ProxyPropertyValidator)(properties.proxy));
    errors.collect(ros.propertyValidator('customizedPrometheus', ros.validateBoolean)(properties.customizedPrometheus));
    errors.collect(ros.propertyValidator('multiBufferPollDelay', ros.validateString)(properties.multiBufferPollDelay));
    errors.collect(ros.propertyValidator('mysqlFilterEnabled', ros.validateBoolean)(properties.mysqlFilterEnabled));
    errors.collect(ros.propertyValidator('enableSdsServer', ros.validateBoolean)(properties.enableSdsServer));
    errors.collect(ros.propertyValidator('enableAmbient', ros.validateBoolean)(properties.enableAmbient));
    errors.collect(ros.propertyValidator('controlPlaneLogProject', ros.validateString)(properties.controlPlaneLogProject));
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('enableAudit', ros.validateBoolean)(properties.enableAudit));
    errors.collect(ros.propertyValidator('configSourceEnabled', ros.validateBoolean)(properties.configSourceEnabled));
    errors.collect(ros.propertyValidator('accessLogProject', ros.validateString)(properties.accessLogProject));
    errors.collect(ros.propertyValidator('accessLogFormat', ros.validateString)(properties.accessLogFormat));
    errors.collect(ros.propertyValidator('filterGatewayClusterConfig', ros.validateBoolean)(properties.filterGatewayClusterConfig));
    errors.collect(ros.propertyValidator('accessLogFile', ros.validateString)(properties.accessLogFile));
    if (properties.clusterSpec && (typeof properties.clusterSpec) !== 'object') {
        errors.collect(ros.propertyValidator('clusterSpec', ros.validateAllowedValues)({
            data: properties.clusterSpec,
            allowedValues: ["standard", "enterprise", "ultimate"],
        }));
    }
    errors.collect(ros.propertyValidator('clusterSpec', ros.validateString)(properties.clusterSpec));
    errors.collect(ros.propertyValidator('apiServerPublicEip', ros.validateBoolean)(properties.apiServerPublicEip));
    errors.collect(ros.propertyValidator('telemetry', ros.validateBoolean)(properties.telemetry));
    errors.collect(ros.propertyValidator('auditProject', ros.validateString)(properties.auditProject));
    errors.collect(ros.propertyValidator('useExistingCa', ros.validateBoolean)(properties.useExistingCa));
    errors.collect(ros.propertyValidator('traceSampling', ros.validateNumber)(properties.traceSampling));
    errors.collect(ros.propertyValidator('enableCrHistory', ros.validateBoolean)(properties.enableCrHistory));
    errors.collect(ros.propertyValidator('kialiEnabled', ros.validateBoolean)(properties.kialiEnabled));
    errors.collect(ros.propertyValidator('webAssemblyFilterEnabled', ros.validateBoolean)(properties.webAssemblyFilterEnabled));
    errors.collect(ros.propertyValidator('existingRootCaKey', ros.validateString)(properties.existingRootCaKey));
    errors.collect(ros.propertyValidator('pilotPublicEip', ros.validateBoolean)(properties.pilotPublicEip));
    if (properties.chargeType && (typeof properties.chargeType) !== 'object') {
        errors.collect(ros.propertyValidator('chargeType', ros.validateAllowedValues)({
            data: properties.chargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('chargeType', ros.validateString)(properties.chargeType));
    errors.collect(ros.propertyValidator('crAggregationEnabled', ros.validateBoolean)(properties.crAggregationEnabled));
    errors.collect(ros.propertyValidator('excludeOutboundPorts', ros.validateString)(properties.excludeOutboundPorts));
    errors.collect(ros.propertyValidator('existingCaKey', ros.validateString)(properties.existingCaKey));
    errors.collect(ros.propertyValidator('enableAcmg', ros.validateBoolean)(properties.enableAcmg));
    errors.collect(ros.propertyValidator('existingCaCert', ros.validateString)(properties.existingCaCert));
    errors.collect(ros.propertyValidator('customizedZipkin', ros.validateBoolean)(properties.customizedZipkin));
    return errors.wrap('supplied properties not correct for "RosServiceMeshProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh` resource
 *
 * @param properties - the TypeScript properties of a `RosServiceMeshProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosServiceMeshPropsValidator(properties).assertSuccess();
    }
    return {
        'VpcId': ros.stringToRosTemplate(properties.vpcId),
        'VSwitches': ros.listMapper(ros.objectToRosTemplate)(properties.vSwitches),
        'AccessLogEnabled': ros.booleanToRosTemplate(properties.accessLogEnabled),
        'AccessLogFile': ros.stringToRosTemplate(properties.accessLogFile),
        'AccessLogFormat': ros.stringToRosTemplate(properties.accessLogFormat),
        'AccessLogProject': ros.stringToRosTemplate(properties.accessLogProject),
        'AccessLogServiceEnabled': ros.booleanToRosTemplate(properties.accessLogServiceEnabled),
        'AccessLogServiceHost': ros.stringToRosTemplate(properties.accessLogServiceHost),
        'AccessLogServicePort': ros.numberToRosTemplate(properties.accessLogServicePort),
        'ApiServerLoadBalancerSpec': ros.stringToRosTemplate(properties.apiServerLoadBalancerSpec),
        'ApiServerPublicEip': ros.booleanToRosTemplate(properties.apiServerPublicEip),
        'AuditProject': ros.stringToRosTemplate(properties.auditProject),
        'AutoRenew': ros.booleanToRosTemplate(properties.autoRenew),
        'AutoRenewPeriod': ros.numberToRosTemplate(properties.autoRenewPeriod),
        'CertChain': ros.stringToRosTemplate(properties.certChain),
        'ChargeType': ros.stringToRosTemplate(properties.chargeType),
        'ClusterSpec': ros.stringToRosTemplate(properties.clusterSpec),
        'ConfigSourceEnabled': ros.booleanToRosTemplate(properties.configSourceEnabled),
        'ConfigSourceNacosID': ros.stringToRosTemplate(properties.configSourceNacosId),
        'ControlPlaneLogEnabled': ros.booleanToRosTemplate(properties.controlPlaneLogEnabled),
        'ControlPlaneLogProject': ros.stringToRosTemplate(properties.controlPlaneLogProject),
        'CRAggregationEnabled': ros.booleanToRosTemplate(properties.crAggregationEnabled),
        'CustomizedPrometheus': ros.booleanToRosTemplate(properties.customizedPrometheus),
        'CustomizedZipkin': ros.booleanToRosTemplate(properties.customizedZipkin),
        'DNSProxyingEnabled': ros.booleanToRosTemplate(properties.dnsProxyingEnabled),
        'DubboFilterEnabled': ros.booleanToRosTemplate(properties.dubboFilterEnabled),
        'Edition': ros.stringToRosTemplate(properties.edition),
        'EnableACMG': ros.booleanToRosTemplate(properties.enableAcmg),
        'EnableAmbient': ros.booleanToRosTemplate(properties.enableAmbient),
        'EnableAudit': ros.booleanToRosTemplate(properties.enableAudit),
        'EnableCRHistory': ros.booleanToRosTemplate(properties.enableCrHistory),
        'EnableSDSServer': ros.booleanToRosTemplate(properties.enableSdsServer),
        'ExcludeInboundPorts': ros.stringToRosTemplate(properties.excludeInboundPorts),
        'ExcludeIPRanges': ros.stringToRosTemplate(properties.excludeIpRanges),
        'ExcludeOutboundPorts': ros.stringToRosTemplate(properties.excludeOutboundPorts),
        'ExistingCaCert': ros.stringToRosTemplate(properties.existingCaCert),
        'ExistingCaKey': ros.stringToRosTemplate(properties.existingCaKey),
        'ExistingCaType': ros.stringToRosTemplate(properties.existingCaType),
        'ExistingRootCaCert': ros.stringToRosTemplate(properties.existingRootCaCert),
        'ExistingRootCaKey': ros.stringToRosTemplate(properties.existingRootCaKey),
        'FilterGatewayClusterConfig': ros.booleanToRosTemplate(properties.filterGatewayClusterConfig),
        'GatewayAPIEnabled': ros.booleanToRosTemplate(properties.gatewayApiEnabled),
        'GuestCluster': ros.stringToRosTemplate(properties.guestCluster),
        'IncludeIPRanges': ros.stringToRosTemplate(properties.includeIpRanges),
        'IstioVersion': ros.stringToRosTemplate(properties.istioVersion),
        'KialiEnabled': ros.booleanToRosTemplate(properties.kialiEnabled),
        'LocalityLBConf': ros.stringToRosTemplate(properties.localityLbConf),
        'LocalityLoadBalancing': ros.booleanToRosTemplate(properties.localityLoadBalancing),
        'MSEEnabled': ros.booleanToRosTemplate(properties.mseEnabled),
        'MultiBufferEnabled': ros.booleanToRosTemplate(properties.multiBufferEnabled),
        'MultiBufferPollDelay': ros.stringToRosTemplate(properties.multiBufferPollDelay),
        'MysqlFilterEnabled': ros.booleanToRosTemplate(properties.mysqlFilterEnabled),
        'Name': ros.stringToRosTemplate(properties.name),
        'OPA': rosServiceMeshOPAPropertyToRosTemplate(properties.opa),
        'OpaEnabled': ros.booleanToRosTemplate(properties.opaEnabled),
        'OutboundTrafficPolicy': ros.stringToRosTemplate(properties.outboundTrafficPolicy),
        'Period': ros.numberToRosTemplate(properties.period),
        'PilotLoadBalancerSpec': ros.stringToRosTemplate(properties.pilotLoadBalancerSpec),
        'PilotPublicEip': ros.booleanToRosTemplate(properties.pilotPublicEip),
        'PlaygroundScene': ros.stringToRosTemplate(properties.playgroundScene),
        'PrometheusUrl': ros.stringToRosTemplate(properties.prometheusUrl),
        'Proxy': rosServiceMeshProxyPropertyToRosTemplate(properties.proxy),
        'Telemetry': ros.booleanToRosTemplate(properties.telemetry),
        'TraceSampling': ros.numberToRosTemplate(properties.traceSampling),
        'Tracing': ros.booleanToRosTemplate(properties.tracing),
        'UseExistingCA': ros.booleanToRosTemplate(properties.useExistingCa),
        'WebAssemblyFilterEnabled': ros.booleanToRosTemplate(properties.webAssemblyFilterEnabled),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ASM::ServiceMesh`, which is used to create a Service Mesh (ASM) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `ServiceMesh` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-asm-servicemesh
 */
class RosServiceMesh extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosServiceMesh.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrServiceMeshId = this.getAtt('ServiceMeshId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.vpcId = props.vpcId;
        this.vSwitches = props.vSwitches;
        this.accessLogEnabled = props.accessLogEnabled;
        this.accessLogFile = props.accessLogFile;
        this.accessLogFormat = props.accessLogFormat;
        this.accessLogProject = props.accessLogProject;
        this.accessLogServiceEnabled = props.accessLogServiceEnabled;
        this.accessLogServiceHost = props.accessLogServiceHost;
        this.accessLogServicePort = props.accessLogServicePort;
        this.apiServerLoadBalancerSpec = props.apiServerLoadBalancerSpec;
        this.apiServerPublicEip = props.apiServerPublicEip;
        this.auditProject = props.auditProject;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.certChain = props.certChain;
        this.chargeType = props.chargeType;
        this.clusterSpec = props.clusterSpec;
        this.configSourceEnabled = props.configSourceEnabled;
        this.configSourceNacosId = props.configSourceNacosId;
        this.controlPlaneLogEnabled = props.controlPlaneLogEnabled;
        this.controlPlaneLogProject = props.controlPlaneLogProject;
        this.crAggregationEnabled = props.crAggregationEnabled;
        this.customizedPrometheus = props.customizedPrometheus;
        this.customizedZipkin = props.customizedZipkin;
        this.dnsProxyingEnabled = props.dnsProxyingEnabled;
        this.dubboFilterEnabled = props.dubboFilterEnabled;
        this.edition = props.edition;
        this.enableAcmg = props.enableAcmg;
        this.enableAmbient = props.enableAmbient;
        this.enableAudit = props.enableAudit;
        this.enableCrHistory = props.enableCrHistory;
        this.enableSdsServer = props.enableSdsServer;
        this.excludeInboundPorts = props.excludeInboundPorts;
        this.excludeIpRanges = props.excludeIpRanges;
        this.excludeOutboundPorts = props.excludeOutboundPorts;
        this.existingCaCert = props.existingCaCert;
        this.existingCaKey = props.existingCaKey;
        this.existingCaType = props.existingCaType;
        this.existingRootCaCert = props.existingRootCaCert;
        this.existingRootCaKey = props.existingRootCaKey;
        this.filterGatewayClusterConfig = props.filterGatewayClusterConfig;
        this.gatewayApiEnabled = props.gatewayApiEnabled;
        this.guestCluster = props.guestCluster;
        this.includeIpRanges = props.includeIpRanges;
        this.istioVersion = props.istioVersion;
        this.kialiEnabled = props.kialiEnabled;
        this.localityLbConf = props.localityLbConf;
        this.localityLoadBalancing = props.localityLoadBalancing;
        this.mseEnabled = props.mseEnabled;
        this.multiBufferEnabled = props.multiBufferEnabled;
        this.multiBufferPollDelay = props.multiBufferPollDelay;
        this.mysqlFilterEnabled = props.mysqlFilterEnabled;
        this.name = props.name;
        this.opa = props.opa;
        this.opaEnabled = props.opaEnabled;
        this.outboundTrafficPolicy = props.outboundTrafficPolicy;
        this.period = props.period;
        this.pilotLoadBalancerSpec = props.pilotLoadBalancerSpec;
        this.pilotPublicEip = props.pilotPublicEip;
        this.playgroundScene = props.playgroundScene;
        this.prometheusUrl = props.prometheusUrl;
        this.proxy = props.proxy;
        this.telemetry = props.telemetry;
        this.traceSampling = props.traceSampling;
        this.tracing = props.tracing;
        this.useExistingCa = props.useExistingCa;
        this.webAssemblyFilterEnabled = props.webAssemblyFilterEnabled;
    }
    get rosProperties() {
        return {
            vpcId: this.vpcId,
            vSwitches: this.vSwitches,
            accessLogEnabled: this.accessLogEnabled,
            accessLogFile: this.accessLogFile,
            accessLogFormat: this.accessLogFormat,
            accessLogProject: this.accessLogProject,
            accessLogServiceEnabled: this.accessLogServiceEnabled,
            accessLogServiceHost: this.accessLogServiceHost,
            accessLogServicePort: this.accessLogServicePort,
            apiServerLoadBalancerSpec: this.apiServerLoadBalancerSpec,
            apiServerPublicEip: this.apiServerPublicEip,
            auditProject: this.auditProject,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            certChain: this.certChain,
            chargeType: this.chargeType,
            clusterSpec: this.clusterSpec,
            configSourceEnabled: this.configSourceEnabled,
            configSourceNacosId: this.configSourceNacosId,
            controlPlaneLogEnabled: this.controlPlaneLogEnabled,
            controlPlaneLogProject: this.controlPlaneLogProject,
            crAggregationEnabled: this.crAggregationEnabled,
            customizedPrometheus: this.customizedPrometheus,
            customizedZipkin: this.customizedZipkin,
            dnsProxyingEnabled: this.dnsProxyingEnabled,
            dubboFilterEnabled: this.dubboFilterEnabled,
            edition: this.edition,
            enableAcmg: this.enableAcmg,
            enableAmbient: this.enableAmbient,
            enableAudit: this.enableAudit,
            enableCrHistory: this.enableCrHistory,
            enableSdsServer: this.enableSdsServer,
            excludeInboundPorts: this.excludeInboundPorts,
            excludeIpRanges: this.excludeIpRanges,
            excludeOutboundPorts: this.excludeOutboundPorts,
            existingCaCert: this.existingCaCert,
            existingCaKey: this.existingCaKey,
            existingCaType: this.existingCaType,
            existingRootCaCert: this.existingRootCaCert,
            existingRootCaKey: this.existingRootCaKey,
            filterGatewayClusterConfig: this.filterGatewayClusterConfig,
            gatewayApiEnabled: this.gatewayApiEnabled,
            guestCluster: this.guestCluster,
            includeIpRanges: this.includeIpRanges,
            istioVersion: this.istioVersion,
            kialiEnabled: this.kialiEnabled,
            localityLbConf: this.localityLbConf,
            localityLoadBalancing: this.localityLoadBalancing,
            mseEnabled: this.mseEnabled,
            multiBufferEnabled: this.multiBufferEnabled,
            multiBufferPollDelay: this.multiBufferPollDelay,
            mysqlFilterEnabled: this.mysqlFilterEnabled,
            name: this.name,
            opa: this.opa,
            opaEnabled: this.opaEnabled,
            outboundTrafficPolicy: this.outboundTrafficPolicy,
            period: this.period,
            pilotLoadBalancerSpec: this.pilotLoadBalancerSpec,
            pilotPublicEip: this.pilotPublicEip,
            playgroundScene: this.playgroundScene,
            prometheusUrl: this.prometheusUrl,
            proxy: this.proxy,
            telemetry: this.telemetry,
            traceSampling: this.traceSampling,
            tracing: this.tracing,
            useExistingCa: this.useExistingCa,
            webAssemblyFilterEnabled: this.webAssemblyFilterEnabled,
        };
    }
    renderProperties(props) {
        return rosServiceMeshPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosServiceMesh = RosServiceMesh;
/**
 * The resource type name for this resource class.
 */
RosServiceMesh.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ASM::ServiceMesh";
/**
 * Determine whether the given properties match those of a `OPAProperty`
 *
 * @param properties - the TypeScript properties of a `OPAProperty`
 *
 * @returns the result of the validation.
 */
function RosServiceMesh_OPAPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('opaRequestCpu', ros.validateString)(properties.opaRequestCpu));
    errors.collect(ros.propertyValidator('openAgentPolicy', ros.validateBoolean)(properties.openAgentPolicy));
    errors.collect(ros.propertyValidator('opaLogLevel', ros.validateString)(properties.opaLogLevel));
    errors.collect(ros.propertyValidator('opaLimitCpu', ros.validateString)(properties.opaLimitCpu));
    errors.collect(ros.propertyValidator('opaLimitMemory', ros.validateString)(properties.opaLimitMemory));
    errors.collect(ros.propertyValidator('opaRequestMemory', ros.validateString)(properties.opaRequestMemory));
    return errors.wrap('supplied properties not correct for "OPAProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.OPA` resource
 *
 * @param properties - the TypeScript properties of a `OPAProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.OPA` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshOPAPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServiceMesh_OPAPropertyValidator(properties).assertSuccess();
    return {
        'OPARequestCPU': ros.stringToRosTemplate(properties.opaRequestCpu),
        'OpenAgentPolicy': ros.booleanToRosTemplate(properties.openAgentPolicy),
        'OPALogLevel': ros.stringToRosTemplate(properties.opaLogLevel),
        'OPALimitCPU': ros.stringToRosTemplate(properties.opaLimitCpu),
        'OPALimitMemory': ros.stringToRosTemplate(properties.opaLimitMemory),
        'OPARequestMemory': ros.stringToRosTemplate(properties.opaRequestMemory),
    };
}
/**
 * Determine whether the given properties match those of a `ProxyProperty`
 *
 * @param properties - the TypeScript properties of a `ProxyProperty`
 *
 * @returns the result of the validation.
 */
function RosServiceMesh_ProxyPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('clusterDomain', ros.validateString)(properties.clusterDomain));
    errors.collect(ros.propertyValidator('proxyLimitCpu', ros.validateString)(properties.proxyLimitCpu));
    errors.collect(ros.propertyValidator('proxyLimitMemory', ros.validateString)(properties.proxyLimitMemory));
    errors.collect(ros.propertyValidator('proxyRequestCpu', ros.validateString)(properties.proxyRequestCpu));
    errors.collect(ros.propertyValidator('proxyRequestMemory', ros.validateString)(properties.proxyRequestMemory));
    return errors.wrap('supplied properties not correct for "ProxyProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.Proxy` resource
 *
 * @param properties - the TypeScript properties of a `ProxyProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.Proxy` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshProxyPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServiceMesh_ProxyPropertyValidator(properties).assertSuccess();
    return {
        'ClusterDomain': ros.stringToRosTemplate(properties.clusterDomain),
        'ProxyLimitCPU': ros.stringToRosTemplate(properties.proxyLimitCpu),
        'ProxyLimitMemory': ros.stringToRosTemplate(properties.proxyLimitMemory),
        'ProxyRequestCPU': ros.stringToRosTemplate(properties.proxyRequestCpu),
        'ProxyRequestMemory': ros.stringToRosTemplate(properties.proxyRequestMemory),
    };
}
//# sourceMappingURL=data:application/json;base64,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