"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceMesh = exports.ServiceMeshProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const asm_generated_1 = require("./asm.generated");
Object.defineProperty(exports, "ServiceMeshProperty", { enumerable: true, get: function () { return asm_generated_1.RosServiceMesh; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ASM::ServiceMesh`, which is used to create a Service Mesh (ASM) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosServiceMesh`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-asm-servicemesh
 */
class ServiceMesh extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosServiceMesh = new asm_generated_1.RosServiceMesh(this, id, {
            excludeInboundPorts: props.excludeInboundPorts,
            opa: props.opa,
            dubboFilterEnabled: props.dubboFilterEnabled,
            prometheusUrl: props.prometheusUrl,
            localityLoadBalancing: props.localityLoadBalancing,
            name: props.name,
            accessLogServicePort: props.accessLogServicePort,
            apiServerLoadBalancerSpec: props.apiServerLoadBalancerSpec,
            multiBufferEnabled: props.multiBufferEnabled,
            dnsProxyingEnabled: props.dnsProxyingEnabled,
            opaEnabled: props.opaEnabled,
            existingCaType: props.existingCaType,
            excludeIpRanges: props.excludeIpRanges,
            vSwitches: props.vSwitches,
            guestCluster: props.guestCluster,
            accessLogServiceEnabled: props.accessLogServiceEnabled,
            localityLbConf: props.localityLbConf,
            mseEnabled: props.mseEnabled,
            istioVersion: props.istioVersion,
            period: props.period,
            accessLogServiceHost: props.accessLogServiceHost,
            outboundTrafficPolicy: props.outboundTrafficPolicy,
            playgroundScene: props.playgroundScene,
            edition: props.edition,
            gatewayApiEnabled: props.gatewayApiEnabled,
            vpcId: props.vpcId,
            includeIpRanges: props.includeIpRanges,
            controlPlaneLogEnabled: props.controlPlaneLogEnabled,
            tracing: props.tracing,
            configSourceNacosId: props.configSourceNacosId,
            accessLogEnabled: props.accessLogEnabled,
            certChain: props.certChain,
            autoRenew: props.autoRenew,
            pilotLoadBalancerSpec: props.pilotLoadBalancerSpec,
            existingRootCaCert: props.existingRootCaCert,
            proxy: props.proxy,
            customizedPrometheus: props.customizedPrometheus,
            multiBufferPollDelay: props.multiBufferPollDelay,
            mysqlFilterEnabled: props.mysqlFilterEnabled,
            enableSdsServer: props.enableSdsServer,
            enableAmbient: props.enableAmbient,
            controlPlaneLogProject: props.controlPlaneLogProject,
            autoRenewPeriod: props.autoRenewPeriod,
            enableAudit: props.enableAudit,
            configSourceEnabled: props.configSourceEnabled,
            accessLogProject: props.accessLogProject,
            accessLogFormat: props.accessLogFormat,
            filterGatewayClusterConfig: props.filterGatewayClusterConfig,
            accessLogFile: props.accessLogFile,
            clusterSpec: props.clusterSpec,
            apiServerPublicEip: props.apiServerPublicEip,
            telemetry: props.telemetry,
            auditProject: props.auditProject,
            useExistingCa: props.useExistingCa,
            traceSampling: props.traceSampling,
            enableCrHistory: props.enableCrHistory,
            kialiEnabled: props.kialiEnabled,
            webAssemblyFilterEnabled: props.webAssemblyFilterEnabled,
            existingRootCaKey: props.existingRootCaKey,
            pilotPublicEip: props.pilotPublicEip,
            chargeType: props.chargeType,
            crAggregationEnabled: props.crAggregationEnabled,
            excludeOutboundPorts: props.excludeOutboundPorts,
            existingCaKey: props.existingCaKey,
            enableAcmg: props.enableAcmg,
            existingCaCert: props.existingCaCert,
            customizedZipkin: props.customizedZipkin,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosServiceMesh;
        this.attrServiceMeshId = rosServiceMesh.attrServiceMeshId;
    }
}
exports.ServiceMesh = ServiceMesh;
//# sourceMappingURL=data:application/json;base64,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