"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1beta.healthcheck_pb2
import core.mgmt.v1beta.mgmt_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing
import vdp.pipeline.v1beta.common_pb2
import vdp.pipeline.v1beta.component_definition_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _State:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATE_UNSPECIFIED: _State.ValueType  # 0
    """Unspecified."""
    STATE_INACTIVE: _State.ValueType  # 1
    """Inactive."""
    STATE_ACTIVE: _State.ValueType  # 2
    """Active."""
    STATE_ERROR: _State.ValueType  # 3
    """The pipeline has an error."""

class State(_State, metaclass=_StateEnumTypeWrapper):
    """State describes the state of a pipeline."""

STATE_UNSPECIFIED: State.ValueType  # 0
"""Unspecified."""
STATE_INACTIVE: State.ValueType  # 1
"""Inactive."""
STATE_ACTIVE: State.ValueType  # 2
"""Active."""
STATE_ERROR: State.ValueType  # 3
"""The pipeline has an error."""
global___State = State

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1beta.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class TriggerByRequest(google.protobuf.message.Message):
    """TriggerByRequest
    Configures the payload format of request when triggered by a request.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class RequestField(google.protobuf.message.Message):
        """Represents a field within the reqeuest."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TITLE_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        INSTILL_FORMAT_FIELD_NUMBER: builtins.int
        INSTILL_UI_ORDER_FIELD_NUMBER: builtins.int
        INSTILL_UI_MULTILINE_FIELD_NUMBER: builtins.int
        title: builtins.str
        """Title of the field."""
        description: builtins.str
        """Description of the field."""
        instill_format: builtins.str
        """Instill format."""
        instill_ui_order: builtins.int
        """Instill UI order."""
        instill_ui_multiline: builtins.bool
        """Instill UI Multiline."""
        def __init__(
            self,
            *,
            title: builtins.str = ...,
            description: builtins.str = ...,
            instill_format: builtins.str = ...,
            instill_ui_order: builtins.int = ...,
            instill_ui_multiline: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "instill_format", b"instill_format", "instill_ui_multiline", b"instill_ui_multiline", "instill_ui_order", b"instill_ui_order", "title", b"title"]) -> None: ...

    @typing_extensions.final
    class ResponseField(google.protobuf.message.Message):
        """Represents a field within the response."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TITLE_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        INSTILL_UI_ORDER_FIELD_NUMBER: builtins.int
        title: builtins.str
        """Title of the field."""
        description: builtins.str
        """Description of the field."""
        value: builtins.str
        """Value of the field."""
        instill_ui_order: builtins.int
        """Instill UI order."""
        def __init__(
            self,
            *,
            title: builtins.str = ...,
            description: builtins.str = ...,
            value: builtins.str = ...,
            instill_ui_order: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "instill_ui_order", b"instill_ui_order", "title", b"title", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class RequestFieldsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TriggerByRequest.RequestField: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___TriggerByRequest.RequestField | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class ResponseFieldsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TriggerByRequest.ResponseField: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___TriggerByRequest.ResponseField | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_FIELDS_FIELD_NUMBER: builtins.int
    RESPONSE_FIELDS_FIELD_NUMBER: builtins.int
    @property
    def request_fields(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TriggerByRequest.RequestField]:
        """Fields configuration of request.
        Key: Key of the input data.
        Field: Field settings of the value.
        """
    @property
    def response_fields(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TriggerByRequest.ResponseField]:
        """Fields configuration of response.
        Key: Key of the input data.
        Field: Field settings of the value.
        """
    def __init__(
        self,
        *,
        request_fields: collections.abc.Mapping[builtins.str, global___TriggerByRequest.RequestField] | None = ...,
        response_fields: collections.abc.Mapping[builtins.str, global___TriggerByRequest.ResponseField] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["request_fields", b"request_fields", "response_fields", b"response_fields"]) -> None: ...

global___TriggerByRequest = TriggerByRequest

@typing_extensions.final
class ConnectorComponent(google.protobuf.message.Message):
    """ConnectorComponent
    Configures a connector component. Requires the creation of a connector resource first.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEFINITION_NAME_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    CONDITION_FIELD_NUMBER: builtins.int
    CONNECTION_FIELD_NUMBER: builtins.int
    definition_name: builtins.str
    """Definition name."""
    @property
    def definition(self) -> vdp.pipeline.v1beta.component_definition_pb2.ConnectorDefinition:
        """Connector definition."""
    task: builtins.str
    """Task."""
    @property
    def input(self) -> google.protobuf.struct_pb2.Struct:
        """Input configuration of the component. JSON schema described in the connector definition."""
    condition: builtins.str
    """Condition statement determining whether the component is executed or not."""
    @property
    def connection(self) -> google.protobuf.struct_pb2.Struct:
        """Connection configuration of the component. JSON schema described in the connector definition."""
    def __init__(
        self,
        *,
        definition_name: builtins.str = ...,
        definition: vdp.pipeline.v1beta.component_definition_pb2.ConnectorDefinition | None = ...,
        task: builtins.str = ...,
        input: google.protobuf.struct_pb2.Struct | None = ...,
        condition: builtins.str = ...,
        connection: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connection", b"connection", "definition", b"definition", "input", b"input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["condition", b"condition", "connection", b"connection", "definition", b"definition", "definition_name", b"definition_name", "input", b"input", "task", b"task"]) -> None: ...

global___ConnectorComponent = ConnectorComponent

@typing_extensions.final
class OperatorComponent(google.protobuf.message.Message):
    """OperatorComponent
    Configures an operator component.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEFINITION_NAME_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    CONDITION_FIELD_NUMBER: builtins.int
    definition_name: builtins.str
    """Definition name."""
    @property
    def definition(self) -> vdp.pipeline.v1beta.component_definition_pb2.OperatorDefinition:
        """Operator definition."""
    task: builtins.str
    """Task."""
    @property
    def input(self) -> google.protobuf.struct_pb2.Struct:
        """Input configuration of the component. JSON schema described in the operator definition."""
    condition: builtins.str
    """Condition statement determining whether the component is executed or not."""
    def __init__(
        self,
        *,
        definition_name: builtins.str = ...,
        definition: vdp.pipeline.v1beta.component_definition_pb2.OperatorDefinition | None = ...,
        task: builtins.str = ...,
        input: google.protobuf.struct_pb2.Struct | None = ...,
        condition: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["definition", b"definition", "input", b"input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["condition", b"condition", "definition", b"definition", "definition_name", b"definition_name", "input", b"input", "task", b"task"]) -> None: ...

global___OperatorComponent = OperatorComponent

@typing_extensions.final
class IteratorComponent(google.protobuf.message.Message):
    """IteratorComponent
    Configures an iterator component. An iterator takes an array and executes an
    operation (defined by a set of nested components) on each of its elements.
    It can be regarded as triggering a sub-pipeline using the elements of an
    array as input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class OutputElementsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_ELEMENTS_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    CONDITION_FIELD_NUMBER: builtins.int
    DATA_SPECIFICATION_FIELD_NUMBER: builtins.int
    input: builtins.str
    """Input: The iterator will iterate over the elements of the input (must be an array)."""
    @property
    def output_elements(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Output elements: Configure the output arrays of the iterator.
        The key is the output element variable name, and the value is the data reference of the template.
        Example:
        output_elements: {
          "key1": "${element.output.a}",
          "key2": "${element.output.b}",
        }
        This will create the results:
        output: {
          "key1": [ ${element1.output.a},  ${element2.output.a} ... ],
          "key2": [ ${element1.output.b},  ${element2.output.b} ... ],
        }
        """
    @property
    def components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NestedComponent]:
        """Components: These components will be executed for each input element."""
    condition: builtins.str
    """Condition statement determining whether the component is executed or not."""
    @property
    def data_specification(self) -> vdp.pipeline.v1beta.component_definition_pb2.DataSpecification:
        """DataSpecification returns the JSON schema for the iterator input and output."""
    def __init__(
        self,
        *,
        input: builtins.str = ...,
        output_elements: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        components: collections.abc.Iterable[global___NestedComponent] | None = ...,
        condition: builtins.str = ...,
        data_specification: vdp.pipeline.v1beta.component_definition_pb2.DataSpecification | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data_specification", b"data_specification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "condition", b"condition", "data_specification", b"data_specification", "input", b"input", "output_elements", b"output_elements"]) -> None: ...

global___IteratorComponent = IteratorComponent

@typing_extensions.final
class Component(google.protobuf.message.Message):
    """Component
    Fundamental building block in pipelines.

    For more information, see [Pipeline
    Component](https://www.instill.tech/docs/latest/core/concepts/pipeline#pipeline-component)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CONNECTOR_COMPONENT_FIELD_NUMBER: builtins.int
    OPERATOR_COMPONENT_FIELD_NUMBER: builtins.int
    ITERATOR_COMPONENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Component ID, provided by the user on creation."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata of the component."""
    @property
    def connector_component(self) -> global___ConnectorComponent:
        """ConnectorComponent"""
    @property
    def operator_component(self) -> global___OperatorComponent:
        """OperatorComponent"""
    @property
    def iterator_component(self) -> global___IteratorComponent:
        """IteratorComponent"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        connector_component: global___ConnectorComponent | None = ...,
        operator_component: global___OperatorComponent | None = ...,
        iterator_component: global___IteratorComponent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["component", b"component", "connector_component", b"connector_component", "iterator_component", b"iterator_component", "metadata", b"metadata", "operator_component", b"operator_component"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["component", b"component", "connector_component", b"connector_component", "id", b"id", "iterator_component", b"iterator_component", "metadata", b"metadata", "operator_component", b"operator_component"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["component", b"component"]) -> typing_extensions.Literal["connector_component", "operator_component", "iterator_component"] | None: ...

global___Component = Component

@typing_extensions.final
class NestedComponent(google.protobuf.message.Message):
    """NestedComponent
    Fundamental building block in iterator component.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CONNECTOR_COMPONENT_FIELD_NUMBER: builtins.int
    OPERATOR_COMPONENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Component ID, provided by the user on creation."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata of the component."""
    @property
    def connector_component(self) -> global___ConnectorComponent:
        """ConnectorConfiguration"""
    @property
    def operator_component(self) -> global___OperatorComponent:
        """OperatorConfiguration"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        connector_component: global___ConnectorComponent | None = ...,
        operator_component: global___OperatorComponent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["component", b"component", "connector_component", b"connector_component", "metadata", b"metadata", "operator_component", b"operator_component"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["component", b"component", "connector_component", b"connector_component", "id", b"id", "metadata", b"metadata", "operator_component", b"operator_component"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["component", b"component"]) -> typing_extensions.Literal["connector_component", "operator_component"] | None: ...

global___NestedComponent = NestedComponent

@typing_extensions.final
class Trigger(google.protobuf.message.Message):
    """Trigger"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_BY_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def trigger_by_request(self) -> global___TriggerByRequest:
        """Triggered by reqeust."""
    def __init__(
        self,
        *,
        trigger_by_request: global___TriggerByRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["trigger", b"trigger", "trigger_by_request", b"trigger_by_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["trigger", b"trigger", "trigger_by_request", b"trigger_by_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["trigger", b"trigger"]) -> typing_extensions.Literal["trigger_by_request"] | None: ...

global___Trigger = Trigger

@typing_extensions.final
class Recipe(google.protobuf.message.Message):
    """Recipe describes the components of a Pipeline and how they are connected."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    TRIGGER_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Recipe schema version."""
    @property
    def components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Component]:
        """List of pipeline components."""
    @property
    def trigger(self) -> global___Trigger:
        """The component trigger method."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Local secrets"""
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        components: collections.abc.Iterable[global___Component] | None = ...,
        trigger: global___Trigger | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["trigger", b"trigger"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "secrets", b"secrets", "trigger", b"trigger", "version", b"version"]) -> None: ...

global___Recipe = Recipe

@typing_extensions.final
class Pipeline(google.protobuf.message.Message):
    """A Pipeline is an end-to-end workflow that automates a sequence of components
    to process data.

    For more information, see
    [Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline) in
    the official documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Pipeline._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: Pipeline._View.ValueType  # 0
        """Unspecified, equivalent to BASIC."""
        VIEW_BASIC: Pipeline._View.ValueType  # 1
        """Default view, only includes basic information."""
        VIEW_FULL: Pipeline._View.ValueType  # 2
        """Full representation."""
        VIEW_RECIPE: Pipeline._View.ValueType  # 3
        """Contains the recipe of the resource."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """View defines how a Pipeline is presented."""

    VIEW_UNSPECIFIED: Pipeline.View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: Pipeline.View.ValueType  # 1
    """Default view, only includes basic information."""
    VIEW_FULL: Pipeline.View.ValueType  # 2
    """Full representation."""
    VIEW_RECIPE: Pipeline.View.ValueType  # 3
    """Contains the recipe of the resource."""

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Pipeline._Visibility.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_UNSPECIFIED: Pipeline._Visibility.ValueType  # 0
        """Unspecified, equivalent to PRIVATE."""
        VISIBILITY_PRIVATE: Pipeline._Visibility.ValueType  # 1
        """Only the user can see the pipeline."""
        VISIBILITY_PUBLIC: Pipeline._Visibility.ValueType  # 2
        """Other users can see the pipeline."""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Visibility defines who can access the pipeline."""

    VISIBILITY_UNSPECIFIED: Pipeline.Visibility.ValueType  # 0
    """Unspecified, equivalent to PRIVATE."""
    VISIBILITY_PRIVATE: Pipeline.Visibility.ValueType  # 1
    """Only the user can see the pipeline."""
    VISIBILITY_PUBLIC: Pipeline.Visibility.ValueType  # 2
    """Other users can see the pipeline."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    SHARING_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    OWNER_NAME_FIELD_NUMBER: builtins.int
    RELEASES_FIELD_NUMBER: builtins.int
    README_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    DATA_SPECIFICATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the pipeline, defined by its parent and ID.
    - Format: `{parent_type}/{parent.id}/pipelines/{pipeline.id}`.
    """
    uid: builtins.str
    """Pipeline UUID."""
    id: builtins.str
    """Pipeline resource ID (used in `name` as the last segment). This conforms
    to RFC-1034, which restricts to letters, numbers, and hyphen, with the
    first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    description: builtins.str
    """Pipeline description."""
    @property
    def recipe(self) -> global___Recipe:
        """Recipe describes the components of a Pipeline and how they are connected."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline delete time."""
    @property
    def sharing(self) -> vdp.pipeline.v1beta.common_pb2.Sharing:
        """Pipeline sharing information."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Metadata holds console-related data such as the pipeline builder layout."""
    owner_name: builtins.str
    """Owner Name."""
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """Releases holds the history of pipeline versions."""
    readme: builtins.str
    """README holds the pipeline documentation."""
    @property
    def permission(self) -> vdp.pipeline.v1beta.common_pb2.Permission:
        """Permission defines how a pipeline can be used."""
    visibility: global___Pipeline.Visibility.ValueType
    """Pipeline visibility."""
    @property
    def owner(self) -> core.mgmt.v1beta.mgmt_pb2.Owner:
        """Pipeline owner."""
    @property
    def data_specification(self) -> vdp.pipeline.v1beta.component_definition_pb2.DataSpecification:
        """Data specifications."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        sharing: vdp.pipeline.v1beta.common_pb2.Sharing | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        owner_name: builtins.str = ...,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        readme: builtins.str = ...,
        permission: vdp.pipeline.v1beta.common_pb2.Permission | None = ...,
        visibility: global___Pipeline.Visibility.ValueType = ...,
        owner: core.mgmt.v1beta.mgmt_pb2.Owner | None = ...,
        data_specification: vdp.pipeline.v1beta.component_definition_pb2.DataSpecification | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "_owner", b"_owner", "create_time", b"create_time", "data_specification", b"data_specification", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "owner", b"owner", "permission", b"permission", "recipe", b"recipe", "sharing", b"sharing", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "_owner", b"_owner", "create_time", b"create_time", "data_specification", b"data_specification", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "owner", b"owner", "owner_name", b"owner_name", "permission", b"permission", "readme", b"readme", "recipe", b"recipe", "releases", b"releases", "sharing", b"sharing", "uid", b"uid", "update_time", b"update_time", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_owner", b"_owner"]) -> typing_extensions.Literal["owner"] | None: ...

global___Pipeline = Pipeline

@typing_extensions.final
class TriggerMetadata(google.protobuf.message.Message):
    """TriggerMetadata contains the traces of the pipeline inference."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TracesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Trace: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Trace | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRACES_FIELD_NUMBER: builtins.int
    @property
    def traces(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Trace]:
        """Each key in the `traces` object is a component ID. The value is a Trace
        object containing the execution details.
        """
    def __init__(
        self,
        *,
        traces: collections.abc.Mapping[builtins.str, global___Trace] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["traces", b"traces"]) -> None: ...

global___TriggerMetadata = TriggerMetadata

@typing_extensions.final
class Trace(google.protobuf.message.Message):
    """Trace contains the execution details of a component."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trace._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Trace._Status.ValueType  # 0
        """Unspecified."""
        STATUS_COMPLETED: Trace._Status.ValueType  # 1
        """Successfully completed."""
        STATUS_SKIPPED: Trace._Status.ValueType  # 2
        """Skipped."""
        STATUS_ERROR: Trace._Status.ValueType  # 3
        """Aborted with error."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status holds the the component execution outcome."""

    STATUS_UNSPECIFIED: Trace.Status.ValueType  # 0
    """Unspecified."""
    STATUS_COMPLETED: Trace.Status.ValueType  # 1
    """Successfully completed."""
    STATUS_SKIPPED: Trace.Status.ValueType  # 2
    """Skipped."""
    STATUS_ERROR: Trace.Status.ValueType  # 3
    """Aborted with error."""

    STATUSES_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_IN_SECONDS_FIELD_NUMBER: builtins.int
    @property
    def statuses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Trace.Status.ValueType]:
        """Statuses contains an execution status per input."""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Component inputs."""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Component outputs."""
    @property
    def error(self) -> google.protobuf.struct_pb2.Struct:
        """Error details."""
    compute_time_in_seconds: builtins.float
    """Computation time in seconds."""
    def __init__(
        self,
        *,
        statuses: collections.abc.Iterable[global___Trace.Status.ValueType] | None = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        error: google.protobuf.struct_pb2.Struct | None = ...,
        compute_time_in_seconds: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_in_seconds", b"compute_time_in_seconds", "error", b"error", "inputs", b"inputs", "outputs", b"outputs", "statuses", b"statuses"]) -> None: ...

global___Trace = Trace

@typing_extensions.final
class PipelineRelease(google.protobuf.message.Message):
    """Pipeline releases contain the version control information of a pipeline.
    This allows users to track changes in the pipeline over time.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RECIPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    README_FIELD_NUMBER: builtins.int
    DATA_SPECIFICATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the release, defined by its parent and ID.
    - Format: `{parent_type}/{parent.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    uid: builtins.str
    """Release UUID."""
    id: builtins.str
    """Release resource ID (used in `name` as the last segment). It must be a
    sematic version vX.Y.Z.
    """
    description: builtins.str
    """Release description."""
    @property
    def recipe(self) -> global___Recipe:
        """Recipe of the versioned pipeline."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline update time."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Pipeline deletion time."""
    alias: builtins.str
    """Alias."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Key-value object with console-related data such as the pipeline builder
        layout.
        """
    readme: builtins.str
    """README."""
    @property
    def data_specification(self) -> vdp.pipeline.v1beta.component_definition_pb2.DataSpecification:
        """Data specifications."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        recipe: global___Recipe | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        alias: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        readme: builtins.str = ...,
        data_specification: vdp.pipeline.v1beta.component_definition_pb2.DataSpecification | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "create_time", b"create_time", "data_specification", b"data_specification", "delete_time", b"delete_time", "description", b"description", "metadata", b"metadata", "recipe", b"recipe", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "alias", b"alias", "create_time", b"create_time", "data_specification", b"data_specification", "delete_time", b"delete_time", "description", b"description", "id", b"id", "metadata", b"metadata", "name", b"name", "readme", b"readme", "recipe", b"recipe", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...

global___PipelineRelease = PipelineRelease

@typing_extensions.final
class ListPipelinesRequest(google.protobuf.message.Message):
    """ListPipelinesRequest represents a request to list pipelines."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    - Example:
    `recipe.components.definition_name:"operator-definitions/2ac8be70-0f7a-4b61-a33d-098b8acfa6f3"`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    visibility: global___Pipeline.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
        visibility: global___Pipeline.Visibility.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListPipelinesRequest = ListPipelinesRequest

@typing_extensions.final
class ListPipelinesResponse(google.protobuf.message.Message):
    """ListPipelinesResponse contains a list of pipelines."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipelines."""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesResponse = ListPipelinesResponse

@typing_extensions.final
class LookUpPipelineRequest(google.protobuf.message.Message):
    """LookUpPipelineRequest represents a request to query a pipeline by its UID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the pipeline, which allows its access by UID.
    - Format: `pipelines/{pipeline.uid}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineRequest = LookUpPipelineRequest

@typing_extensions.final
class LookUpPipelineResponse(google.protobuf.message.Message):
    """LookUpPipelineResponse contains the requested pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The requested pipeline."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineResponse = LookUpPipelineResponse

@typing_extensions.final
class CreateUserPipelineRequest(google.protobuf.message.Message):
    """CreateUserPipelineRequest represents a request from a user to create a
    pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The properties of the pipeline to be created."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the pipeline.
    - Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineRequest = CreateUserPipelineRequest

@typing_extensions.final
class CreateUserPipelineResponse(google.protobuf.message.Message):
    """CreateUserPipelineResponse contains the created pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The created pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CreateUserPipelineResponse = CreateUserPipelineResponse

@typing_extensions.final
class ListUserPipelinesRequest(google.protobuf.message.Message):
    """ListUserPipelinesRequest represents a request to list the pipelines of a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    - Example:
    `recipe.components.definition_name:"operator-definitions/2ac8be70-0f7a-4b61-a33d-098b8acfa6f3"`.
    """
    parent: builtins.str
    """The parent resource, i.e., the user that created the pipelines.
    - Format: `users/{user.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    visibility: global___Pipeline.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
        visibility: global___Pipeline.Visibility.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListUserPipelinesRequest = ListUserPipelinesRequest

@typing_extensions.final
class ListUserPipelinesResponse(google.protobuf.message.Message):
    """ListUserPipelinesResponse contains a list of pipelines."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipelines."""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelinesResponse = ListUserPipelinesResponse

@typing_extensions.final
class GetUserPipelineRequest(google.protobuf.message.Message):
    """GetUserPipelineRequest represents a request to fetch the details of a
    pipeline owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineRequest = GetUserPipelineRequest

@typing_extensions.final
class GetUserPipelineResponse(google.protobuf.message.Message):
    """GetUserPipelineResponse contains the requested pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetUserPipelineResponse = GetUserPipelineResponse

@typing_extensions.final
class UpdateUserPipelineRequest(google.protobuf.message.Message):
    """UpdateUserPipelineRequest represents a request to update a pipeline owned by
    a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The pipeline fields that will replace the existing ones."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineRequest = UpdateUserPipelineRequest

@typing_extensions.final
class UpdateUserPipelineResponse(google.protobuf.message.Message):
    """UpdateUserPipelineResponse contains the updated pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The updated pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___UpdateUserPipelineResponse = UpdateUserPipelineResponse

@typing_extensions.final
class DeleteUserPipelineRequest(google.protobuf.message.Message):
    """DeleteUserPipelineRequest represents a request to delete a pipeline owned by
    a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineRequest = DeleteUserPipelineRequest

@typing_extensions.final
class DeleteUserPipelineResponse(google.protobuf.message.Message):
    """DeleteUserPipelineResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineResponse = DeleteUserPipelineResponse

@typing_extensions.final
class ValidateUserPipelineRequest(google.protobuf.message.Message):
    """ValidateUserPipelineRequest represents a request to validate a pipeline
    owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ValidateUserPipelineRequest = ValidateUserPipelineRequest

@typing_extensions.final
class ValidateUserPipelineResponse(google.protobuf.message.Message):
    """ValidateUserPipelineResponse contains a validated pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The validated pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___ValidateUserPipelineResponse = ValidateUserPipelineResponse

@typing_extensions.final
class RenameUserPipelineRequest(google.protobuf.message.Message):
    """RenameUserPipelineRequest represents a request to rename the name of a
    pipeline owned by a user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    new_pipeline_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `users/{user.id}/pipelines/{new_pipeline_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_id", b"new_pipeline_id"]) -> None: ...

global___RenameUserPipelineRequest = RenameUserPipelineRequest

@typing_extensions.final
class RenameUserPipelineResponse(google.protobuf.message.Message):
    """RenameUserPipelineResponse contains a renamed pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The renamed pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___RenameUserPipelineResponse = RenameUserPipelineResponse

@typing_extensions.final
class CloneUserPipelineRequest(google.protobuf.message.Message):
    """CloneUserPipelineRequest represents a request to clone a pipeline owned by a
    user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    target: builtins.str
    """The target pipeline name. It can be under a user or an organization
    namespace, so the following formats are accepted:
    - `users/{user.id}/pipelines/{pipeline.id}`
    - `organizations/{organization.id}/pipelines/{pipeline.id}`
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        target: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "target", b"target"]) -> None: ...

global___CloneUserPipelineRequest = CloneUserPipelineRequest

@typing_extensions.final
class CloneUserPipelineResponse(google.protobuf.message.Message):
    """CloneUserPipelineResponse contains a cloned pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The cloned pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CloneUserPipelineResponse = CloneUserPipelineResponse

@typing_extensions.final
class TriggerUserPipelineRequest(google.protobuf.message.Message):
    """TriggerUserPipelineRequest represents a request to trigger a user-owned
    pipeline synchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerUserPipelineRequest = TriggerUserPipelineRequest

@typing_extensions.final
class TriggerUserPipelineResponse(google.protobuf.message.Message):
    """TriggerUserPipelineResponse contains the pipeline execution results, i.e.,
    the multiple model inference outputs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """Traces of the pipeline inference."""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineResponse = TriggerUserPipelineResponse

@typing_extensions.final
class TriggerAsyncUserPipelineRequest(google.protobuf.message.Message):
    """TriggerUserPipelineRequest represents a request to trigger a user-owned
    pipeline synchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent user
    and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerAsyncUserPipelineRequest = TriggerAsyncUserPipelineRequest

@typing_extensions.final
class TriggerAsyncUserPipelineResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineResponse contains the information to access the
    status of an asynchronous pipeline execution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineResponse = TriggerAsyncUserPipelineResponse

@typing_extensions.final
class CreateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """CreateUserPipelineReleaseRequest represents a request to release a version
    in a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The release information."""
    parent: builtins.str
    """Name of the pipeline for which the release will be created.
    Format: `users/{user.id}/pipelines/{pipeline.id}`
    """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseRequest = CreateUserPipelineReleaseRequest

@typing_extensions.final
class CreateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """CreateUserPipelineReleaseResponse contains the created release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The created pipeline release object."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___CreateUserPipelineReleaseResponse = CreateUserPipelineReleaseResponse

@typing_extensions.final
class ListUserPipelineReleasesRequest(google.protobuf.message.Message):
    """ListUserPipelineReleasesRequest represents a request to list the releases in
    a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of releases to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    parent: builtins.str
    """The parent resource where this pipeline release will be created.
    Format: `users/{user.id}/pipelines/{pipeline.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserPipelineReleasesRequest = ListUserPipelineReleasesRequest

@typing_extensions.final
class ListUserPipelineReleasesResponse(google.protobuf.message.Message):
    """ListUserPipelineReleasesResponse contains a list of pipeline releases."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline release resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline releases."""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListUserPipelineReleasesResponse = ListUserPipelineReleasesResponse

@typing_extensions.final
class GetUserPipelineReleaseRequest(google.protobuf.message.Message):
    """GetUserPipelineReleaseRequest represents a request to fetchthe details of a
    release in a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserPipelineReleaseRequest = GetUserPipelineReleaseRequest

@typing_extensions.final
class GetUserPipelineReleaseResponse(google.protobuf.message.Message):
    """GetUserPipelineReleaseResponse contains the requested pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___GetUserPipelineReleaseResponse = GetUserPipelineReleaseResponse

@typing_extensions.final
class UpdateUserPipelineReleaseRequest(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseRequest represents a request to update a user-owned
    pipeline release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release fields that will replace the existing ones.
        A pipeline release resource to update
        """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserPipelineReleaseRequest = UpdateUserPipelineReleaseRequest

@typing_extensions.final
class UpdateUserPipelineReleaseResponse(google.protobuf.message.Message):
    """UpdateUserPipelineReleaseResponse contains the updated pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The updated pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___UpdateUserPipelineReleaseResponse = UpdateUserPipelineReleaseResponse

@typing_extensions.final
class DeleteUserPipelineReleaseRequest(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseRequest represents a request to delete a release in
    a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserPipelineReleaseRequest = DeleteUserPipelineReleaseRequest

@typing_extensions.final
class DeleteUserPipelineReleaseResponse(google.protobuf.message.Message):
    """DeleteUserPipelineReleaseResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserPipelineReleaseResponse = DeleteUserPipelineReleaseResponse

@typing_extensions.final
class RestoreUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseRequest represents a request to set the version of
    a user-owned pipeline to a pinned release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___RestoreUserPipelineReleaseRequest = RestoreUserPipelineReleaseRequest

@typing_extensions.final
class RestoreUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RestoreUserPipelineReleaseResponse contains the requested pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RestoreUserPipelineReleaseResponse = RestoreUserPipelineReleaseResponse

@typing_extensions.final
class RenameUserPipelineReleaseRequest(google.protobuf.message.Message):
    """RenameUserPipelineReleaseRequest represents a request to rename a release in
    a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    new_pipeline_release_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `users/{user.id}/pipelines/{pipeline.id}/releases{new_release_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_release_id", b"new_pipeline_release_id"]) -> None: ...

global___RenameUserPipelineReleaseRequest = RenameUserPipelineReleaseRequest

@typing_extensions.final
class RenameUserPipelineReleaseResponse(google.protobuf.message.Message):
    """RenameUserPipelineReleaseResponse contains a renamed pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The renamed pipeline release."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RenameUserPipelineReleaseResponse = RenameUserPipelineReleaseResponse

@typing_extensions.final
class TriggerUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseRequest represents a request to trigger a pinned
    release of a user-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerUserPipelineReleaseRequest = TriggerUserPipelineReleaseRequest

@typing_extensions.final
class TriggerUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseResponse contains the pipeline execution results,
    i.e., the multiple model inference outputs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """Traces of the pipeline inference."""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerUserPipelineReleaseResponse = TriggerUserPipelineReleaseResponse

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerUserPipelineReleaseRequest represents a request to trigger a pinned
    release of a user-owned pipeline asynchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format: `users/{user.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseRequest = TriggerAsyncUserPipelineReleaseRequest

@typing_extensions.final
class TriggerAsyncUserPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerAsyncUserPipelineReleaseResponse contains the information to access
    the status of an asynchronous pipeline execution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncUserPipelineReleaseResponse = TriggerAsyncUserPipelineReleaseResponse

@typing_extensions.final
class CreateOrganizationPipelineRequest(google.protobuf.message.Message):
    """CreateOrganizationPipelineRequest represents a request from an organization
    to create a pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The properties of the pipeline to be created."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the pipeline.
    - Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "pipeline", b"pipeline"]) -> None: ...

global___CreateOrganizationPipelineRequest = CreateOrganizationPipelineRequest

@typing_extensions.final
class CreateOrganizationPipelineResponse(google.protobuf.message.Message):
    """CreateOrganizationPipelineResponse contains the created pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The created pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CreateOrganizationPipelineResponse = CreateOrganizationPipelineResponse

@typing_extensions.final
class ListOrganizationPipelinesRequest(google.protobuf.message.Message):
    """ListOrganizationPipelinesRequest represents a request to list the pipelines
    of an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    - Example:
    `recipe.components.definition_name:"operator-definitions/2ac8be70-0f7a-4b61-a33d-098b8acfa6f3"`.
    """
    parent: builtins.str
    """The parent resource, i.e., the organization that created the pipelines.
    - Format: `organizations/{organization.id}`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    visibility: global___Pipeline.Visibility.ValueType
    """Limit results to pipelines with the specified visibility."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
        visibility: global___Pipeline.Visibility.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "_visibility", b"_visibility", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_visibility", b"_visibility"]) -> typing_extensions.Literal["visibility"] | None: ...

global___ListOrganizationPipelinesRequest = ListOrganizationPipelinesRequest

@typing_extensions.final
class ListOrganizationPipelinesResponse(google.protobuf.message.Message):
    """ListOrganizationPipelinesResponse contains a list of pipelines."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipelines."""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationPipelinesResponse = ListOrganizationPipelinesResponse

@typing_extensions.final
class GetOrganizationPipelineRequest(google.protobuf.message.Message):
    """GetOrganizationPipelineRequest represents a request to fetch the details of
    a pipeline owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationPipelineRequest = GetOrganizationPipelineRequest

@typing_extensions.final
class GetOrganizationPipelineResponse(google.protobuf.message.Message):
    """GetOrganizationPipelineResponse contains the requested pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___GetOrganizationPipelineResponse = GetOrganizationPipelineResponse

@typing_extensions.final
class UpdateOrganizationPipelineRequest(google.protobuf.message.Message):
    """UpdateOrganizationPipelineRequest represents a request to update a pipeline
    owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The pipeline fields that will replace the existing ones."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationPipelineRequest = UpdateOrganizationPipelineRequest

@typing_extensions.final
class UpdateOrganizationPipelineResponse(google.protobuf.message.Message):
    """UpdateOrganizationPipelineResponse contains the updated pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The updated pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___UpdateOrganizationPipelineResponse = UpdateOrganizationPipelineResponse

@typing_extensions.final
class DeleteOrganizationPipelineRequest(google.protobuf.message.Message):
    """DeleteOrganizationPipelineRequest represents a request to delete a pipeline
    owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationPipelineRequest = DeleteOrganizationPipelineRequest

@typing_extensions.final
class DeleteOrganizationPipelineResponse(google.protobuf.message.Message):
    """DeleteOrganizationPipelineResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationPipelineResponse = DeleteOrganizationPipelineResponse

@typing_extensions.final
class ValidateOrganizationPipelineRequest(google.protobuf.message.Message):
    """ValidateOrganizationPipelineRequest represents a request to validate a
    pipeline owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ValidateOrganizationPipelineRequest = ValidateOrganizationPipelineRequest

@typing_extensions.final
class ValidateOrganizationPipelineResponse(google.protobuf.message.Message):
    """ValidateOrganizationPipelineResponse contains a validated pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The validated pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___ValidateOrganizationPipelineResponse = ValidateOrganizationPipelineResponse

@typing_extensions.final
class RenameOrganizationPipelineRequest(google.protobuf.message.Message):
    """RenameOrganizationPipelineRequest represents a request to rename the name of
    a pipeline owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    new_pipeline_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `organizations/{organization.id}/pipelines/{new_pipeline_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_id", b"new_pipeline_id"]) -> None: ...

global___RenameOrganizationPipelineRequest = RenameOrganizationPipelineRequest

@typing_extensions.final
class RenameOrganizationPipelineResponse(google.protobuf.message.Message):
    """RenameOrganizationPipelineResponse contains a renamed pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The renamed pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___RenameOrganizationPipelineResponse = RenameOrganizationPipelineResponse

@typing_extensions.final
class CloneOrganizationPipelineRequest(google.protobuf.message.Message):
    """CloneOrganizationPipelineRequest represents a request to clone a pipeline
    owned by an organization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    target: builtins.str
    """The target pipeline name. It can be under a user or an organization
    namespace, so the following formats are accepted:
    - `users/{user.id}/pipelines/{pipeline.id}`
    - `organizations/{organization.id}/pipelines/{pipeline.id}`
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        target: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "target", b"target"]) -> None: ...

global___CloneOrganizationPipelineRequest = CloneOrganizationPipelineRequest

@typing_extensions.final
class CloneOrganizationPipelineResponse(google.protobuf.message.Message):
    """CloneOrganizationPipelineResponse contains a cloned pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The cloned pipeline resource."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___CloneOrganizationPipelineResponse = CloneOrganizationPipelineResponse

@typing_extensions.final
class TriggerOrganizationPipelineRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineRequest represents a request to trigger an
    organization-owned pipeline synchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerOrganizationPipelineRequest = TriggerOrganizationPipelineRequest

@typing_extensions.final
class TriggerOrganizationPipelineResponse(google.protobuf.message.Message):
    """TriggerOrganizationPipelineResponse contains the pipeline execution results,
    i.e., the multiple model inference outputs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """Traces of the pipeline inference."""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerOrganizationPipelineResponse = TriggerOrganizationPipelineResponse

@typing_extensions.final
class TriggerAsyncOrganizationPipelineRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineRequest represents a request to trigger an
    organization-owned pipeline synchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline, which allows its access by parent
    organization and ID.
    - Format: `organizations/{organization.id}/pipelines/{pipeline.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerAsyncOrganizationPipelineRequest = TriggerAsyncOrganizationPipelineRequest

@typing_extensions.final
class TriggerAsyncOrganizationPipelineResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineResponse contains the information to access
    the status of an asynchronous pipeline execution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationPipelineResponse = TriggerAsyncOrganizationPipelineResponse

@typing_extensions.final
class CreateOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """CreateOrganizationPipelineReleaseRequest represents a request to release a
    version in an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The release information."""
    parent: builtins.str
    """Name of the pipeline for which the release will be created.
    Format: `organizations/{organization.id}/pipelines/{pipeline.id}`
    """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "release", b"release"]) -> None: ...

global___CreateOrganizationPipelineReleaseRequest = CreateOrganizationPipelineReleaseRequest

@typing_extensions.final
class CreateOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """CreateOrganizationPipelineReleaseResponse contains the created release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The created pipeline release object."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___CreateOrganizationPipelineReleaseResponse = CreateOrganizationPipelineReleaseResponse

@typing_extensions.final
class ListOrganizationPipelineReleasesRequest(google.protobuf.message.Message):
    """ListOrganizationPipelineReleasesRequest represents a request to list the
    releases in an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of releases to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    parent: builtins.str
    """The parent resource where this pipeline release will be created.
    Format: `organizations/{organization.id}/pipelines/{pipeline.id}`
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListOrganizationPipelineReleasesRequest = ListOrganizationPipelineReleasesRequest

@typing_extensions.final
class ListOrganizationPipelineReleasesResponse(google.protobuf.message.Message):
    """ListOrganizationPipelineReleasesResponse contains a list of pipeline releases."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline release resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline releases."""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationPipelineReleasesResponse = ListOrganizationPipelineReleasesResponse

@typing_extensions.final
class GetOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """GetOrganizationPipelineReleaseRequest represents a request to fetchthe
    details of a release in an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetOrganizationPipelineReleaseRequest = GetOrganizationPipelineReleaseRequest

@typing_extensions.final
class GetOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """GetOrganizationPipelineReleaseResponse contains the requested pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___GetOrganizationPipelineReleaseResponse = GetOrganizationPipelineReleaseResponse

@typing_extensions.final
class UpdateOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """UpdateOrganizationPipelineReleaseRequest represents a request to update an
    organization-owned pipeline release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release fields that will replace the existing ones.
        A pipeline release resource to update
        """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationPipelineReleaseRequest = UpdateOrganizationPipelineReleaseRequest

@typing_extensions.final
class UpdateOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """UpdateOrganizationPipelineReleaseResponse contains the updated pipeline
    release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The updated pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___UpdateOrganizationPipelineReleaseResponse = UpdateOrganizationPipelineReleaseResponse

@typing_extensions.final
class DeleteOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """DeleteOrganizationPipelineReleaseRequest represents a request to delete a
    release in an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationPipelineReleaseRequest = DeleteOrganizationPipelineReleaseRequest

@typing_extensions.final
class DeleteOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """DeleteOrganizationPipelineReleaseResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationPipelineReleaseResponse = DeleteOrganizationPipelineReleaseResponse

@typing_extensions.final
class RestoreOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """RestoreOrganizationPipelineReleaseRequest represents a request to set the
    version of an organization-owned pipeline to a pinned release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___RestoreOrganizationPipelineReleaseRequest = RestoreOrganizationPipelineReleaseRequest

@typing_extensions.final
class RestoreOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """RestoreOrganizationPipelineReleaseResponse contains the requested pipeline
    release.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The pipeline release resource."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RestoreOrganizationPipelineReleaseResponse = RestoreOrganizationPipelineReleaseResponse

@typing_extensions.final
class RenameOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """RenameOrganizationPipelineReleaseRequest represents a request to rename a
    release in an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    new_pipeline_release_id: builtins.str
    """The new resource ID. This will transform the resource name into
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases{new_release_id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_pipeline_release_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_pipeline_release_id", b"new_pipeline_release_id"]) -> None: ...

global___RenameOrganizationPipelineReleaseRequest = RenameOrganizationPipelineReleaseRequest

@typing_extensions.final
class RenameOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """RenameOrganizationPipelineReleaseResponse contains a renamed pipeline release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASE_FIELD_NUMBER: builtins.int
    @property
    def release(self) -> global___PipelineRelease:
        """The renamed pipeline release."""
    def __init__(
        self,
        *,
        release: global___PipelineRelease | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["release", b"release"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["release", b"release"]) -> None: ...

global___RenameOrganizationPipelineReleaseResponse = RenameOrganizationPipelineReleaseResponse

@typing_extensions.final
class TriggerOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineReleaseRequest represents a request to trigger a
    pinned release of an organization-owned pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerOrganizationPipelineReleaseRequest = TriggerOrganizationPipelineReleaseRequest

@typing_extensions.final
class TriggerOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerOrganizationPipelineReleaseResponse contains the pipeline execution
    results, i.e., the multiple model inference outputs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Model inference outputs."""
    @property
    def metadata(self) -> global___TriggerMetadata:
        """Traces of the pipeline inference."""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        metadata: global___TriggerMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "outputs", b"outputs"]) -> None: ...

global___TriggerOrganizationPipelineReleaseResponse = TriggerOrganizationPipelineReleaseResponse

@typing_extensions.final
class TriggerAsyncOrganizationPipelineReleaseRequest(google.protobuf.message.Message):
    """TriggerOrganizationPipelineReleaseRequest represents a request to trigger a
    pinned release of an organization-owned pipeline asynchronously.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the pipeline release, which allows its access by
    parent pipeline and ID.
    - Format:
    `organizations/{organization.id}/pipelines/{pipeline.id}/releases/{release.id}`.
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Pipeline input parameters."""
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Pipeline secrets parameters that will override the pipeline's or owner's secrets."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        inputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "secrets", b"secrets"]) -> None: ...

global___TriggerAsyncOrganizationPipelineReleaseRequest = TriggerAsyncOrganizationPipelineReleaseRequest

@typing_extensions.final
class TriggerAsyncOrganizationPipelineReleaseResponse(google.protobuf.message.Message):
    """TriggerAsyncOrganizationPipelineReleaseResponse contains the information to
    access the status of an asynchronous pipeline execution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Long-running operation information."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___TriggerAsyncOrganizationPipelineReleaseResponse = TriggerAsyncOrganizationPipelineReleaseResponse

@typing_extensions.final
class GetOperationRequest(google.protobuf.message.Message):
    """GetOperationRequest represents a request to query a long-running operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource. Asynchronous methods will contain this
    information in their response.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOperationRequest = GetOperationRequest

@typing_extensions.final
class GetOperationResponse(google.protobuf.message.Message):
    """GetOperationResponse contains the long-running operation details."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The long-running operation."""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetOperationResponse = GetOperationResponse

@typing_extensions.final
class ListPipelinesAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListPipelinesAdminRequest represents a request by an admin to list all the
    pipelines. Admin users have access to pipelines from any user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of pipelines to return. If this parameter is
    unspecified, at most 10 pipelines will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    - Example:
    `recipe.components.definition_name:"operator-definitions/2ac8be70-0f7a-4b61-a33d-098b8acfa6f3"`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelinesAdminRequest = ListPipelinesAdminRequest

@typing_extensions.final
class ListPipelinesAdminResponse(google.protobuf.message.Message):
    """ListPipelinesAdminResponse contains a list of pipelines requested by an
    admin user.
    For the moment, the pipeline recipes will be UID-based (permalink) instead
    of name-based. This is a temporary solution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Pipeline]:
        """A list of pipeline resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipelines."""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___Pipeline] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipelines", b"pipelines", "total_size", b"total_size"]) -> None: ...

global___ListPipelinesAdminResponse = ListPipelinesAdminResponse

@typing_extensions.final
class ListPipelineReleasesAdminRequest(google.protobuf.message.Message):
    """ListPipelinesReleaseAdminRequest represents a request by an admin to list
    all pipeline releases. Admin users have access to pipelines from any user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of releases to return. If this parameter is
    unspecified, at most 10 releases will be returned. The cap value for this
    parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    show_deleted: builtins.bool
    """Include soft-deleted pipelines in the result."""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___Pipeline.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListPipelineReleasesAdminRequest = ListPipelineReleasesAdminRequest

@typing_extensions.final
class ListPipelineReleasesAdminResponse(google.protobuf.message.Message):
    """ListPipelineReleasesAdminResponse contains a list of pipeline releases
    requested by an admin user.
    For the moment, the pipeline recipes will be UID-based (permalink) instead
    of name-based. This is a temporary solution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELEASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def releases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineRelease]:
        """A list of pipeline releases."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline releases."""
    def __init__(
        self,
        *,
        releases: collections.abc.Iterable[global___PipelineRelease] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "releases", b"releases", "total_size", b"total_size"]) -> None: ...

global___ListPipelineReleasesAdminResponse = ListPipelineReleasesAdminResponse

@typing_extensions.final
class LookUpPipelineAdminRequest(google.protobuf.message.Message):
    """LookUpPipelineAdminRequest represents a request by an admin to query a
    pipeline by its UID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the pipeline, which allows its access by UID.
    - Format: `pipelines/{pipeline.uid}`.
    """
    view: global___Pipeline.View.ValueType
    """View allows clients to specify the desired pipeline view in the response."""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___Pipeline.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpPipelineAdminRequest = LookUpPipelineAdminRequest

@typing_extensions.final
class LookUpPipelineAdminResponse(google.protobuf.message.Message):
    """LookUpPipelineAdminResponse contains the requested pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_FIELD_NUMBER: builtins.int
    @property
    def pipeline(self) -> global___Pipeline:
        """The requested pipeline."""
    def __init__(
        self,
        *,
        pipeline: global___Pipeline | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline"]) -> None: ...

global___LookUpPipelineAdminResponse = LookUpPipelineAdminResponse
