# generated by datamodel-codegen:
#   filename:  airbyte_definitions.json

from __future__ import annotations

from dataclasses import dataclass, field
from enum import Enum
from typing import List, Optional, Union

from . import OAuth2


class AWSRegion(Enum):
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'
    af_south_1 = 'af-south-1'
    ap_east_1 = 'ap-east-1'
    ap_south_1 = 'ap-south-1'
    ap_northeast_1 = 'ap-northeast-1'
    ap_northeast_2 = 'ap-northeast-2'
    ap_northeast_3 = 'ap-northeast-3'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    cn_north_1 = 'cn-north-1'
    cn_northwest_1 = 'cn-northwest-1'
    eu_central_1 = 'eu-central-1'
    eu_north_1 = 'eu-north-1'
    eu_south_1 = 'eu-south-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    sa_east_1 = 'sa-east-1'
    me_south_1 = 'me-south-1'
    us_gov_east_1 = 'us-gov-east-1'
    us_gov_west_1 = 'us-gov-west-1'


@dataclass
class Amazonsqs:
    queue_url: str
    region: AWSRegion
    access_key: Optional[str] = None
    destination: str = 'airbyte-destination-amazon-sqs'
    message_body_key: Optional[str] = None
    message_delay: Optional[int] = None
    message_group_id: Optional[str] = None
    secret_key: Optional[str] = None


class CredentialsTitle(Enum):
    IAM_Role = 'IAM Role'


@dataclass
class IAMRole:
    role_arn: str
    credentials_title: CredentialsTitle = CredentialsTitle.IAM_Role


class CredentialsTitle1(Enum):
    IAM_User = 'IAM User'


@dataclass
class IAMUser:
    aws_access_key_id: str
    aws_secret_access_key: str
    credentials_title: CredentialsTitle1 = CredentialsTitle1.IAM_User


class CompressionCodecOptional(Enum):
    UNCOMPRESSED = 'UNCOMPRESSED'
    GZIP = 'GZIP'


class FormatType(Enum):
    JSONL = 'JSONL'


@dataclass
class JSONLinesNewlineDelimitedJSON:
    format_type: FormatType
    compression_codec: Optional[CompressionCodecOptional] = (
        CompressionCodecOptional.UNCOMPRESSED
    )


class CompressionCodecOptional1(Enum):
    UNCOMPRESSED = 'UNCOMPRESSED'
    SNAPPY = 'SNAPPY'
    GZIP = 'GZIP'
    ZSTD = 'ZSTD'


class FormatType1(Enum):
    Parquet = 'Parquet'


@dataclass
class ParquetColumnarStorage:
    format_type: FormatType1
    compression_codec: Optional[CompressionCodecOptional1] = (
        CompressionCodecOptional1.SNAPPY
    )


class ChooseHowToPartitionData(Enum):
    NO_PARTITIONING = 'NO PARTITIONING'
    DATE = 'DATE'
    YEAR = 'YEAR'
    MONTH = 'MONTH'
    DAY = 'DAY'
    YEAR_MONTH = 'YEAR/MONTH'
    YEAR_MONTH_DAY = 'YEAR/MONTH/DAY'


class S3BucketRegion(Enum):
    field_ = ''
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'
    af_south_1 = 'af-south-1'
    ap_east_1 = 'ap-east-1'
    ap_south_1 = 'ap-south-1'
    ap_northeast_1 = 'ap-northeast-1'
    ap_northeast_2 = 'ap-northeast-2'
    ap_northeast_3 = 'ap-northeast-3'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    cn_north_1 = 'cn-north-1'
    cn_northwest_1 = 'cn-northwest-1'
    eu_central_1 = 'eu-central-1'
    eu_north_1 = 'eu-north-1'
    eu_south_1 = 'eu-south-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    sa_east_1 = 'sa-east-1'
    me_south_1 = 'me-south-1'
    us_gov_east_1 = 'us-gov-east-1'
    us_gov_west_1 = 'us-gov-west-1'


@dataclass
class Awsdatalake:
    bucket_name: str
    credentials: Union[IAMRole, IAMUser]
    lakeformation_database_name: str
    region: S3BucketRegion
    aws_account_id: Optional[str] = None
    bucket_prefix: Optional[str] = None
    destination: str = 'airbyte-destination-aws-datalake'
    format: Optional[Union[JSONLinesNewlineDelimitedJSON, ParquetColumnarStorage]] = (
        None
    )
    glue_catalog_float_as_decimal: Optional[bool] = False
    lakeformation_database_default_tag_key: Optional[str] = None
    lakeformation_database_default_tag_values: Optional[str] = None
    lakeformation_governed_tables: Optional[bool] = False
    partitioning: Optional[ChooseHowToPartitionData] = (
        ChooseHowToPartitionData.NO_PARTITIONING
    )


class NormalizationFlattening(Enum):
    No_flattening = 'No flattening'
    Root_level_flattening = 'Root level flattening'


@dataclass
class CSVCommaSeparatedValues:
    flattening: NormalizationFlattening
    format_type: str = 'CSV'


@dataclass
class JSONLinesNewlineDelimitedJSON1:
    format_type: str = 'JSONL'


@dataclass
class Azureblobstorage:
    azure_blob_storage_account_key: str
    azure_blob_storage_account_name: str
    format: Union[CSVCommaSeparatedValues, JSONLinesNewlineDelimitedJSON1]
    azure_blob_storage_container_name: Optional[str] = None
    azure_blob_storage_endpoint_domain_name: Optional[str] = 'blob.core.windows.net'
    azure_blob_storage_output_buffer_size: Optional[int] = 5
    azure_blob_storage_spill_size: Optional[int] = 500
    destination: str = 'airbyte-destination-azure-blob-storage'


class DatasetLocation(Enum):
    US = 'US'
    EU = 'EU'
    asia_east1 = 'asia-east1'
    asia_east2 = 'asia-east2'
    asia_northeast1 = 'asia-northeast1'
    asia_northeast2 = 'asia-northeast2'
    asia_northeast3 = 'asia-northeast3'
    asia_south1 = 'asia-south1'
    asia_south2 = 'asia-south2'
    asia_southeast1 = 'asia-southeast1'
    asia_southeast2 = 'asia-southeast2'
    australia_southeast1 = 'australia-southeast1'
    australia_southeast2 = 'australia-southeast2'
    europe_central1 = 'europe-central1'
    europe_central2 = 'europe-central2'
    europe_north1 = 'europe-north1'
    europe_southwest1 = 'europe-southwest1'
    europe_west1 = 'europe-west1'
    europe_west2 = 'europe-west2'
    europe_west3 = 'europe-west3'
    europe_west4 = 'europe-west4'
    europe_west6 = 'europe-west6'
    europe_west7 = 'europe-west7'
    europe_west8 = 'europe-west8'
    europe_west9 = 'europe-west9'
    europe_west12 = 'europe-west12'
    me_central1 = 'me-central1'
    me_central2 = 'me-central2'
    me_west1 = 'me-west1'
    northamerica_northeast1 = 'northamerica-northeast1'
    northamerica_northeast2 = 'northamerica-northeast2'
    southamerica_east1 = 'southamerica-east1'
    southamerica_west1 = 'southamerica-west1'
    us_central1 = 'us-central1'
    us_east1 = 'us-east1'
    us_east2 = 'us-east2'
    us_east3 = 'us-east3'
    us_east4 = 'us-east4'
    us_east5 = 'us-east5'
    us_south1 = 'us-south1'
    us_west1 = 'us-west1'
    us_west2 = 'us-west2'
    us_west3 = 'us-west3'
    us_west4 = 'us-west4'


@dataclass
class HMACKey:
    hmac_key_access_id: str
    hmac_key_secret: str
    credential_type: str = 'HMAC_KEY'


class GCSTmpFilesAfterwardProcessing(Enum):
    Delete_all_tmp_files_from_GCS = 'Delete all tmp files from GCS'
    Keep_all_tmp_files_in_GCS = 'Keep all tmp files in GCS'


@dataclass
class GCSStaging:
    credential: HMACKey
    gcs_bucket_name: str
    gcs_bucket_path: str
    keep_files_in_gcs_bucket: Optional[GCSTmpFilesAfterwardProcessing] = (
        GCSTmpFilesAfterwardProcessing.Delete_all_tmp_files_from_GCS
    )
    method: str = 'GCS Staging'


@dataclass
class StandardInserts:
    method: str = 'Standard'


class TransformationQueryRunType(Enum):
    interactive = 'interactive'
    batch = 'batch'


@dataclass
class Bigquery:
    dataset_id: str
    dataset_location: DatasetLocation
    project_id: str
    big_query_client_buffer_size_mb: Optional[int] = 15
    credentials_json: Optional[str] = None
    destination: str = 'airbyte-destination-bigquery'
    disable_type_dedupe: Optional[bool] = False
    loading_method: Optional[Union[GCSStaging, StandardInserts]] = None
    raw_data_dataset: Optional[str] = None
    transformation_priority: Optional[TransformationQueryRunType] = (
        TransformationQueryRunType.interactive
    )


@dataclass
class Cassandra:
    address: str
    keyspace: str
    password: str
    port: int
    username: str
    datacenter: Optional[str] = 'datacenter1'
    destination: str = 'airbyte-destination-cassandra'
    replication: Optional[int] = 1


class Mode(Enum):
    azure_openai = 'azure_openai'


@dataclass
class AzureOpenAI:
    api_base: str
    deployment: str
    openai_key: str
    mode: Mode = Mode.azure_openai


class Mode1(Enum):
    openai = 'openai'


@dataclass
class OpenAI:
    openai_key: str
    mode: Mode1 = Mode1.openai


class Mode2(Enum):
    cohere = 'cohere'


@dataclass
class Cohere:
    cohere_key: str
    mode: Mode2 = Mode2.cohere


class Mode3(Enum):
    from_field = 'from_field'


@dataclass
class FromField:
    dimensions: int
    field_name: str
    mode: Mode3 = Mode3.from_field


class Mode4(Enum):
    fake = 'fake'


@dataclass
class Fake:
    mode: Mode4 = Mode4.fake


class Mode5(Enum):
    openai_compatible = 'openai_compatible'


@dataclass
class OpenAICompatible:
    base_url: str
    dimensions: int
    api_key: Optional[str] = ''
    mode: Mode5 = Mode5.openai_compatible
    model_name: Optional[str] = 'text-embedding-ada-002'


class Mode6(Enum):
    no_embedding = 'no_embedding'


@dataclass
class ChromaDefaultEmbeddingFunction:
    mode: Mode6 = Mode6.no_embedding


class Mode7(Enum):
    persistent_client = 'persistent_client'


@dataclass
class PersistentClientMode:
    path: str
    mode: Mode7 = Mode7.persistent_client


class Mode8(Enum):
    http_client = 'http_client'


@dataclass
class ClientServerMode:
    host: str
    port: int
    ssl: bool
    mode: Mode8 = Mode8.http_client
    password: Optional[str] = ''
    username: Optional[str] = ''


@dataclass
class Indexing:
    auth_method: Union[PersistentClientMode, ClientServerMode]
    collection_name: str


@dataclass
class FieldNameMappingConfigModel:
    from_field: str
    to_field: str


class Mode9(Enum):
    separator = 'separator'


@dataclass
class BySeparator:
    keep_separator: Optional[bool] = False
    mode: Mode9 = Mode9.separator
    separators: Optional[List[str]] = field(
        default_factory=lambda: ['"\\n\\n"', '"\\n"', '" "', '""']
    )


class Mode10(Enum):
    markdown = 'markdown'


@dataclass
class ByMarkdownHeader:
    mode: Mode10 = Mode10.markdown
    split_level: Optional[int] = 1


class Language(Enum):
    cpp = 'cpp'
    go = 'go'
    java = 'java'
    js = 'js'
    php = 'php'
    proto = 'proto'
    python = 'python'
    rst = 'rst'
    ruby = 'ruby'
    rust = 'rust'
    scala = 'scala'
    swift = 'swift'
    markdown = 'markdown'
    latex = 'latex'
    html = 'html'
    sol = 'sol'


class Mode11(Enum):
    code = 'code'


@dataclass
class ByProgrammingLanguage:
    language: Language
    mode: Mode11 = Mode11.code


@dataclass
class ProcessingConfigModel:
    chunk_size: int
    chunk_overlap: Optional[int] = 0
    field_name_mappings: Optional[List[FieldNameMappingConfigModel]] = field(
        default_factory=lambda: []
    )
    metadata_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_splitter: Optional[
        Union[BySeparator, ByMarkdownHeader, ByProgrammingLanguage]
    ] = None


@dataclass
class Chroma:
    embedding: Union[
        AzureOpenAI,
        OpenAI,
        Cohere,
        FromField,
        Fake,
        OpenAICompatible,
        ChromaDefaultEmbeddingFunction,
    ]
    indexing: Indexing
    processing: ProcessingConfigModel
    destination: str = 'airbyte-destination-chroma'
    omit_raw_text: Optional[bool] = False


@dataclass
class NoTunnel:
    tunnel_method: str = 'NO_TUNNEL'


@dataclass
class SSHKeyAuthentication:
    ssh_key: str
    tunnel_host: str
    tunnel_port: int
    tunnel_user: str
    tunnel_method: str = 'SSH_KEY_AUTH'


@dataclass
class PasswordAuthentication:
    tunnel_host: str
    tunnel_port: int
    tunnel_user: str
    tunnel_user_password: str
    tunnel_method: str = 'SSH_PASSWORD_AUTH'


@dataclass
class Clickhouse:
    database: str
    host: str
    port: int
    username: str
    destination: str = 'airbyte-destination-clickhouse'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    ssl: Optional[bool] = False
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


@dataclass
class Convex:
    access_key: str
    deployment_url: str
    destination: str = 'airbyte-destination-convex'


@dataclass
class Comma:
    delimiter: str = '\\u002c'


@dataclass
class Semicolon:
    delimiter: str = '\\u003b'


@dataclass
class Pipe:
    delimiter: str = '\\u007c'


@dataclass
class Tab:
    delimiter: str = '\\u0009'


@dataclass
class Space:
    delimiter: str = '\\u0020'


@dataclass
class Csv:
    destination_path: str
    delimiter_type: Optional[Union[Comma, Semicolon, Pipe, Tab, Space]] = None
    destination: str = 'airbyte-destination-csv'


@dataclass
class Cumulio:
    api_host: str
    api_key: str
    api_token: str
    destination: str = 'airbyte-destination-cumulio'


@dataclass
class Databend:
    database: str
    host: str
    username: str
    destination: str = 'airbyte-destination-databend'
    password: Optional[str] = None
    port: Optional[int] = 443
    table: Optional[str] = 'default'


@dataclass
class FieldRecommendedManagedTables:
    data_source_type: str = 'MANAGED_TABLES_STORAGE'


@dataclass
class AmazonS3:
    s3_access_key_id: str
    s3_bucket_name: str
    s3_bucket_path: str
    s3_bucket_region: S3BucketRegion
    s3_secret_access_key: str
    data_source_type: str = 'S3_STORAGE'
    file_name_pattern: Optional[str] = None


@dataclass
class AzureBlobStorage:
    azure_blob_storage_account_name: str
    azure_blob_storage_container_name: str
    azure_blob_storage_sas_token: str
    azure_blob_storage_endpoint_domain_name: Optional[str] = 'blob.core.windows.net'
    data_source_type: str = 'AZURE_BLOB_STORAGE'


@dataclass
class Databricks:
    accept_terms: bool
    data_source: Union[FieldRecommendedManagedTables, AmazonS3, AzureBlobStorage]
    databricks_http_path: str
    databricks_personal_access_token: str
    databricks_server_hostname: str
    database: Optional[str] = None
    databricks_port: Optional[str] = '443'
    destination: str = 'airbyte-destination-databricks'
    enable_schema_evolution: Optional[bool] = False
    purge_staging_data: Optional[bool] = True
    schema_: Optional[str] = 'default'


@dataclass
class Doris:
    database: str
    host: str
    httpport: int
    queryport: int
    username: str
    destination: str = 'airbyte-destination-doris'
    password: Optional[str] = None


@dataclass
class Duckdb:
    destination_path: str
    destination: str = 'airbyte-destination-duckdb'
    motherduck_api_key: Optional[str] = None
    schema_: Optional[str] = None


class DynamoDBRegion(Enum):
    field_ = ''
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'
    af_south_1 = 'af-south-1'
    ap_east_1 = 'ap-east-1'
    ap_south_1 = 'ap-south-1'
    ap_northeast_1 = 'ap-northeast-1'
    ap_northeast_2 = 'ap-northeast-2'
    ap_northeast_3 = 'ap-northeast-3'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    cn_north_1 = 'cn-north-1'
    cn_northwest_1 = 'cn-northwest-1'
    eu_central_1 = 'eu-central-1'
    eu_north_1 = 'eu-north-1'
    eu_south_1 = 'eu-south-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    sa_east_1 = 'sa-east-1'
    me_south_1 = 'me-south-1'
    us_gov_east_1 = 'us-gov-east-1'
    us_gov_west_1 = 'us-gov-west-1'


@dataclass
class Dynamodb:
    access_key_id: str
    dynamodb_region: DynamoDBRegion
    dynamodb_table_name_prefix: str
    secret_access_key: str
    destination: str = 'airbyte-destination-dynamodb'
    dynamodb_endpoint: Optional[str] = ''


class LoggingType(Enum):
    FirstN = 'FirstN'


@dataclass
class FirstNEntries:
    logging_type: LoggingType
    max_entry_count: float


class LoggingType1(Enum):
    EveryNth = 'EveryNth'


@dataclass
class EveryNThEntry:
    logging_type: LoggingType1
    max_entry_count: float
    nth_entry_to_log: float


class LoggingType2(Enum):
    RandomSampling = 'RandomSampling'


@dataclass
class RandomSampling:
    logging_type: LoggingType2
    max_entry_count: float
    sampling_ratio: float
    seed: Optional[float] = None


@dataclass
class Logging:
    logging_config: Union[FirstNEntries, EveryNThEntry, RandomSampling]
    test_destination_type: str = 'LOGGING'


@dataclass
class Silent:
    test_destination_type: str = 'SILENT'


@dataclass
class Throttled:
    millis_per_record: int
    test_destination_type: str = 'THROTTLED'


@dataclass
class Failing:
    num_messages: int
    test_destination_type: str = 'FAILING'


@dataclass
class E2etest:
    test_destination: Union[Logging, Silent, Throttled, Failing]
    destination: str = 'airbyte-destination-e2e-test'


@dataclass
class None1:
    method: str = 'none'


@dataclass
class ApiKeySecret:
    apiKeyId: str
    apiKeySecret: str
    method: str = 'secret'


@dataclass
class UsernamePassword:
    password: str
    username: str
    method: str = 'basic'


@dataclass
class Elasticsearch:
    endpoint: str
    authenticationMethod: Optional[Union[None1, ApiKeySecret, UsernamePassword]] = None
    ca_certificate: Optional[str] = None
    destination: str = 'airbyte-destination-elasticsearch'
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None
    upsert: Optional[bool] = True


@dataclass
class Exasol:
    host: str
    port: int
    schema_: str
    username: str
    certificateFingerprint: Optional[str] = None
    destination: str = 'airbyte-destination-exasol'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None


@dataclass
class SQLInserts:
    method: str = 'SQL'


@dataclass
class ExternalTableViaS3:
    aws_key_id: str
    aws_key_secret: str
    s3_bucket: str
    s3_region: str
    method: str = 'S3'


@dataclass
class Firebolt:
    database: str
    password: str
    username: str
    account: Optional[str] = None
    destination: str = 'airbyte-destination-firebolt'
    engine: Optional[str] = None
    host: Optional[str] = None
    loading_method: Optional[Union[SQLInserts, ExternalTableViaS3]] = None


@dataclass
class Firestore:
    project_id: str
    credentials_json: Optional[str] = None
    destination: str = 'airbyte-destination-firestore'


class CredentialType(Enum):
    HMAC_KEY = 'HMAC_KEY'


@dataclass
class HMACKey1:
    credential_type: CredentialType
    hmac_key_access_id: str
    hmac_key_secret: str


class Codec(Enum):
    no_compression = 'no compression'


@dataclass
class NoCompression:
    codec: Codec


class Codec1(Enum):
    Deflate = 'Deflate'


@dataclass
class Deflate:
    codec: Codec1
    compression_level: Optional[int] = 0


class Codec2(Enum):
    bzip2 = 'bzip2'


@dataclass
class Bzip2:
    codec: Codec2


class Codec3(Enum):
    xz = 'xz'


@dataclass
class Xz:
    codec: Codec3
    compression_level: Optional[int] = 6


class Codec4(Enum):
    zstandard = 'zstandard'


@dataclass
class Zstandard:
    codec: Codec4
    compression_level: Optional[int] = 3
    include_checksum: Optional[bool] = False


class Codec5(Enum):
    snappy = 'snappy'


@dataclass
class Snappy:
    codec: Codec5


class FormatType2(Enum):
    Avro = 'Avro'


@dataclass
class AvroApacheAvro:
    compression_codec: Union[NoCompression, Deflate, Bzip2, Xz, Zstandard, Snappy]
    format_type: FormatType2


class CompressionType(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression1:
    compression_type: Optional[CompressionType] = CompressionType.No_Compression


class CompressionType1(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP:
    compression_type: Optional[CompressionType1] = CompressionType1.GZIP


class Normalization(Enum):
    No_flattening = 'No flattening'
    Root_level_flattening = 'Root level flattening'


class FormatType3(Enum):
    CSV = 'CSV'


@dataclass
class CSVCommaSeparatedValues1:
    format_type: FormatType3
    compression: Optional[Union[NoCompression1, GZIP]] = None
    flattening: Optional[Normalization] = Normalization.No_flattening


class CompressionType2(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression2:
    compression_type: Optional[CompressionType2] = CompressionType2.No_Compression


class CompressionType3(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP1:
    compression_type: Optional[CompressionType3] = CompressionType3.GZIP


class FormatType4(Enum):
    JSONL = 'JSONL'


@dataclass
class JSONLinesNewlineDelimitedJSON2:
    format_type: FormatType4
    compression: Optional[Union[NoCompression2, GZIP1]] = None


class CompressionCodec(Enum):
    UNCOMPRESSED = 'UNCOMPRESSED'
    SNAPPY = 'SNAPPY'
    GZIP = 'GZIP'
    LZO = 'LZO'
    BROTLI = 'BROTLI'
    LZ4 = 'LZ4'
    ZSTD = 'ZSTD'


class FormatType5(Enum):
    Parquet = 'Parquet'


@dataclass
class ParquetColumnarStorage1:
    format_type: FormatType5
    block_size_mb: Optional[int] = 128
    compression_codec: Optional[CompressionCodec] = CompressionCodec.UNCOMPRESSED
    dictionary_encoding: Optional[bool] = True
    dictionary_page_size_kb: Optional[int] = 1024
    max_padding_size_mb: Optional[int] = 8
    page_size_kb: Optional[int] = 1024


class GCSBucketRegion(Enum):
    northamerica_northeast1 = 'northamerica-northeast1'
    northamerica_northeast2 = 'northamerica-northeast2'
    us_central1 = 'us-central1'
    us_east1 = 'us-east1'
    us_east4 = 'us-east4'
    us_west1 = 'us-west1'
    us_west2 = 'us-west2'
    us_west3 = 'us-west3'
    us_west4 = 'us-west4'
    southamerica_east1 = 'southamerica-east1'
    southamerica_west1 = 'southamerica-west1'
    europe_central2 = 'europe-central2'
    europe_north1 = 'europe-north1'
    europe_west1 = 'europe-west1'
    europe_west2 = 'europe-west2'
    europe_west3 = 'europe-west3'
    europe_west4 = 'europe-west4'
    europe_west6 = 'europe-west6'
    asia_east1 = 'asia-east1'
    asia_east2 = 'asia-east2'
    asia_northeast1 = 'asia-northeast1'
    asia_northeast2 = 'asia-northeast2'
    asia_northeast3 = 'asia-northeast3'
    asia_south1 = 'asia-south1'
    asia_south2 = 'asia-south2'
    asia_southeast1 = 'asia-southeast1'
    asia_southeast2 = 'asia-southeast2'
    australia_southeast1 = 'australia-southeast1'
    australia_southeast2 = 'australia-southeast2'
    asia = 'asia'
    eu = 'eu'
    us = 'us'
    asia1 = 'asia1'
    eur4 = 'eur4'
    nam4 = 'nam4'


@dataclass
class Gcs:
    credential: HMACKey1
    format: Union[
        AvroApacheAvro,
        CSVCommaSeparatedValues1,
        JSONLinesNewlineDelimitedJSON2,
        ParquetColumnarStorage1,
    ]
    gcs_bucket_name: str
    gcs_bucket_path: str
    destination: str = 'airbyte-destination-gcs'
    gcs_bucket_region: Optional[GCSBucketRegion] = GCSBucketRegion.us


@dataclass
class AuthenticationViaGoogleOAuth:
    client_id: str
    client_secret: str
    refresh_token: str


@dataclass
class Googlesheets:
    credentials: AuthenticationViaGoogleOAuth
    spreadsheet_id: str
    destination: str = 'airbyte-destination-google-sheets'


class CatalogType(Enum):
    Hive = 'Hive'


@dataclass
class HiveCatalogUseApacheHiveMetaStore:
    catalog_type: CatalogType
    hive_thrift_uri: str
    database: Optional[str] = 'default'


class CatalogType1(Enum):
    Hadoop = 'Hadoop'


@dataclass
class HadoopCatalogUseHierarchicalFileSystemsAsSameAsStorageConfig:
    catalog_type: CatalogType1
    database: Optional[str] = 'default'


class CatalogType2(Enum):
    Jdbc = 'Jdbc'


@dataclass
class JdbcCatalogUseRelationalDatabase:
    catalog_type: CatalogType2
    catalog_schema: Optional[str] = 'public'
    database: Optional[str] = 'public'
    jdbc_url: Optional[str] = None
    password: Optional[str] = None
    ssl: Optional[bool] = False
    username: Optional[str] = None


class CatalogType3(Enum):
    Rest = 'Rest'


@dataclass
class RESTCatalog:
    catalog_type: CatalogType3
    rest_uri: str
    rest_credential: Optional[str] = None
    rest_token: Optional[str] = None


class FileStorageFormat(Enum):
    Parquet = 'Parquet'
    Avro = 'Avro'


@dataclass
class FileFormat:
    format: FileStorageFormat
    auto_compact: Optional[bool] = False
    compact_target_file_size_in_mb: Optional[int] = 100
    flush_batch_size: Optional[int] = 10000


class StorageType(Enum):
    S3 = 'S3'


@dataclass
class S3:
    access_key_id: str
    s3_warehouse_uri: str
    secret_access_key: str
    storage_type: StorageType
    s3_bucket_region: Optional[S3BucketRegion] = ''
    s3_endpoint: Optional[str] = ''
    s3_path_style_access: Optional[bool] = True


class StorageType1(Enum):
    MANAGED = 'MANAGED'


@dataclass
class ServerManaged:
    managed_warehouse_name: str
    storage_type: StorageType1


@dataclass
class Iceberg:
    catalog_config: Union[
        HiveCatalogUseApacheHiveMetaStore,
        HadoopCatalogUseHierarchicalFileSystemsAsSameAsStorageConfig,
        JdbcCatalogUseRelationalDatabase,
        RESTCatalog,
    ]
    format_config: FileFormat
    storage_config: Union[S3, ServerManaged]
    destination: str = 'airbyte-destination-iceberg'


class ACKs(Enum):
    field_0 = '0'
    field_1 = '1'
    all = 'all'


class ClientDNSLookup(Enum):
    default = 'default'
    use_all_dns_ips = 'use_all_dns_ips'
    resolve_canonical_bootstrap_servers_only = (
        'resolve_canonical_bootstrap_servers_only'
    )
    use_all_dns_ips_1 = 'use_all_dns_ips'


class CompressionType4(Enum):
    none = 'none'
    gzip = 'gzip'
    snappy = 'snappy'
    lz4 = 'lz4'
    zstd = 'zstd'


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'


@dataclass
class PLAINTEXT:
    security_protocol: SecurityProtocol


class SASLMechanism(Enum):
    PLAIN = 'PLAIN'


class SecurityProtocol1(Enum):
    SASL_PLAINTEXT = 'SASL_PLAINTEXT'


@dataclass
class SASLPLAINTEXT:
    sasl_jaas_config: str
    sasl_mechanism: SASLMechanism
    security_protocol: SecurityProtocol1


class SASLMechanism1(Enum):
    GSSAPI = 'GSSAPI'
    OAUTHBEARER = 'OAUTHBEARER'
    SCRAM_SHA_256 = 'SCRAM-SHA-256'
    SCRAM_SHA_512 = 'SCRAM-SHA-512'
    PLAIN = 'PLAIN'


class SecurityProtocol2(Enum):
    SASL_SSL = 'SASL_SSL'


@dataclass
class SASLSSL:
    sasl_jaas_config: str
    sasl_mechanism: SASLMechanism1
    security_protocol: SecurityProtocol2


@dataclass
class Kafka:
    acks: ACKs
    batch_size: int
    bootstrap_servers: str
    buffer_memory: str
    client_dns_lookup: ClientDNSLookup
    compression_type: CompressionType4
    delivery_timeout_ms: int
    enable_idempotence: bool
    linger_ms: str
    max_block_ms: str
    max_in_flight_requests_per_connection: int
    max_request_size: int
    protocol: Union[PLAINTEXT, SASLPLAINTEXT, SASLSSL]
    receive_buffer_bytes: int
    request_timeout_ms: int
    retries: int
    send_buffer_bytes: int
    socket_connection_setup_timeout_max_ms: str
    socket_connection_setup_timeout_ms: str
    topic_pattern: str
    client_id: Optional[str] = None
    destination: str = 'airbyte-destination-kafka'
    sync_producer: Optional[bool] = False
    test_topic: Optional[str] = None


@dataclass
class Keen:
    api_key: str
    project_id: str
    destination: str = 'airbyte-destination-keen'
    infer_timestamp: Optional[bool] = True


@dataclass
class Kinesis:
    accessKey: str
    bufferSize: int
    endpoint: str
    privateKey: str
    region: str
    shardCount: int
    destination: str = 'airbyte-destination-kinesis'


class Mode12(Enum):
    openai = 'openai'


@dataclass
class OpenAI1:
    openai_key: str
    mode: Mode12 = Mode12.openai


class Mode13(Enum):
    fake = 'fake'


@dataclass
class Fake1:
    mode: Mode13 = Mode13.fake


class Mode14(Enum):
    pinecone = 'pinecone'


@dataclass
class Pinecone:
    index: str
    pinecone_environment: str
    pinecone_key: str
    mode: Mode14 = Mode14.pinecone


class Mode15(Enum):
    DocArrayHnswSearch = 'DocArrayHnswSearch'


@dataclass
class DocArrayHnswSearch:
    destination_path: str
    mode: Mode15 = Mode15.DocArrayHnswSearch


class Mode16(Enum):
    chroma_local = 'chroma_local'


@dataclass
class ChromaLocalPersistance:
    destination_path: str
    collection_name: Optional[str] = 'langchain'
    mode: Mode16 = Mode16.chroma_local


@dataclass
class ProcessingConfigModel1:
    chunk_size: int
    text_fields: List[str]
    chunk_overlap: Optional[int] = 0


@dataclass
class Langchain:
    embedding: Union[OpenAI1, Fake1]
    indexing: Union[Pinecone, DocArrayHnswSearch, ChromaLocalPersistance]
    processing: ProcessingConfigModel1
    destination: str = 'airbyte-destination-langchain'


@dataclass
class Localjson:
    destination_path: str
    destination: str = 'airbyte-destination-local-json'


@dataclass
class Mariadbcolumnstore:
    database: str
    host: str
    port: int
    username: str
    destination: str = 'airbyte-destination-mariadb-columnstore'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


@dataclass
class Meilisearch:
    host: str
    api_key: Optional[str] = None
    destination: str = 'airbyte-destination-meilisearch'


class Mode17(Enum):
    openai = 'openai'


@dataclass
class OpenAI2:
    openai_key: str
    mode: Mode17 = Mode17.openai


class Mode18(Enum):
    cohere = 'cohere'


@dataclass
class Cohere1:
    cohere_key: str
    mode: Mode18 = Mode18.cohere


class Mode19(Enum):
    fake = 'fake'


@dataclass
class Fake2:
    mode: Mode19 = Mode19.fake


class Mode20(Enum):
    azure_openai = 'azure_openai'


@dataclass
class AzureOpenAI1:
    api_base: str
    deployment: str
    openai_key: str
    mode: Mode20 = Mode20.azure_openai


class Mode21(Enum):
    openai_compatible = 'openai_compatible'


@dataclass
class OpenAICompatible1:
    base_url: str
    dimensions: int
    api_key: Optional[str] = ''
    mode: Mode21 = Mode21.openai_compatible
    model_name: Optional[str] = 'text-embedding-ada-002'


class Mode22(Enum):
    token = 'token'


@dataclass
class APIToken:
    token: str
    mode: Mode22 = Mode22.token


class Mode23(Enum):
    username_password = 'username_password'


@dataclass
class UsernamePassword1:
    password: str
    username: str
    mode: Mode23 = Mode23.username_password


class Mode24(Enum):
    no_auth = 'no_auth'


@dataclass
class NoAuth:
    mode: Mode24 = Mode24.no_auth


@dataclass
class Indexing1:
    auth: Union[APIToken, UsernamePassword1, NoAuth]
    collection: str
    host: str
    db: Optional[str] = ''
    text_field: Optional[str] = 'text'
    vector_field: Optional[str] = 'vector'


class Mode25(Enum):
    separator = 'separator'


@dataclass
class BySeparator1:
    keep_separator: Optional[bool] = False
    mode: Mode25 = Mode25.separator
    separators: Optional[List[str]] = field(
        default_factory=lambda: ['"\\n\\n"', '"\\n"', '" "', '""']
    )


class Mode26(Enum):
    markdown = 'markdown'


@dataclass
class ByMarkdownHeader1:
    mode: Mode26 = Mode26.markdown
    split_level: Optional[int] = 1


class Mode27(Enum):
    code = 'code'


@dataclass
class ByProgrammingLanguage1:
    language: Language
    mode: Mode27 = Mode27.code


@dataclass
class ProcessingConfigModel2:
    chunk_size: int
    chunk_overlap: Optional[int] = 0
    field_name_mappings: Optional[List[FieldNameMappingConfigModel]] = field(
        default_factory=lambda: []
    )
    metadata_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_splitter: Optional[
        Union[BySeparator1, ByMarkdownHeader1, ByProgrammingLanguage1]
    ] = None


@dataclass
class Milvus:
    embedding: Union[OpenAI2, Cohere1, Fake2, AzureOpenAI1, OpenAICompatible1]
    indexing: Indexing1
    processing: ProcessingConfigModel2
    destination: str = 'airbyte-destination-milvus'
    omit_raw_text: Optional[bool] = False


@dataclass
class None_1:
    authorization: str = 'none'


@dataclass
class LoginPassword:
    password: str
    username: str
    authorization: str = 'login/password'


class Instance(Enum):
    standalone = 'standalone'


@dataclass
class StandaloneMongoDbInstance:
    host: str
    instance: Instance
    port: int
    tls: Optional[bool] = False


class Instance1(Enum):
    replica = 'replica'


@dataclass
class ReplicaSet:
    instance: Instance1
    server_addresses: str
    replica_set: Optional[str] = None


class Instance2(Enum):
    atlas = 'atlas'


@dataclass
class MongoDBAtlas:
    cluster_url: str
    instance: Instance2


@dataclass
class Mongodb:
    auth_type: Union[None_1, LoginPassword]
    database: str
    destination: str = 'airbyte-destination-mongodb'
    instance_type: Optional[
        Union[StandaloneMongoDbInstance, ReplicaSet, MongoDBAtlas]
    ] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


class MessageQoS(Enum):
    AT_MOST_ONCE = 'AT_MOST_ONCE'
    AT_LEAST_ONCE = 'AT_LEAST_ONCE'
    EXACTLY_ONCE = 'EXACTLY_ONCE'


@dataclass
class Mqtt:
    automatic_reconnect: bool
    broker_host: str
    broker_port: int
    clean_session: bool
    connect_timeout: int
    message_qos: MessageQoS
    message_retained: bool
    publisher_sync: bool
    topic_pattern: str
    use_tls: bool
    client: Optional[str] = None
    destination: str = 'airbyte-destination-mqtt'
    password: Optional[str] = None
    topic_test: Optional[str] = None
    username: Optional[str] = None


class SslMethod(Enum):
    unencrypted = 'unencrypted'


@dataclass
class Unencrypted:
    ssl_method: SslMethod = SslMethod.unencrypted


class SslMethod1(Enum):
    encrypted_trust_server_certificate = 'encrypted_trust_server_certificate'


@dataclass
class EncryptedTrustServerCertificate:
    ssl_method: SslMethod1 = SslMethod1.encrypted_trust_server_certificate


class SslMethod2(Enum):
    encrypted_verify_certificate = 'encrypted_verify_certificate'


@dataclass
class EncryptedVerifyCertificate:
    hostNameInCertificate: Optional[str] = None
    ssl_method: SslMethod2 = SslMethod2.encrypted_verify_certificate


@dataclass
class Mssql:
    database: str
    host: str
    port: int
    schema_: str
    username: str
    destination: str = 'airbyte-destination-mssql'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    ssl_method: Optional[
        Union[Unencrypted, EncryptedTrustServerCertificate, EncryptedVerifyCertificate]
    ] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


@dataclass
class Mysql:
    database: str
    host: str
    port: int
    username: str
    destination: str = 'airbyte-destination-mysql'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    ssl: Optional[bool] = True
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


class EncryptionMethod(Enum):
    unencrypted = 'unencrypted'


@dataclass
class Unencrypted1:
    encryption_method: EncryptionMethod = EncryptionMethod.unencrypted


class EncryptionAlgorithm(Enum):
    AES256 = 'AES256'
    RC4_56 = 'RC4_56'
    field_3DES168 = '3DES168'


class EncryptionMethod1(Enum):
    client_nne = 'client_nne'


@dataclass
class NativeNetworkEncryptionNNE:
    encryption_algorithm: Optional[EncryptionAlgorithm] = EncryptionAlgorithm.AES256
    encryption_method: EncryptionMethod1 = EncryptionMethod1.client_nne


class EncryptionMethod2(Enum):
    encrypted_verify_certificate = 'encrypted_verify_certificate'


@dataclass
class TLSEncryptedVerifyCertificate:
    ssl_certificate: str
    encryption_method: EncryptionMethod2 = (
        EncryptionMethod2.encrypted_verify_certificate
    )


@dataclass
class Oracle:
    host: str
    port: int
    sid: str
    username: str
    destination: str = 'airbyte-destination-oracle'
    encryption: Optional[
        Union[Unencrypted1, NativeNetworkEncryptionNNE, TLSEncryptedVerifyCertificate]
    ] = None
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    schema_: Optional[str] = 'airbyte'
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


class Mode28(Enum):
    openai = 'openai'


@dataclass
class OpenAI3:
    openai_key: str
    mode: Mode28 = Mode28.openai


class Mode29(Enum):
    cohere = 'cohere'


@dataclass
class Cohere2:
    cohere_key: str
    mode: Mode29 = Mode29.cohere


class Mode30(Enum):
    fake = 'fake'


@dataclass
class Fake3:
    mode: Mode30 = Mode30.fake


class Mode31(Enum):
    azure_openai = 'azure_openai'


@dataclass
class AzureOpenAI2:
    api_base: str
    deployment: str
    openai_key: str
    mode: Mode31 = Mode31.azure_openai


class Mode32(Enum):
    openai_compatible = 'openai_compatible'


@dataclass
class OpenAICompatible2:
    base_url: str
    dimensions: int
    api_key: Optional[str] = ''
    mode: Mode32 = Mode32.openai_compatible
    model_name: Optional[str] = 'text-embedding-ada-002'


@dataclass
class Indexing2:
    index: str
    pinecone_environment: str
    pinecone_key: str


class Mode33(Enum):
    separator = 'separator'


@dataclass
class BySeparator2:
    keep_separator: Optional[bool] = False
    mode: Mode33 = Mode33.separator
    separators: Optional[List[str]] = field(
        default_factory=lambda: ['"\\n\\n"', '"\\n"', '" "', '""']
    )


class Mode34(Enum):
    markdown = 'markdown'


@dataclass
class ByMarkdownHeader2:
    mode: Mode34 = Mode34.markdown
    split_level: Optional[int] = 1


class Mode35(Enum):
    code = 'code'


@dataclass
class ByProgrammingLanguage2:
    language: Language
    mode: Mode35 = Mode35.code


@dataclass
class ProcessingConfigModel3:
    chunk_size: int
    chunk_overlap: Optional[int] = 0
    field_name_mappings: Optional[List[FieldNameMappingConfigModel]] = field(
        default_factory=lambda: []
    )
    metadata_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_splitter: Optional[
        Union[BySeparator2, ByMarkdownHeader2, ByProgrammingLanguage2]
    ] = None


@dataclass
class Pinecone1:
    embedding: Union[OpenAI3, Cohere2, Fake3, AzureOpenAI2, OpenAICompatible2]
    indexing: Indexing2
    processing: ProcessingConfigModel3
    destination: str = 'airbyte-destination-pinecone'
    omit_raw_text: Optional[bool] = False


class Mode36(Enum):
    disable = 'disable'


@dataclass
class Disable:
    mode: Mode36 = Mode36.disable


class Mode37(Enum):
    allow = 'allow'


@dataclass
class Allow:
    mode: Mode37 = Mode37.allow


class Mode38(Enum):
    prefer = 'prefer'


@dataclass
class Prefer:
    mode: Mode38 = Mode38.prefer


class Mode39(Enum):
    require = 'require'


@dataclass
class Require:
    mode: Mode39 = Mode39.require


class Mode40(Enum):
    verify_ca = 'verify-ca'


@dataclass
class VerifyCa:
    ca_certificate: str
    client_key_password: Optional[str] = None
    mode: Mode40 = Mode40.verify_ca


class Mode41(Enum):
    verify_full = 'verify-full'


@dataclass
class VerifyFull:
    ca_certificate: str
    client_certificate: str
    client_key: str
    client_key_password: Optional[str] = None
    mode: Mode41 = Mode41.verify_full


@dataclass
class Postgres:
    database: str
    host: str
    port: int
    schema_: str
    username: str
    destination: str = 'airbyte-destination-postgres'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    ssl: Optional[bool] = False
    ssl_mode: Optional[Union[Disable, Allow, Prefer, Require, VerifyCa, VerifyFull]] = (
        None
    )
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


@dataclass
class Pubsub:
    batching_enabled: bool
    credentials_json: str
    ordering_enabled: bool
    project_id: str
    topic_id: str
    batching_delay_threshold: Optional[int] = 1
    batching_element_count_threshold: Optional[int] = 1
    batching_request_bytes_threshold: Optional[int] = 1
    destination: str = 'airbyte-destination-pubsub'


class CompressionType5(Enum):
    NONE = 'NONE'
    LZ4 = 'LZ4'
    ZLIB = 'ZLIB'
    ZSTD = 'ZSTD'
    SNAPPY = 'SNAPPY'


class TopicType(Enum):
    persistent = 'persistent'
    non_persistent = 'non-persistent'


@dataclass
class Pulsar:
    batching_enabled: bool
    batching_max_messages: int
    batching_max_publish_delay: int
    block_if_queue_full: bool
    brokers: str
    compression_type: CompressionType5
    max_pending_messages: int
    max_pending_messages_across_partitions: int
    send_timeout_ms: int
    topic_namespace: str
    topic_pattern: str
    topic_tenant: str
    topic_type: TopicType
    use_tls: bool
    destination: str = 'airbyte-destination-pulsar'
    producer_name: Optional[str] = None
    producer_sync: Optional[bool] = False
    topic_test: Optional[str] = None


class Mode42(Enum):
    openai = 'openai'


@dataclass
class OpenAI4:
    openai_key: str
    mode: Mode42 = Mode42.openai


class Mode43(Enum):
    cohere = 'cohere'


@dataclass
class Cohere3:
    cohere_key: str
    mode: Mode43 = Mode43.cohere


class Mode44(Enum):
    fake = 'fake'


@dataclass
class Fake4:
    mode: Mode44 = Mode44.fake


class Mode45(Enum):
    azure_openai = 'azure_openai'


@dataclass
class AzureOpenAI3:
    api_base: str
    deployment: str
    openai_key: str
    mode: Mode45 = Mode45.azure_openai


class Mode46(Enum):
    openai_compatible = 'openai_compatible'


@dataclass
class OpenAICompatible3:
    base_url: str
    dimensions: int
    api_key: Optional[str] = ''
    mode: Mode46 = Mode46.openai_compatible
    model_name: Optional[str] = 'text-embedding-ada-002'


class Mode47(Enum):
    api_key_auth = 'api_key_auth'


@dataclass
class ApiKeyAuth:
    api_key: str
    mode: Mode47 = Mode47.api_key_auth


class Mode48(Enum):
    no_auth = 'no_auth'


@dataclass
class NoAuth1:
    mode: Mode48 = Mode48.no_auth


class DistanceMetric(Enum):
    dot = 'dot'
    cos = 'cos'
    euc = 'euc'


@dataclass
class Indexing3:
    collection: str
    url: str
    auth_method: Optional[Union[ApiKeyAuth, NoAuth1]] = 'api_key_auth'
    distance_metric: Optional[DistanceMetric] = DistanceMetric.cos
    prefer_grpc: Optional[bool] = True
    text_field: Optional[str] = 'text'


class Mode49(Enum):
    separator = 'separator'


@dataclass
class BySeparator3:
    keep_separator: Optional[bool] = False
    mode: Mode49 = Mode49.separator
    separators: Optional[List[str]] = field(
        default_factory=lambda: ['"\\n\\n"', '"\\n"', '" "', '""']
    )


class Mode50(Enum):
    markdown = 'markdown'


@dataclass
class ByMarkdownHeader3:
    mode: Mode50 = Mode50.markdown
    split_level: Optional[int] = 1


class Mode51(Enum):
    code = 'code'


@dataclass
class ByProgrammingLanguage3:
    language: Language
    mode: Mode51 = Mode51.code


@dataclass
class ProcessingConfigModel4:
    chunk_size: int
    chunk_overlap: Optional[int] = 0
    field_name_mappings: Optional[List[FieldNameMappingConfigModel]] = field(
        default_factory=lambda: []
    )
    metadata_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_splitter: Optional[
        Union[BySeparator3, ByMarkdownHeader3, ByProgrammingLanguage3]
    ] = None


@dataclass
class Qdrant:
    embedding: Union[OpenAI4, Cohere3, Fake4, AzureOpenAI3, OpenAICompatible3]
    indexing: Indexing3
    processing: ProcessingConfigModel4
    destination: str = 'airbyte-destination-qdrant'
    omit_raw_text: Optional[bool] = False


class Codec6(Enum):
    no_compression = 'no compression'


@dataclass
class NoCompression3:
    codec: Codec6


class Codec7(Enum):
    Deflate = 'Deflate'


@dataclass
class Deflate1:
    codec: Codec7
    compression_level: int


class Codec8(Enum):
    bzip2 = 'bzip2'


@dataclass
class Bzip21:
    codec: Codec8


class Codec9(Enum):
    xz = 'xz'


@dataclass
class Xz1:
    codec: Codec9
    compression_level: int


class Codec10(Enum):
    zstandard = 'zstandard'


@dataclass
class Zstandard1:
    codec: Codec10
    compression_level: int
    include_checksum: Optional[bool] = False


class Codec11(Enum):
    snappy = 'snappy'


@dataclass
class Snappy1:
    codec: Codec11


class FormatType6(Enum):
    Avro = 'Avro'


@dataclass
class AvroApacheAvro1:
    compression_codec: Union[NoCompression3, Deflate1, Bzip21, Xz1, Zstandard1, Snappy1]
    format_type: FormatType6


class CompressionType6(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression4:
    compression_type: Optional[CompressionType6] = CompressionType6.No_Compression


class CompressionType7(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP2:
    compression_type: Optional[CompressionType7] = CompressionType7.GZIP


class FormatType7(Enum):
    CSV = 'CSV'


@dataclass
class CSVCommaSeparatedValues2:
    flattening: NormalizationFlattening
    format_type: FormatType7
    compression: Optional[Union[NoCompression4, GZIP2]] = None


class CompressionType8(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression5:
    compression_type: Optional[CompressionType8] = CompressionType8.No_Compression


class CompressionType9(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP3:
    compression_type: Optional[CompressionType9] = CompressionType9.GZIP


class FormatType8(Enum):
    JSONL = 'JSONL'


@dataclass
class JSONLinesNewlineDelimitedJSON3:
    format_type: FormatType8
    compression: Optional[Union[NoCompression5, GZIP3]] = None


@dataclass
class R2:
    access_key_id: str
    account_id: str
    format: Union[
        AvroApacheAvro1, CSVCommaSeparatedValues2, JSONLinesNewlineDelimitedJSON3
    ]
    s3_bucket_name: str
    s3_bucket_path: str
    secret_access_key: str
    destination: str = 'airbyte-destination-r2'
    file_name_pattern: Optional[str] = None
    s3_path_format: Optional[str] = None


@dataclass
class Rabbitmq:
    host: str
    routing_key: str
    destination: str = 'airbyte-destination-rabbitmq'
    exchange: Optional[str] = None
    password: Optional[str] = None
    port: Optional[int] = None
    ssl: Optional[bool] = True
    username: Optional[str] = None
    virtual_host: Optional[str] = None


class CacheType(Enum):
    hash = 'hash'


class Mode52(Enum):
    disable = 'disable'


@dataclass
class Disable1:
    mode: Mode52 = Mode52.disable


class Mode53(Enum):
    verify_full = 'verify-full'


@dataclass
class VerifyFull1:
    ca_certificate: str
    client_certificate: str
    client_key: str
    client_key_password: Optional[str] = None
    mode: Mode53 = Mode53.verify_full


@dataclass
class Redis:
    cache_type: CacheType
    host: str
    port: int
    username: str
    destination: str = 'airbyte-destination-redis'
    password: Optional[str] = None
    ssl: Optional[bool] = False
    ssl_mode: Optional[Union[Disable1, VerifyFull1]] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


class CompressionType10(Enum):
    none = 'none'
    gzip = 'gzip'
    snappy = 'snappy'
    lz4 = 'lz4'
    zstd = 'zstd'


@dataclass
class Redpanda:
    batch_size: int
    bootstrap_servers: str
    buffer_memory: str
    compression_type: CompressionType10
    retries: int
    destination: str = 'airbyte-destination-redpanda'
    socket_connection_setup_timeout_max_ms: Optional[int] = None
    socket_connection_setup_timeout_ms: Optional[int] = None
    topic_num_partitions: Optional[int] = None
    topic_replication_factor: Optional[int] = None


class EncryptionType(Enum):
    none = 'none'


@dataclass
class NoEncryption:
    encryption_type: EncryptionType = EncryptionType.none


class EncryptionType1(Enum):
    aes_cbc_envelope = 'aes_cbc_envelope'


@dataclass
class AESCBCEnvelopeEncryption:
    encryption_type: EncryptionType1 = EncryptionType1.aes_cbc_envelope
    key_encrypting_key: Optional[str] = None


class S3BucketRegion3(Enum):
    field_ = ''
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'
    af_south_1 = 'af-south-1'
    ap_east_1 = 'ap-east-1'
    ap_south_1 = 'ap-south-1'
    ap_northeast_1 = 'ap-northeast-1'
    ap_northeast_2 = 'ap-northeast-2'
    ap_northeast_3 = 'ap-northeast-3'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    cn_north_1 = 'cn-north-1'
    cn_northwest_1 = 'cn-northwest-1'
    eu_central_1 = 'eu-central-1'
    eu_north_1 = 'eu-north-1'
    eu_south_1 = 'eu-south-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    sa_east_1 = 'sa-east-1'
    me_south_1 = 'me-south-1'


@dataclass
class AWSS3Staging:
    access_key_id: str
    s3_bucket_name: str
    s3_bucket_region: S3BucketRegion3
    secret_access_key: str
    encryption: Optional[Union[NoEncryption, AESCBCEnvelopeEncryption]] = field(
        default_factory=lambda: {'encryption_type': 'none'}
    )
    file_buffer_count: Optional[int] = 10
    file_name_pattern: Optional[str] = None
    method: str = 'S3 Staging'
    purge_staging_data: Optional[bool] = True
    s3_bucket_path: Optional[str] = None


@dataclass
class Standard:
    method: str = 'Standard'


@dataclass
class Redshift:
    database: str
    host: str
    password: str
    port: int
    schema_: str
    username: str
    destination: str = 'airbyte-destination-redshift'
    jdbc_url_params: Optional[str] = None
    raw_data_schema: Optional[str] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None
    uploading_method: Optional[Union[AWSS3Staging, Standard]] = None
    use_1s1t_format: Optional[bool] = None


@dataclass
class Rockset:
    api_key: str
    workspace: str
    api_server: Optional[str] = 'https://api.rs2.usw2.rockset.com'
    destination: str = 'airbyte-destination-rockset'


class CompressionType11(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression6:
    compression_type: Optional[CompressionType11] = CompressionType11.No_Compression


class CompressionType12(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP4:
    compression_type: Optional[CompressionType12] = CompressionType12.GZIP


class Flattening(Enum):
    No_flattening = 'No flattening'
    Root_level_flattening = 'Root level flattening'


@dataclass
class JSONLinesNewlineDelimitedJSON4:
    format_type: FormatType8
    compression: Optional[Union[NoCompression6, GZIP4]] = None
    flattening: Optional[Flattening] = Flattening.Root_level_flattening


class SerializationLibrary(Enum):
    org_openx_data_jsonserde_JsonSerDe = 'org.openx.data.jsonserde.JsonSerDe'
    org_apache_hive_hcatalog_data_JsonSerDe = 'org.apache.hive.hcatalog.data.JsonSerDe'


class S3BucketRegion4(Enum):
    field_ = ''
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'
    af_south_1 = 'af-south-1'
    ap_east_1 = 'ap-east-1'
    ap_south_1 = 'ap-south-1'
    ap_northeast_1 = 'ap-northeast-1'
    ap_northeast_2 = 'ap-northeast-2'
    ap_northeast_3 = 'ap-northeast-3'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    cn_north_1 = 'cn-north-1'
    cn_northwest_1 = 'cn-northwest-1'
    eu_central_1 = 'eu-central-1'
    eu_north_1 = 'eu-north-1'
    eu_south_1 = 'eu-south-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    sa_east_1 = 'sa-east-1'
    me_south_1 = 'me-south-1'
    us_gov_east_1 = 'us-gov-east-1'
    us_gov_west_1 = 'us-gov-west-1'


@dataclass
class S3glue:
    format: JSONLinesNewlineDelimitedJSON4
    glue_database: str
    glue_serialization_library: SerializationLibrary
    s3_bucket_name: str
    s3_bucket_path: str
    s3_bucket_region: S3BucketRegion4
    access_key_id: Optional[str] = None
    destination: str = 'airbyte-destination-s3-glue'
    file_name_pattern: Optional[str] = None
    s3_endpoint: Optional[str] = ''
    s3_path_format: Optional[str] = None
    secret_access_key: Optional[str] = None


class Codec12(Enum):
    no_compression = 'no compression'


@dataclass
class NoCompression7:
    codec: Codec12


class Codec13(Enum):
    Deflate = 'Deflate'


@dataclass
class Deflate2:
    codec: Codec13
    compression_level: int


class Codec14(Enum):
    bzip2 = 'bzip2'


@dataclass
class Bzip22:
    codec: Codec14


class Codec15(Enum):
    xz = 'xz'


@dataclass
class Xz2:
    codec: Codec15
    compression_level: int


class Codec16(Enum):
    zstandard = 'zstandard'


@dataclass
class Zstandard2:
    codec: Codec16
    compression_level: int
    include_checksum: Optional[bool] = False


class Codec17(Enum):
    snappy = 'snappy'


@dataclass
class Snappy2:
    codec: Codec17


class FormatType10(Enum):
    Avro = 'Avro'


@dataclass
class AvroApacheAvro2:
    compression_codec: Union[NoCompression7, Deflate2, Bzip22, Xz2, Zstandard2, Snappy2]
    format_type: FormatType10


class CompressionType13(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression8:
    compression_type: Optional[CompressionType13] = CompressionType13.No_Compression


class CompressionType14(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP5:
    compression_type: Optional[CompressionType14] = CompressionType14.GZIP


class FormatType11(Enum):
    CSV = 'CSV'


@dataclass
class CSVCommaSeparatedValues3:
    flattening: Flattening
    format_type: FormatType11
    compression: Optional[Union[NoCompression8, GZIP5]] = None


class CompressionType15(Enum):
    No_Compression = 'No Compression'


@dataclass
class NoCompression9:
    compression_type: Optional[CompressionType15] = CompressionType15.No_Compression


class CompressionType16(Enum):
    GZIP = 'GZIP'


@dataclass
class GZIP6:
    compression_type: Optional[CompressionType16] = CompressionType16.GZIP


class FormatType12(Enum):
    JSONL = 'JSONL'


@dataclass
class JSONLinesNewlineDelimitedJSON5:
    format_type: FormatType12
    compression: Optional[Union[NoCompression9, GZIP6]] = None
    flattening: Optional[Flattening] = Flattening.No_flattening


class FormatType13(Enum):
    Parquet = 'Parquet'


@dataclass
class ParquetColumnarStorage2:
    format_type: FormatType13
    block_size_mb: Optional[int] = 128
    compression_codec: Optional[CompressionCodec] = CompressionCodec.UNCOMPRESSED
    dictionary_encoding: Optional[bool] = True
    dictionary_page_size_kb: Optional[int] = 1024
    max_padding_size_mb: Optional[int] = 8
    page_size_kb: Optional[int] = 1024


@dataclass
class S31:
    format: Union[
        AvroApacheAvro2,
        CSVCommaSeparatedValues3,
        JSONLinesNewlineDelimitedJSON5,
        ParquetColumnarStorage2,
    ]
    s3_bucket_name: str
    s3_bucket_path: str
    s3_bucket_region: S3BucketRegion4
    access_key_id: Optional[str] = None
    destination: str = 'airbyte-destination-s3'
    file_name_pattern: Optional[str] = None
    s3_endpoint: Optional[str] = ''
    s3_path_format: Optional[str] = None
    secret_access_key: Optional[str] = None


@dataclass
class Scylla:
    address: str
    keyspace: str
    password: str
    port: int
    username: str
    destination: str = 'airbyte-destination-scylla'
    replication: Optional[int] = 1


@dataclass
class Selectdb:
    cluster_name: str
    database: str
    jdbc_url: str
    load_url: str
    password: str
    user_name: str
    destination: str = 'airbyte-destination-selectdb'


@dataclass
class Sftpjson:
    destination_path: str
    host: str
    password: str
    username: str
    destination: str = 'airbyte-destination-sftp-json'
    port: Optional[int] = 22


class AuthType(Enum):
    Key_Pair_Authentication = 'Key Pair Authentication'


@dataclass
class KeyPairAuthentication:
    private_key: str
    auth_type: AuthType = AuthType.Key_Pair_Authentication
    private_key_password: Optional[str] = None


class AuthType1(Enum):
    Username_and_Password = 'Username and Password'


@dataclass
class UsernameAndPassword:
    password: str
    auth_type: AuthType1 = AuthType1.Username_and_Password


@dataclass
class Snowflake:
    database: str
    host: str
    role: str
    schema_: str
    username: str
    warehouse: str
    credentials: Optional[
        Union[OAuth2.Field0, KeyPairAuthentication, UsernameAndPassword]
    ] = None
    destination: str = 'airbyte-destination-snowflake'
    disable_type_dedupe: Optional[bool] = False
    jdbc_url_params: Optional[str] = None
    raw_data_schema: Optional[str] = None


@dataclass
class Sqlite:
    destination_path: str
    destination: str = 'airbyte-destination-sqlite'


class ObjectStoreType(Enum):
    S3 = 'S3'


class S3BucketRegion6(Enum):
    ap_northeast_1 = 'ap-northeast-1'
    ap_southeast_1 = 'ap-southeast-1'
    ap_southeast_2 = 'ap-southeast-2'
    ca_central_1 = 'ca-central-1'
    eu_central_1 = 'eu-central-1'
    eu_west_1 = 'eu-west-1'
    eu_west_2 = 'eu-west-2'
    eu_west_3 = 'eu-west-3'
    us_east_1 = 'us-east-1'
    us_east_2 = 'us-east-2'
    us_west_1 = 'us-west-1'
    us_west_2 = 'us-west-2'


@dataclass
class AmazonS31:
    object_store_type: ObjectStoreType
    s3_access_key_id: str
    s3_bucket_name: str
    s3_bucket_path: str
    s3_bucket_region: S3BucketRegion6
    s3_secret_access_key: str


@dataclass
class Starburstgalaxy:
    accept_terms: bool
    catalog: str
    password: str
    server_hostname: str
    staging_object_store: AmazonS31
    username: str
    catalog_schema: Optional[str] = 'public'
    destination: str = 'airbyte-destination-starburst-galaxy'
    port: Optional[str] = '443'
    purge_staging_table: Optional[bool] = True


class Mode54(Enum):
    disable = 'disable'


@dataclass
class Disable2:
    mode: Mode54 = Mode54.disable


class Mode55(Enum):
    allow = 'allow'


@dataclass
class Allow1:
    mode: Mode55 = Mode55.allow


class Mode56(Enum):
    prefer = 'prefer'


@dataclass
class Prefer1:
    mode: Mode56 = Mode56.prefer


class Mode57(Enum):
    require = 'require'


@dataclass
class Require1:
    mode: Mode57 = Mode57.require


class Mode58(Enum):
    verify_ca = 'verify-ca'


@dataclass
class VerifyCa1:
    ssl_ca_certificate: str
    mode: Mode58 = Mode58.verify_ca


class Mode59(Enum):
    verify_full = 'verify-full'


@dataclass
class VerifyFull2:
    ssl_ca_certificate: str
    mode: Mode59 = Mode59.verify_full


@dataclass
class Teradata:
    host: str
    username: str
    destination: str = 'airbyte-destination-teradata'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    schema_: Optional[str] = 'airbyte_td'
    ssl: Optional[bool] = False
    ssl_mode: Optional[
        Union[Disable2, Allow1, Prefer1, Require1, VerifyCa1, VerifyFull2]
    ] = None


@dataclass
class Tidb:
    database: str
    host: str
    port: int
    username: str
    destination: str = 'airbyte-destination-tidb'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = ''
    ssl: Optional[bool] = False
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


@dataclass
class Timeplus:
    apikey: str
    endpoint: str
    destination: str = 'airbyte-destination-timeplus'


@dataclass
class Typesense:
    api_key: str
    host: str
    batch_size: Optional[int] = None
    destination: str = 'airbyte-destination-typesense'
    port: Optional[str] = None
    protocol: Optional[str] = None


@dataclass
class Vertica:
    database: str
    host: str
    port: int
    schema_: str
    username: str
    destination: str = 'airbyte-destination-vertica'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None
    tunnel_method: Optional[
        Union[NoTunnel, SSHKeyAuthentication, PasswordAuthentication]
    ] = None


class Mode60(Enum):
    no_embedding = 'no_embedding'


@dataclass
class NoExternalEmbedding:
    mode: Mode60 = Mode60.no_embedding


class Mode61(Enum):
    azure_openai = 'azure_openai'


@dataclass
class AzureOpenAI4:
    api_base: str
    deployment: str
    openai_key: str
    mode: Mode61 = Mode61.azure_openai


class Mode62(Enum):
    openai = 'openai'


@dataclass
class OpenAI5:
    openai_key: str
    mode: Mode62 = Mode62.openai


class Mode63(Enum):
    cohere = 'cohere'


@dataclass
class Cohere4:
    cohere_key: str
    mode: Mode63 = Mode63.cohere


class Mode64(Enum):
    from_field = 'from_field'


@dataclass
class FromField1:
    dimensions: int
    field_name: str
    mode: Mode64 = Mode64.from_field


class Mode65(Enum):
    fake = 'fake'


@dataclass
class Fake5:
    mode: Mode65 = Mode65.fake


class Mode66(Enum):
    openai_compatible = 'openai_compatible'


@dataclass
class OpenAICompatible4:
    base_url: str
    dimensions: int
    api_key: Optional[str] = ''
    mode: Mode66 = Mode66.openai_compatible
    model_name: Optional[str] = 'text-embedding-ada-002'


@dataclass
class Header:
    header_key: str
    value: str


class Mode67(Enum):
    token = 'token'


@dataclass
class APIToken1:
    token: str
    mode: Mode67 = Mode67.token


class Mode68(Enum):
    username_password = 'username_password'


@dataclass
class UsernamePassword2:
    password: str
    username: str
    mode: Mode68 = Mode68.username_password


class Mode69(Enum):
    no_auth = 'no_auth'


@dataclass
class NoAuthentication:
    mode: Mode69 = Mode69.no_auth


class DefaultVectorizer(Enum):
    none = 'none'
    text2vec_cohere = 'text2vec-cohere'
    text2vec_huggingface = 'text2vec-huggingface'
    text2vec_openai = 'text2vec-openai'
    text2vec_palm = 'text2vec-palm'
    text2vec_contextionary = 'text2vec-contextionary'
    text2vec_transformers = 'text2vec-transformers'
    text2vec_gpt4all = 'text2vec-gpt4all'


@dataclass
class Indexing4:
    auth: Union[APIToken1, UsernamePassword2, NoAuthentication]
    host: str
    additional_headers: Optional[List[Header]] = field(default_factory=lambda: [])
    batch_size: Optional[int] = 128
    default_vectorizer: Optional[DefaultVectorizer] = DefaultVectorizer.none
    text_field: Optional[str] = 'text'


class Mode70(Enum):
    separator = 'separator'


@dataclass
class BySeparator4:
    keep_separator: Optional[bool] = False
    mode: Mode70 = Mode70.separator
    separators: Optional[List[str]] = field(
        default_factory=lambda: ['"\\n\\n"', '"\\n"', '" "', '""']
    )


class Mode71(Enum):
    markdown = 'markdown'


@dataclass
class ByMarkdownHeader4:
    mode: Mode71 = Mode71.markdown
    split_level: Optional[int] = 1


class Mode72(Enum):
    code = 'code'


@dataclass
class ByProgrammingLanguage4:
    language: Language
    mode: Mode72 = Mode72.code


@dataclass
class ProcessingConfigModel5:
    chunk_size: int
    chunk_overlap: Optional[int] = 0
    field_name_mappings: Optional[List[FieldNameMappingConfigModel]] = field(
        default_factory=lambda: []
    )
    metadata_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_fields: Optional[List[str]] = field(default_factory=lambda: [])
    text_splitter: Optional[
        Union[BySeparator4, ByMarkdownHeader4, ByProgrammingLanguage4]
    ] = None


@dataclass
class Weaviate:
    embedding: Union[
        NoExternalEmbedding,
        AzureOpenAI4,
        OpenAI5,
        Cohere4,
        FromField1,
        Fake5,
        OpenAICompatible4,
    ]
    indexing: Indexing4
    processing: ProcessingConfigModel5
    destination: str = 'airbyte-destination-weaviate'
    omit_raw_text: Optional[bool] = False


@dataclass
class Xata:
    api_key: str
    db_url: str
    destination: str = 'airbyte-destination-xata'


@dataclass
class Yugabytedb:
    database: str
    host: str
    port: int
    schema_: str
    username: str
    destination: str = 'airbyte-destination-yugabytedb'
    jdbc_url_params: Optional[str] = None
    password: Optional[str] = None


@dataclass
class Airbytedevmatecloud:
    privateKey: str
    streamId: str
    destination: str = 'airbyte-devmate-cloud'


Destination = Union[
    Amazonsqs,
    Awsdatalake,
    Azureblobstorage,
    Bigquery,
    Cassandra,
    Chroma,
    Clickhouse,
    Convex,
    Csv,
    Cumulio,
    Databend,
    Databricks,
    Doris,
    Duckdb,
    Dynamodb,
    E2etest,
    Elasticsearch,
    Exasol,
    Firebolt,
    Firestore,
    Gcs,
    Googlesheets,
    Iceberg,
    Kafka,
    Keen,
    Kinesis,
    Langchain,
    Localjson,
    Mariadbcolumnstore,
    Meilisearch,
    Milvus,
    Mongodb,
    Mqtt,
    Mssql,
    Mysql,
    Oracle,
    Pinecone1,
    Postgres,
    Pubsub,
    Pulsar,
    Qdrant,
    R2,
    Rabbitmq,
    Redis,
    Redpanda,
    Redshift,
    Rockset,
    S3glue,
    S31,
    Scylla,
    Selectdb,
    Sftpjson,
    Snowflake,
    Sqlite,
    Starburstgalaxy,
    Teradata,
    Tidb,
    Timeplus,
    Typesense,
    Vertica,
    Weaviate,
    Xata,
    Yugabytedb,
    Airbytedevmatecloud,
]
