# generated by datamodel-codegen:
#   filename:  restapi_definitions.json

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Union


@dataclass
class NoAuth:
    auth_type: str = 'NO_AUTH'


@dataclass
class BasicAuth:
    password: str
    username: str
    auth_type: str = 'BASIC_AUTH'


class WhereToAddAPIKeyTo(Enum):
    header = 'header'
    query = 'query'


@dataclass
class APIKey:
    auth_location: WhereToAddAPIKeyTo
    key: str
    value: str
    auth_type: str = 'API_KEY'


@dataclass
class BearerToken:
    token: str
    auth_type: str = 'BEARER_TOKEN'


@dataclass
class RESTAPIConnectorSpec:
    authentication: Union[NoAuth, BasicAuth, APIKey, BearerToken]
