# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-08 21:22
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='QChildTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True)),
                ('timestamp', models.DecimalField(blank=True, db_index=True, decimal_places=6, max_digits=30, null=True)),
                ('parent', models.UUIDField(db_index=True)),
                ('child', models.UUIDField(db_index=True)),
            ],
            options={
                'ordering': ['created', 'timestamp'],
            },
        ),
        migrations.CreateModel(
            name='QEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(db_index=True)),
                ('timestamp', models.DecimalField(blank=True, db_index=True, decimal_places=6, max_digits=30, null=True)),
                ('event', models.CharField(db_index=True, max_length=64)),
                ('task_id', models.UUIDField(db_index=True)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_index=True, null=True)),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.CreateModel(
            name='QTaskState',
            fields=[
                ('task_id', models.UUIDField(db_index=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(db_index=True)),
                ('timestamp', models.DecimalField(blank=True, db_index=True, decimal_places=6, max_digits=30, null=True)),
                ('retries', models.IntegerField(blank=True, db_index=True, null=True)),
                ('status', model_utils.fields.StatusField(choices=[(b'before_task_publish', b'before_task_publish'), (b'after_task_publish', b'after_task_publish'), (b'task_prerun', b'task_prerun'), (b'task_retry', b'task_retry'), (b'task_postrun', b'task_postrun'), (b'task_success', b'task_success'), (b'task_failure', b'task_failure'), (b'task_revoked', b'task_revoked')], db_index=True, default=b'before_task_publish', max_length=100, no_check_for_status=True)),
            ],
            options={
                'ordering': ['created'],
            },
        ),
        migrations.AlterIndexTogether(
            name='qtaskstate',
            index_together=set([('created', 'timestamp', 'status')]),
        ),
        migrations.AlterIndexTogether(
            name='qevent',
            index_together=set([('event', 'task_id', 'timestamp')]),
        ),
        migrations.AlterIndexTogether(
            name='qchildtask',
            index_together=set([('parent', 'child')]),
        ),
    ]
