---
name: Bug report
about: Create a report to help us improve
title: ''
labels: bug
assignees: ''

---

**Expected behavior**
A clear and concise description of what you expected to happen.

**Actual behavior (describe the problem)**
Why the current behavior is a problem and why the expected behavior is a better solution.

**Related Issues**
Please list the ticket numbers (e.g. #708) for any issues already logged in the system.

**Workaround**
Any ways you have found to work around the problem and accomplish your task.

**Minimum, Complete, Viable Code Sample**
A "Minimal, Complete and Verifiable Example" will make it much easier for maintainers to help you.
See http://matthewrocklin.com/blog/work/2018/02/28/minimal-bug-reports

```python
# Your python code here
```
or
```console
> command-line-call
```

**Environment Information**
* Operation System Information (`python -c "import platform; print(platform.platform())"`)
* Python version (`python -c "import sys; print(sys.version.replace('\n', ' '))"`)
* Planet package version (`planet -v`)

**Installation Method**
* conda, pip wheel, from source, etc...
