/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.MethodReferenceExp;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kotlinizable.Kotlinizer;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.MethodIdWithCallContext;

public class InvokeExp
extends Exp {
    private static final int MINIMAL_NUM_OF_INVOKE_ARGS = 1;
    private static final String msg = "Every invocation must have an environment argument";
    private static final int NUM_OF_INVOKE_ARGS_FOR_UNKNOWN = 2;
    private static final String msg2 = "Every invocation with unknown function must have 2 arguments: environment, and calldata argument;";
    private final MethodReferenceExp methodRef;
    private final List<Exp> expList;
    private final boolean noRevert;
    private final Exp storage;

    public InvokeExp(MethodReferenceExp _m, List<Exp> _expList, boolean _noRevert, Exp _storage) {
        this.methodRef = _m;
        this.expList = _expList;
        this.noRevert = _noRevert;
        this.storage = _storage;
    }

    public String toString() {
        Stream<String> expListToString = this.expList.stream().map(Objects::toString);
        if (this.noRevert) {
            return String.format("SInvoke(%s,%s,%s)", this.methodRef.toString(), expListToString.reduce("", (S, s) -> S + ", " + s), this.storage);
        }
        return String.format("Invoke(%s,%s,%s)", this.methodRef.toString(), expListToString.reduce("", (S, s) -> S + ", " + s), this.storage);
    }

    @Override
    public CVLExp kotlinize() {
        return new CVLExp.ApplyExp.ContractFunction.Concrete(MethodIdWithCallContext.Companion.fromMethodReference(this.methodRef.kotlinize()), Kotlinizer.kotlinizeList(this.expList), this.noRevert, (CVLExp)this.storage.kotlinize(), false, CVLExpTag.Companion.getEmptyTag());
    }
}

