/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.Config;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLType;
import spec.cvlast.MonadicCVLAstTransformer;
import spec.cvlast.MonadicCVLCmdTransformer;
import spec.cvlast.StorageComparisonCheckerKt;
import spec.cvlast.monadiccvlexptransformer.MonadicSelfCVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u00020\b*\u00020\t\u00a8\u0006\n"}, d2={"Lspec/cvlast/StorageComparisonChecker;", "Lspec/cvlast/MonadicCVLAstTransformer;", "Lspec/cvlast/typechecker/CVLError;", "()V", "ast", "Lutils/CollectingResult;", "Lspec/cvlast/CVLAst;", "isStorageOperand", "", "Lspec/cvlast/CVLExp;", "Shared"})
public final class StorageComparisonChecker
extends MonadicCVLAstTransformer<CVLError> {
    @NotNull
    public static final StorageComparisonChecker INSTANCE = new StorageComparisonChecker();

    private StorageComparisonChecker() {
        MonadicSelfCVLExpTransformer<CVLError> monadicSelfCVLExpTransformer = new MonadicSelfCVLExpTransformer<CVLError>(){

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> relop(@NotNull CVLExp.RelopExp exp) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                return StorageComparisonCheckerKt.access$isStorageOperand(exp.getR()) || StorageComparisonCheckerKt.access$isStorageOperand(exp.getL()) ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "Without grounding enabled, cannot use direct storage comparisons except in an assertion command.")) : super.relop(exp);
            }
        };
        super(new MonadicCVLCmdTransformer<CVLError>(monadicSelfCVLExpTransformer){

            @Override
            @NotNull
            public CollectingResult<CVLCmd, CVLError> assertCmd(@NotNull CVLCmd.Simple.Assert cmd2) {
                Intrinsics.checkNotNullParameter(cmd2, "cmd");
                if (cmd2.getExp() instanceof CVLExp.RelopExp && StorageComparisonCheckerKt.access$isStorageOperand(((CVLExp.RelopExp)cmd2.getExp()).getR())) {
                    return ((CVLExp.RelopExp)cmd2.getExp()).getRelop() == CVLExp.RelopExp.CVLERelop.EQ ? (CollectingResult)CollectingResult.Companion.lift(cmd2) : (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(cmd2.getExp(), "Without grounding enabled, only assertions of storage equality are allowed."));
                }
                return super.assertCmd(cmd2);
            }
        });
    }

    public final boolean isStorageOperand(@NotNull CVLExp $this$isStorageOperand) {
        Intrinsics.checkNotNullParameter($this$isStorageOperand, "<this>");
        return $this$isStorageOperand.getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.BlockchainState || $this$isStorageOperand.getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.StorageReference;
    }

    @Override
    @NotNull
    public CollectingResult<CVLAst, CVLError> ast(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        if (((Boolean)Config.INSTANCE.getGroundQuantifiers().get()).booleanValue()) {
            return CollectingResult.Companion.lift(ast2);
        }
        return super.ast(ast2);
    }
}

