/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.utils.ByteUtils;

public class BlockLZ4CompressorOutputStream
extends CompressorOutputStream {
    private static final int MIN_BACK_REFERENCE_LENGTH = 4;
    private static final int MIN_OFFSET_OF_LAST_BACK_REFERENCE = 12;
    private final LZ77Compressor compressor;
    private final OutputStream os;
    private final byte[] oneByte = new byte[1];
    private boolean finished;
    private final Deque<Pair> pairs = new LinkedList<Pair>();
    private final Deque<byte[]> expandedBlocks = new LinkedList<byte[]>();

    public BlockLZ4CompressorOutputStream(OutputStream os) throws IOException {
        this(os, BlockLZ4CompressorOutputStream.createParameterBuilder().build());
    }

    public BlockLZ4CompressorOutputStream(OutputStream os, Parameters params2) throws IOException {
        this.os = os;
        this.compressor = new LZ77Compressor(params2, block2 -> {
            switch (block2.getType()) {
                case LITERAL: {
                    this.addLiteralBlock((LZ77Compressor.LiteralBlock)block2);
                    break;
                }
                case BACK_REFERENCE: {
                    this.addBackReference((LZ77Compressor.BackReference)block2);
                    break;
                }
                case EOD: {
                    this.writeFinalLiteralBlock();
                }
            }
        });
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)(b & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        this.compressor.compress(data, off, len);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.os.close();
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.compressor.finish();
            this.finished = true;
        }
    }

    public void prefill(byte[] data, int off, int len) {
        if (len > 0) {
            byte[] b = Arrays.copyOfRange(data, off, off + len);
            this.compressor.prefill(b);
            this.recordLiteral(b);
        }
    }

    private void addLiteralBlock(LZ77Compressor.LiteralBlock block2) throws IOException {
        Pair last2 = this.writeBlocksAndReturnUnfinishedPair(block2.getLength());
        this.recordLiteral(last2.addLiteral(block2));
        this.clearUnusedBlocksAndPairs();
    }

    private void addBackReference(LZ77Compressor.BackReference block2) throws IOException {
        Pair last2 = this.writeBlocksAndReturnUnfinishedPair(block2.getLength());
        last2.setBackReference(block2);
        this.recordBackReference(block2);
        this.clearUnusedBlocksAndPairs();
    }

    private Pair writeBlocksAndReturnUnfinishedPair(int length2) throws IOException {
        this.writeWritablePairs(length2);
        Pair last2 = this.pairs.peekLast();
        if (last2 == null || last2.hasBackReference()) {
            last2 = new Pair();
            this.pairs.addLast(last2);
        }
        return last2;
    }

    private void recordLiteral(byte[] b) {
        this.expandedBlocks.addFirst(b);
    }

    private void clearUnusedBlocksAndPairs() {
        this.clearUnusedBlocks();
        this.clearUnusedPairs();
    }

    private void clearUnusedBlocks() {
        int blockLengths = 0;
        int blocksToKeep = 0;
        for (byte[] b : this.expandedBlocks) {
            ++blocksToKeep;
            if ((blockLengths += b.length) < 65536) continue;
            break;
        }
        int size = this.expandedBlocks.size();
        for (int i = blocksToKeep; i < size; ++i) {
            this.expandedBlocks.removeLast();
        }
    }

    private void recordBackReference(LZ77Compressor.BackReference block2) {
        this.expandedBlocks.addFirst(this.expand(block2.getOffset(), block2.getLength()));
    }

    private byte[] expand(int offset, int length2) {
        byte[] expanded = new byte[length2];
        if (offset == 1) {
            byte[] block2 = this.expandedBlocks.peekFirst();
            byte b = block2[block2.length - 1];
            if (b != 0) {
                Arrays.fill(expanded, b);
            }
        } else {
            this.expandFromList(expanded, offset, length2);
        }
        return expanded;
    }

    private void expandFromList(byte[] expanded, int offset, int length2) {
        int offsetRemaining = offset;
        int lengthRemaining = length2;
        int writeOffset = 0;
        while (lengthRemaining > 0) {
            int copyLen;
            int copyOffset;
            byte[] block2 = null;
            if (offsetRemaining > 0) {
                int blockOffset = 0;
                for (byte[] b : this.expandedBlocks) {
                    if (b.length + blockOffset >= offsetRemaining) {
                        block2 = b;
                        break;
                    }
                    blockOffset += b.length;
                }
                if (block2 == null) {
                    throw new IllegalStateException("Failed to find a block containing offset " + offset);
                }
                copyOffset = blockOffset + block2.length - offsetRemaining;
                copyLen = Math.min(lengthRemaining, block2.length - copyOffset);
            } else {
                block2 = expanded;
                copyOffset = -offsetRemaining;
                copyLen = Math.min(lengthRemaining, writeOffset + offsetRemaining);
            }
            System.arraycopy(block2, copyOffset, expanded, writeOffset, copyLen);
            offsetRemaining -= copyLen;
            lengthRemaining -= copyLen;
            writeOffset += copyLen;
        }
    }

    private void clearUnusedPairs() {
        Pair p;
        int pairLengths = 0;
        int pairsToKeep = 0;
        Iterator<Pair> it = this.pairs.descendingIterator();
        while (it.hasNext()) {
            Pair p3 = it.next();
            ++pairsToKeep;
            if ((pairLengths += p3.length()) < 65536) continue;
            break;
        }
        int size = this.pairs.size();
        for (int i = pairsToKeep; i < size && (p = this.pairs.peekFirst()).hasBeenWritten(); ++i) {
            this.pairs.removeFirst();
        }
    }

    private void writeFinalLiteralBlock() throws IOException {
        this.rewriteLastPairs();
        for (Pair p : this.pairs) {
            if (p.hasBeenWritten()) continue;
            p.writeTo(this.os);
        }
        this.pairs.clear();
    }

    private void writeWritablePairs(int lengthOfBlocksAfterLastPair) throws IOException {
        Pair p3;
        int unwrittenLength = lengthOfBlocksAfterLastPair;
        Iterator<Pair> it = this.pairs.descendingIterator();
        while (it.hasNext() && !(p3 = it.next()).hasBeenWritten()) {
            unwrittenLength += p3.length();
        }
        for (Pair p3 : this.pairs) {
            if (p3.hasBeenWritten()) continue;
            if (!p3.canBeWritten(unwrittenLength -= p3.length())) break;
            p3.writeTo(this.os);
        }
    }

    private void rewriteLastPairs() {
        int brLen;
        Pair p3;
        LinkedList<Pair> lastPairs = new LinkedList<Pair>();
        LinkedList<Integer> pairLength = new LinkedList<Integer>();
        int offset = 0;
        Iterator<Pair> it = this.pairs.descendingIterator();
        while (it.hasNext() && !(p3 = it.next()).hasBeenWritten()) {
            int len = p3.length();
            pairLength.addFirst(len);
            lastPairs.addFirst(p3);
            if ((offset += len) < 12) continue;
            break;
        }
        for (Pair p3 : lastPairs) {
            this.pairs.remove(p3);
        }
        int lastPairsSize = lastPairs.size();
        int toExpand = 0;
        for (int i = 1; i < lastPairsSize; ++i) {
            toExpand += ((Integer)pairLength.get(i)).intValue();
        }
        Pair replacement = new Pair();
        if (toExpand > 0) {
            replacement.prependLiteral(this.expand(toExpand, toExpand));
        }
        Pair splitCandidate = (Pair)lastPairs.get(0);
        int stillNeeded = 12 - toExpand;
        int n = brLen = splitCandidate.hasBackReference() ? splitCandidate.backReferenceLength() : 0;
        if (splitCandidate.hasBackReference() && brLen >= 4 + stillNeeded) {
            replacement.prependLiteral(this.expand(toExpand + stillNeeded, stillNeeded));
            this.pairs.add(splitCandidate.splitWithNewBackReferenceLengthOf(brLen - stillNeeded));
        } else {
            if (splitCandidate.hasBackReference()) {
                replacement.prependLiteral(this.expand(toExpand + brLen, brLen));
            }
            splitCandidate.prependTo(replacement);
        }
        this.pairs.add(replacement);
    }

    public static Parameters.Builder createParameterBuilder() {
        int maxLen = 65535;
        return Parameters.builder(65536).withMinBackReferenceLength(4).withMaxBackReferenceLength(65535).withMaxOffset(65535).withMaxLiteralLength(65535);
    }

    static final class Pair {
        private final Deque<byte[]> literals = new LinkedList<byte[]>();
        private int brOffset;
        private int brLength;
        private boolean written;

        Pair() {
        }

        private void prependLiteral(byte[] data) {
            this.literals.addFirst(data);
        }

        byte[] addLiteral(LZ77Compressor.LiteralBlock block2) {
            byte[] copy = Arrays.copyOfRange(block2.getData(), block2.getOffset(), block2.getOffset() + block2.getLength());
            this.literals.add(copy);
            return copy;
        }

        void setBackReference(LZ77Compressor.BackReference block2) {
            if (this.hasBackReference()) {
                throw new IllegalStateException();
            }
            this.brOffset = block2.getOffset();
            this.brLength = block2.getLength();
        }

        boolean hasBackReference() {
            return this.brOffset > 0;
        }

        boolean canBeWritten(int lengthOfBlocksAfterThisPair) {
            return this.hasBackReference() && lengthOfBlocksAfterThisPair >= 16;
        }

        int length() {
            return this.literalLength() + this.brLength;
        }

        private boolean hasBeenWritten() {
            return this.written;
        }

        void writeTo(OutputStream out2) throws IOException {
            int litLength = this.literalLength();
            out2.write(Pair.lengths(litLength, this.brLength));
            if (litLength >= 15) {
                Pair.writeLength(litLength - 15, out2);
            }
            for (byte[] b : this.literals) {
                out2.write(b);
            }
            if (this.hasBackReference()) {
                ByteUtils.toLittleEndian(out2, (long)this.brOffset, 2);
                if (this.brLength - 4 >= 15) {
                    Pair.writeLength(this.brLength - 4 - 15, out2);
                }
            }
            this.written = true;
        }

        private int literalLength() {
            int length2 = 0;
            for (byte[] b : this.literals) {
                length2 += b.length;
            }
            return length2;
        }

        private static int lengths(int litLength, int brLength) {
            int l;
            int n = l = litLength < 15 ? litLength : 15;
            int br = brLength < 4 ? 0 : (brLength < 19 ? brLength - 4 : 15);
            return l << 4 | br;
        }

        private static void writeLength(int length2, OutputStream out2) throws IOException {
            while (length2 >= 255) {
                out2.write(255);
                length2 -= 255;
            }
            out2.write(length2);
        }

        private int backReferenceLength() {
            return this.brLength;
        }

        private void prependTo(Pair other) {
            Iterator<byte[]> listBackwards = this.literals.descendingIterator();
            while (listBackwards.hasNext()) {
                other.prependLiteral(listBackwards.next());
            }
        }

        private Pair splitWithNewBackReferenceLengthOf(int newBackReferenceLength) {
            Pair p = new Pair();
            p.literals.addAll(this.literals);
            p.brOffset = this.brOffset;
            p.brLength = newBackReferenceLength;
            return p;
        }
    }
}

