/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import bridge.SingleDeployedContract;
import bridge.SourceLanguage;
import bridge.SourceTypeDescription;
import bridge.StorageLayout;
import bridge.VerificationQuery;
import bridge.types.SolidityTypeDescription;
import cli.ConverterKt;
import config.Config;
import disassembler.DisassembledEVMBytecode;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import log.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import preprocessing.ProverInputPreprocessor;
import scene.ContractClassIdentifiers;
import scene.ContractUniverse;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractLoader;
import scene.IContractSource;
import scene.IContractWithSource;
import scene.IPerContractClassCache;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.TrivialSceneFactory;
import spec.CVL;
import spec.CVLAstBuilder;
import spec.CVLInput;
import spec.DummyTypeResolver;
import spec.cvlast.CVLAst;
import spec.cvlast.SolidityContract;
import spec.cvlast.typechecker.CVLError;
import tac.DummyStorageInfo;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;
import utils.CVLSerializerModules;
import utils.CollectingResult;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u001b\u0010\u0013\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u000fJ$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lpreprocessing/ProverInputPreprocessor;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "_main", "", "args", "", "", "astCb", "Lkotlin/Function1;", "Lspec/cvlast/CVLAst;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getCertoraVerifyFile", "Lbridge/VerificationQuery;", "filepath", "outForLSPServer", "ast", "parseInputFileNames", "Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "([Ljava/lang/String;)Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "setConfigFromMetadata", "metadataElem", "Lkotlinx/serialization/json/JsonObject;", "withSpec", "Lutils/CollectingResult;", "Lspec/cvlast/typechecker/CVLError;", "verify", "withSpecAndContractBuildInformation", "Lspec/CVL;", "buildFile", "verifyFile", "BasicContractSource", "InputFileNames", "Shared"})
@SourceDebugExtension(value={"SMAP\nProverInputPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,312:1\n113#2:313\n1#3:314\n1549#4:315\n1620#4,3:316\n766#4:323\n857#4,2:324\n1179#4,2:326\n1253#4,4:328\n11335#5:319\n11670#5,3:320\n*S KotlinDebug\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor\n*L\n194#1:313\n280#1:315\n280#1:316,3\n152#1:323\n152#1:324,2\n152#1:326,2\n152#1:328,4\n288#1:319\n288#1:320,3\n*E\n"})
public final class ProverInputPreprocessor {
    @NotNull
    public static final ProverInputPreprocessor INSTANCE = new ProverInputPreprocessor();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, json.1.INSTANCE, 1, null);

    private ProverInputPreprocessor() {
    }

    private final VerificationQuery getCertoraVerifyFile(String filepath) {
        String it = FilesKt.readText$default(new File(filepath), null, 1, null);
        boolean bl = false;
        return (VerificationQuery)json.decodeFromString((DeserializationStrategy)VerificationQuery.Companion.serializer(), it);
    }

    private final void setConfigFromMetadata(JsonObject metadataElem) {
        String string = ProverInputPreprocessor.setConfigFromMetadata$getRulesFromMetadata(metadataElem);
        if (string == null) {
            return;
        }
        String rules = string;
        Config.INSTANCE.getRuleChoice().set((Serializable)ConverterKt.getStringSetConverter().getConvert().invoke(rules));
    }

    private final CollectingResult<CVL, CVLError> withSpecAndContractBuildInformation(String buildFile, String verifyFile) {
        VerificationQuery verify = this.getCertoraVerifyFile(verifyFile);
        BasicContractSource contractSource = new BasicContractSource(buildFile);
        IScene scene = TrivialSceneFactory.INSTANCE.getScene(contractSource);
        System.out.println((Object)("Type checking " + verify.getPrimary_contract()));
        CVLInput cVLInput = verify.toCVLInput();
        List<ContractInstanceInSDC> list = contractSource.instances();
        IContractClass iContractClass = scene.getContract(new SolidityContract(verify.getPrimary_contract()));
        Intrinsics.checkNotNull(iContractClass, "null cannot be cast to non-null type scene.IContractWithSource");
        return new CVLAstBuilder(cVLInput, list, ((IContractWithSource)((Object)iContractClass)).getSrc(), scene, null).build();
    }

    @NotNull
    public final CollectingResult<CVLAst, CVLError> withSpec(@NotNull VerificationQuery verify) {
        Intrinsics.checkNotNullParameter(verify, "verify");
        CollectingResult<CVLAst, CVLError> cvlAst2 = CollectingResult.Companion.map(verify.toCVLInput().getRawCVLAst(new DummyTypeResolver(new SolidityContract(verify.getPrimary_contract()))), withSpec.cvlAst.1.INSTANCE);
        return cvlAst2;
    }

    @ExperimentalSerializationApi
    public final void outForLSPServer(@NotNull CVLAst ast2) {
        Intrinsics.checkNotNullParameter(ast2, "ast");
        StringFormat $this$encodeToString$iv = CVLSerializerModules.INSTANCE.getLspServerFormat();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)CVLAst.Companion.serializer(), ast2);
        System.out.println((Object)string);
    }

    private final InputFileNames parseInputFileNames(String[] args2) {
        String verifyFileName;
        String buildFileName;
        String metadataFileName;
        block6: {
            String internalDirectory;
            String string;
            Options options = new Options();
            String metadataFileOpt = "m";
            String verifyFileOpt = "v";
            String buildFileOpt = "b";
            String internalDirOpt = "d";
            options.addOption(metadataFileOpt, true, "metadata json file");
            options.addOption(verifyFileOpt, true, "verify json file");
            options.addOption(buildFileOpt, true, "build json file");
            options.addOption(internalDirOpt, true, "internal directory");
            CommandLine cmdLineArgs = new DefaultParser().parse(options, args2);
            metadataFileName = cmdLineArgs.getOptionValue(metadataFileOpt);
            String string2 = cmdLineArgs.getOptionValue(buildFileOpt);
            if (string2 == null) {
                string2 = buildFileName = args2.length == 2 ? args2[0] : null;
            }
            if ((string = cmdLineArgs.getOptionValue(verifyFileOpt)) == null) {
                switch (args2.length) {
                    case 2: {
                        string = args2[1];
                        break;
                    }
                    case 1: {
                        string = args2[0];
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
            }
            verifyFileName = string;
            String string3 = internalDirectory = cmdLineArgs.getOptionValue(internalDirOpt);
            if (string3 == null) break block6;
            String it = string3;
            boolean bl = false;
            Config.INSTANCE.getCertoraBuildDirectory().set((Serializable)((Object)it));
        }
        return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void _main(@NotNull String[] args2, @NotNull Function1<? super CVLAst, Unit> astCb) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(astCb, "astCb");
        try {
            try {
                void $this$map$iv;
                Object object;
                Object object2;
                Object stdin;
                CollectingResult collectingResult;
                InputFileNames inputFileNames = this.parseInputFileNames(args2);
                String metadataFileName = inputFileNames.getMetadataFileName();
                String buildFileName = inputFileNames.getBuildFileName();
                String verifyFileName = inputFileNames.getVerifyFileName();
                if (metadataFileName != null) {
                    try {
                        JsonObject metadataElem = JsonElementKt.getJsonObject(Json.Default.parseToJsonElement(FilesKt.readText$default(new File(metadataFileName), null, 1, null)));
                        this.setConfigFromMetadata(metadataElem);
                    }
                    catch (Exception e) {
                        Logger.Companion.alwaysWarn("Error in parsing input file " + metadataFileName);
                        throw e;
                    }
                }
                if (buildFileName != null && verifyFileName != null) {
                    collectingResult = this.withSpecAndContractBuildInformation(buildFileName, verifyFileName);
                } else if (verifyFileName != null) {
                    VerificationQuery verify = this.getCertoraVerifyFile(verifyFileName);
                    collectingResult = verify.getType() != null ? CollectingResult.Companion.map(this.withSpec(verify), (Function1)new Function1<CVLAst, Unit>(astCb){
                        final /* synthetic */ Function1<CVLAst, Unit> $astCb;
                        {
                            this.$astCb = $astCb;
                            super(1);
                        }

                        public final void invoke(@NotNull CVLAst ast2) {
                            Intrinsics.checkNotNullParameter(ast2, "ast");
                            this.$astCb.invoke(ast2);
                        }
                    }) : (CollectingResult)CollectingResult.Companion.getOk();
                } else if (buildFileName == null) {
                    Collection<CollectingResult<CVLAst, CVLError>> collection;
                    void $this$mapTo$iv$iv;
                    String string = ConsoleKt.readLine();
                    Intrinsics.checkNotNull(string);
                    stdin = string;
                    List verify = (List)json.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), (String)stdin);
                    Iterable iterable = verify;
                    object2 = CollectingResult.Companion;
                    object = CollectingResult.Companion;
                    boolean $i$f$map = false;
                    void var12_21 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void v;
                        VerificationQuery verificationQuery2 = (VerificationQuery)item$iv$iv2;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(v.toCVLInput().getRawCVLAst(new DummyTypeResolver(new SolidityContract(v.getPrimary_contract()))));
                    }
                    collection = (List)destination$iv$iv;
                    collectingResult = ((CollectingResult.Companion)object).map(((CollectingResult.Companion)object2).flatten(collection), (Function1)new Function1<List<? extends CVLAst>, Unit>(astCb){
                        final /* synthetic */ Function1<CVLAst, Unit> $astCb;
                        {
                            this.$astCb = $astCb;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull List<CVLAst> asts) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(asts, "asts");
                            Iterable iterable = asts;
                            Function1<CVLAst, Unit> function1 = this.$astCb;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                CVLAst ast2 = (CVLAst)element$iv;
                                boolean bl = false;
                                function1.invoke(ast2);
                            }
                        }
                    });
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv2;
                    stdin = args2;
                    object = System.err;
                    boolean $i$f$map = false;
                    $this$map$iv = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl = false;
                        object2.add(it);
                    }
                    ((PrintStream)object).println("Bad input to CVL typechecker: " + (List)destination$iv$iv);
                    collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
                }
                CollectingResult result2 = collectingResult;
                result2.resultOrExitProcess(1, _main.1.INSTANCE);
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CVLAstBuilder.CVLParsingException.CUPParser cUPParser) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CVLAstBuilder.CVLParsingException.Kotlinization e) {
                System.err.println(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Throwable e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        catch (Throwable throwable) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String setConfigFromMetadata$getRulesFromMetadata(JsonObject metadataElem) {
        try {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            JsonElement settings;
            JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject(metadataElem).get((Object)"args");
            JsonElement jsonElement2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonObject(jsonElement)) != null ? (JsonElement)((JsonObject)jsonElement).get((Object)"settings") : (settings = null);
            if (settings == null || settings instanceof JsonNull) {
                return null;
            }
            if (!(settings instanceof JsonArray)) {
                Logger.Companion.alwaysWarn("Cannot process metadata settings as they are not in array format");
                return null;
            }
            Iterable $this$filter$iv = (Iterable)Json.Default.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.ListSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE)), JsonElementKt.getJsonArray(settings).toString());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, "=", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                String it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                List setting = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
                Pair pair2 = TuplesKt.to(setting.get(0), setting.get(1));
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map ruleMap = destination$iv$iv2;
            String string = (String)ruleMap.get("-rule");
            if (string == null) {
                string = (String)ruleMap.get("-rules");
            }
            return string;
        }
        catch (Exception e) {
            Logger.Companion.alwaysWarn("Could not parse settings from metadata", e);
            return null;
        }
    }

    public static final /* synthetic */ Json access$getJson$p() {
        return json;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0010H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lpreprocessing/ProverInputPreprocessor$BasicContractSource;", "Lscene/IContractSource;", "Lscene/IContractLoader;", "file", "", "(Ljava/lang/String;)V", "buildResources", "", "Lbridge/SingleDeployedContract;", "getBuildResources", "()Ljava/util/Map;", "buildResources$delegate", "Lkotlin/Lazy;", "getFile", "()Ljava/lang/String;", "instances", "", "Lbridge/ContractInstanceInSDC;", "getInstances", "()Ljava/util/List;", "instances$delegate", "aliases", "", "Ljava/math/BigInteger;", "load", "Lscene/IContractClass;", "sdc", "cache", "Lscene/IPerContractClassCache;", "Shared"})
    @SourceDebugExtension(value={"SMAP\nProverInputPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor$BasicContractSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1549#2:313\n1620#2,3:314\n*S KotlinDebug\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor$BasicContractSource\n*L\n125#1:313\n125#1:314,3\n*E\n"})
    public static final class BasicContractSource
    implements IContractSource,
    IContractLoader {
        @NotNull
        private final String file;
        @NotNull
        private final Lazy buildResources$delegate;
        @NotNull
        private final Lazy instances$delegate;

        public BasicContractSource(@NotNull String file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.buildResources$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends SingleDeployedContract>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<String, SingleDeployedContract> invoke() {
                    String it = FilesKt.readText$default(new File(this.this$0.getFile()), null, 1, null);
                    boolean bl = false;
                    return (Map)ProverInputPreprocessor.access$getJson$p().decodeFromString((DeserializationStrategy)BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), it);
                }
            });
            this.instances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ContractInstanceInSDC> invoke() {
                    void $this$mapTo$iv$iv;
                    Object object;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Map $this$mapNotNull$iv = BasicContractSource.access$getBuildResources(this.this$0);
                    boolean $i$f$mapNotNull = false;
                    Map map2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (object2.hasNext()) {
                        ContractInstanceInSDC it$iv$iv;
                        Object v0;
                        block3: {
                            Map.Entry<K, V> element$iv$iv$iv;
                            Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = object2.next();
                            boolean bl = false;
                            object = element$iv$iv;
                            boolean bl2 = false;
                            SingleDeployedContract v = (SingleDeployedContract)object.getValue();
                            Iterable $this$firstOrNull$iv = v.getContracts();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                ContractInstanceInSDC it = (ContractInstanceInSDC)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(it.getAddress(), v.getPrimary_contract_address())) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = null;
                        }
                        if ((ContractInstanceInSDC)v0 == null) continue;
                        boolean bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void contractInstanceInSDC;
                        object2 = (ContractInstanceInSDC)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        BigInteger bigInteger = contractInstanceInSDC.getAddress();
                        Map<K, V> map3 = MapsKt.emptyMap();
                        object = contractInstanceInSDC.getName();
                        StorageLayout storageLayout = contractInstanceInSDC.getStorageLayout();
                        Set<SourceTypeDescription> set2 = contractInstanceInSDC.getTypes();
                        Set<SolidityTypeDescription> set3 = contractInstanceInSDC.getSolidityTypes();
                        List<Method> list = contractInstanceInSDC.getMethods();
                        List<Method> list2 = contractInstanceInSDC.getAllMethods();
                        Map<String, Method> map4 = contractInstanceInSDC.getInternalFunctions();
                        String string = contractInstanceInSDC.getOriginal_file();
                        SourceLanguage sourceLanguage = contractInstanceInSDC.getLang();
                        String string2 = contractInstanceInSDC.getSourceDir();
                        collection.add(new ContractInstanceInSDC((String)object, string, sourceLanguage, "", bigInteger, list, "", "", "", null, null, storageLayout, set2, set3, map3, null, null, null, null, null, list2, map4, null, string2, 5211648, null));
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        private final Map<String, SingleDeployedContract> getBuildResources() {
            Lazy lazy = this.buildResources$delegate;
            return (Map)lazy.getValue();
        }

        private final List<ContractInstanceInSDC> getInstances() {
            Lazy lazy = this.instances$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc, @NotNull IPerContractClassCache cache2) {
            Intrinsics.checkNotNullParameter(sdc, "sdc");
            Intrinsics.checkNotNullParameter(cache2, "cache");
            return new IContractClass(sdc){
                final /* synthetic */ ContractInstanceInSDC $sdc;
                {
                    this.$sdc = $sdc;
                }

                @Nullable
                public ITACMethod getConstructor() {
                    return null;
                }

                @Nullable
                public ITACMethod getMethodBySigHash(@NotNull BigInteger sig) {
                    Intrinsics.checkNotNullParameter(sig, "sig");
                    return null;
                }

                @Nullable
                public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique attr) {
                    Intrinsics.checkNotNullParameter(attr, "attr");
                    return null;
                }

                @NotNull
                public IStorageInfo getStorage() {
                    return DummyStorageInfo.INSTANCE;
                }

                @Nullable
                public TACStorageLayout getStorageLayout() {
                    StorageLayout storageLayout = this.$sdc.getStorageLayout();
                    return storageLayout != null ? storageLayout.toTACStorageLayout() : null;
                }

                @NotNull
                public Collection<ITACMethod> getDeclaredMethods() {
                    return CollectionsKt.emptyList();
                }

                public void mapMethods(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p) {
                    Intrinsics.checkNotNullParameter(scene, "scene");
                    Intrinsics.checkNotNullParameter(p, "p");
                }

                @NotNull
                public IContractClass fork() {
                    return this;
                }

                @NotNull
                public BigInteger getInstanceId() {
                    return this.$sdc.getAddress();
                }

                @NotNull
                public String getName() {
                    return this.$sdc.getName();
                }

                @NotNull
                public Map<BigInteger, ITACMethod> getMethods() {
                    return MapsKt.emptyMap();
                }

                @Nullable
                public ITACMethod getWholeContractMethod() {
                    return null;
                }

                @Nullable
                public ITACMethod getConstructorMethod() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getBytecode() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getConstructorBytecode() {
                    return null;
                }

                @NotNull
                public ContractInstanceInSDC getSrc() {
                    return this.$sdc;
                }

                @NotNull
                public ITACSymbol getAddressSym() {
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public ContractClassIdentifiers toIdentifiers() {
                    return IContractClass.DefaultImpls.toIdentifiers(this);
                }

                @NotNull
                public ITACMethod getWholeContract() {
                    return IContractClass.DefaultImpls.getWholeContract(this);
                }

                @NotNull
                public List<ITACMethod> getMethods() {
                    return IContractClass.DefaultImpls.getMethods(this);
                }

                @NotNull
                public Collection<ITACMethod> getStandardMethods() {
                    return IContractClass.DefaultImpls.getStandardMethods(this);
                }

                public void mapMethodsInPlace(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
                    IContractClass.DefaultImpls.mapMethodsInPlace(this, scene, p);
                }

                @NotNull
                public String getConstructorCodeName() {
                    return IContractClass.DefaultImpls.getConstructorCodeName(this);
                }

                @NotNull
                public IContractClass.ContractMemento saveState() {
                    return IContractClass.DefaultImpls.saveState(this);
                }

                public void restore(@NotNull IContractClass.ContractMemento m) {
                    IContractClass.DefaultImpls.restore(this, m);
                }

                @Nullable
                public ContractWithStateLinkInfo getContractStateLinks() {
                    return IContractClass.DefaultImpls.getContractStateLinks(this);
                }
            };
        }

        @Override
        @NotNull
        public List<ContractInstanceInSDC> instances() {
            return this.getInstances();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Set<BigInteger>> aliases() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInstances();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ContractInstanceInSDC contractInstanceInSDC = (ContractInstanceInSDC)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SetsKt.setOf(it.getAddress()));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.load(this, sdc);
        }

        @Override
        @NotNull
        public ContractUniverse contractUniverse() {
            return IContractSource.DefaultImpls.contractUniverse(this);
        }

        @Override
        @NotNull
        public IContractClass invoke(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.invoke(this, sdc);
        }

        public static final /* synthetic */ Map access$getBuildResources(BasicContractSource $this) {
            return $this.getBuildResources();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "", "metadataFileName", "", "buildFileName", "verifyFileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildFileName", "()Ljava/lang/String;", "getMetadataFileName", "getVerifyFileName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Shared"})
    public static final class InputFileNames {
        @Nullable
        private final String metadataFileName;
        @Nullable
        private final String buildFileName;
        @Nullable
        private final String verifyFileName;

        public InputFileNames(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            this.metadataFileName = metadataFileName;
            this.buildFileName = buildFileName;
            this.verifyFileName = verifyFileName;
        }

        @Nullable
        public final String getMetadataFileName() {
            return this.metadataFileName;
        }

        @Nullable
        public final String getBuildFileName() {
            return this.buildFileName;
        }

        @Nullable
        public final String getVerifyFileName() {
            return this.verifyFileName;
        }

        @Nullable
        public final String component1() {
            return this.metadataFileName;
        }

        @Nullable
        public final String component2() {
            return this.buildFileName;
        }

        @Nullable
        public final String component3() {
            return this.verifyFileName;
        }

        @NotNull
        public final InputFileNames copy(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
        }

        public static /* synthetic */ InputFileNames copy$default(InputFileNames inputFileNames, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = inputFileNames.metadataFileName;
            }
            if ((n & 2) != 0) {
                string2 = inputFileNames.buildFileName;
            }
            if ((n & 4) != 0) {
                string3 = inputFileNames.verifyFileName;
            }
            return inputFileNames.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "InputFileNames(metadataFileName=" + this.metadataFileName + ", buildFileName=" + this.buildFileName + ", verifyFileName=" + this.verifyFileName + ")";
        }

        public int hashCode() {
            int result2 = this.metadataFileName == null ? 0 : this.metadataFileName.hashCode();
            result2 = result2 * 31 + (this.buildFileName == null ? 0 : this.buildFileName.hashCode());
            result2 = result2 * 31 + (this.verifyFileName == null ? 0 : this.verifyFileName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileNames)) {
                return false;
            }
            InputFileNames inputFileNames = (InputFileNames)other;
            if (!Intrinsics.areEqual(this.metadataFileName, inputFileNames.metadataFileName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.buildFileName, inputFileNames.buildFileName)) {
                return false;
            }
            return Intrinsics.areEqual(this.verifyFileName, inputFileNames.verifyFileName);
        }
    }
}

