/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.CastType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpFolder;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLExpTypeCheckerWithContext;
import utils.CollectingResult;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJD\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JD\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u0012H\u0016JD\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u0014H\u0016JD\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u0016H\u0016JD\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u001bH\u0002JD\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\u001eH\u0016JD\u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020 H\u0016JD\u0010!\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020\"H\u0016JD\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000f\u001a\u00020$H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lspec/cvlast/typechecker/QuantifierTypeChecker;", "Lspec/cvlast/CVLExpFolder;", "Lutils/CollectingResult;", "", "Lspec/cvlast/typechecker/CVLError;", "Lutils/VoidResult;", "qe", "Lspec/cvlast/CVLExp$QuantifierExp;", "(Lspec/cvlast/CVLExp$QuantifierExp;)V", "postfix", "", "getPostfix", "()Ljava/lang/String;", "applyExp", "acc", "exp", "Lspec/cvlast/CVLExp$ApplyExp;", "arrayderef", "Lspec/cvlast/CVLExp$ArrayDerefExp;", "arrayexp", "Lspec/cvlast/CVLExp$ArrayLitExp;", "arraylength", "Lspec/cvlast/CVLExp$ArrayLengthExp;", "castExpression", "Lspec/cvlast/CVLExp$CastExpr;", "isArray", "e", "Lspec/cvlast/CVLExp;", "isStorageReference", "relop", "Lspec/cvlast/CVLExp$RelopExp;", "setmem", "Lspec/cvlast/CVLExp$SetMemExp;", "unary", "Lspec/cvlast/CVLExp$UnaryExp;", "variable", "Lspec/cvlast/CVLExp$VariableExp;", "Shared"})
public final class QuantifierTypeChecker
extends CVLExpFolder<CollectingResult<? extends Unit, ? extends CVLError>> {
    @NotNull
    private final CVLExp.QuantifierExp qe;
    @NotNull
    private final String postfix;

    public QuantifierTypeChecker(@NotNull CVLExp.QuantifierExp qe) {
        Intrinsics.checkNotNullParameter(qe, "qe");
        this.qe = qe;
        this.postfix = "are disallowed inside quantified formulas.";
    }

    @NotNull
    public final String getPostfix() {
        return this.postfix;
    }

    private final CollectingResult<Unit, CVLError> isArray(CVLExp e) {
        return CollectingResult.Companion.bind(CVLExpTypeCheckerWithContext.Companion.getOrInferPureCVLTypeDefaultError(e), (Function1)new Function1<CVLType.PureCVLType, CollectingResult<? extends Unit, ? extends CVLError>>(this){
            final /* synthetic */ QuantifierTypeChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CollectingResult<Unit, CVLError> invoke(@NotNull CVLType.PureCVLType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it instanceof CVLType.PureCVLType.CVLArrayType ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(QuantifierTypeChecker.access$getQe$p(this.this$0).getBody(), "Arrays " + this.this$0.getPostfix())) : (CollectingResult)CollectingResult.Companion.getOk();
            }
        });
    }

    private final CollectingResult<Unit, CVLError> isStorageReference(CVLExp exp) {
        return exp.getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.StorageReference ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "Storage comparison references " + this.postfix)) : (CollectingResult)CollectingResult.Companion.getOk();
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> castExpression(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.CastExpr exp) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        switch (WhenMappings.$EnumSwitchMapping$0[exp.getCastType().ordinal()]) {
            case 1: {
                collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "Require casts " + this.postfix));
                break;
            }
            case 2: {
                collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "Assert casts " + this.postfix));
                break;
            }
            case 3: 
            case 4: {
                collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return CollectingResult.Companion.bind(super.castExpression(acc, exp), collectingResult);
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> arrayderef(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ArrayDerefExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return CollectingResult.Companion.bind(super.arrayderef(acc, exp), this.isArray(exp.getArray()), this.isStorageReference(exp));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> relop(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.RelopExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return CollectingResult.Companion.bind(super.relop(acc, exp), (Function1)new Function1<Unit, CollectingResult<? extends Unit, ? extends CVLError>>(exp, this){
            final /* synthetic */ CVLExp.RelopExp $exp;
            final /* synthetic */ QuantifierTypeChecker this$0;
            {
                this.$exp = $exp;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CollectingResult<Unit, CVLError> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$exp.getR().getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.BlockchainState ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(this.$exp, "Storage comparisons " + this.this$0.getPostfix())) : (CollectingResult)CollectingResult.Companion.getOk();
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> arraylength(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ArrayLengthExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return CollectingResult.Companion.bind(super.arraylength(acc, exp), this.isArray(exp.getArray()));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> arrayexp(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ArrayLitExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return CollectingResult.Companion.bind(super.arrayexp(acc, exp), (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "Array Literals " + this.postfix)));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> setmem(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.SetMemExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return CollectingResult.Companion.bind(super.setmem(acc, exp), (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "Set membership checks " + this.postfix)));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> applyExp(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ApplyExp exp) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        CVLExp.ApplyExp applyExp2 = exp;
        if (applyExp2 instanceof CVLExp.ApplyExp.CVLFunction) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "CVL Function calls " + this.postfix));
        } else if (applyExp2 instanceof CVLExp.ApplyExp.ContractFunction) {
            collectingResult = !((CVLExp.ApplyExp.ContractFunction)exp).getNoRevert() ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp, "Contract calls with the '@withrevert' annotation " + this.postfix)) : (CollectingResult)CollectingResult.Companion.lift(Unit.INSTANCE);
        } else if (applyExp2 instanceof CVLExp.ApplyExp.Definition ? true : applyExp2 instanceof CVLExp.ApplyExp.Ghost) {
            collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectingResult.Companion.bind(super.applyExp(acc, exp), collectingResult);
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> unary(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.UnaryExp exp) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        CVLExp.UnaryExp unaryExp = exp;
        if (unaryExp instanceof CVLExp.UnaryExp.BwNotExp) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "Bitwise not expressions " + this.postfix));
        } else if (unaryExp instanceof CVLExp.UnaryExp.LNotExp) {
            collectingResult = CollectingResult.Companion.lift(Unit.INSTANCE);
        } else if (unaryExp instanceof CVLExp.UnaryExp.UnaryMinusExp) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp, "Unary minus expressions " + this.postfix));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectingResult.Companion.bind(super.unary(acc, exp), collectingResult);
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> variable(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.VariableExp exp) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp, "exp");
        return acc;
    }

    public static final /* synthetic */ CVLExp.QuantifierExp access$getQe$p(QuantifierTypeChecker $this) {
        return $this.qe;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CastType.values().length];
            try {
                nArray[CastType.REQUIRE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.ASSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.CONVERT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.TO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

