# Generated by Django 2.1.4 on 2018-12-06 21:57

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Target',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(help_text='The identifier for this object, e.g. Kelt-16b.', max_length=100, verbose_name='Identifier')),
                ('name', models.CharField(default='', help_text="The name of this target e.g. Barnard's star.", max_length=100, verbose_name='Name')),
                ('type', models.CharField(choices=[('SIDEREAL', 'Sidereal'), ('NON_SIDEREAL', 'Non-sidereal')], help_text='The type of this target.', max_length=100, verbose_name='Target Type')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='The time which this target was created in the TOM database.', verbose_name='Time Created')),
                ('modified', models.DateTimeField(auto_now=True, help_text='The time which this target was changed in the TOM database.', verbose_name='Last Modified')),
                ('ra', models.FloatField(blank=True, help_text='Right Ascension, in degrees.', null=True, verbose_name='Right Ascension')),
                ('dec', models.FloatField(blank=True, help_text='Declination, in degrees.', null=True, verbose_name='Declination')),
                ('epoch', models.FloatField(blank=True, help_text='Julian Years. Max 2100.', null=True, verbose_name='Epoch of Elements')),
                ('parallax', models.FloatField(blank=True, help_text='Parallax, in milliarcseconds.', null=True, verbose_name='Parallax')),
                ('pm_ra', models.FloatField(blank=True, help_text='Proper Motion: RA. Milliarsec/year.', null=True, verbose_name='Proper Motion (RA)')),
                ('pm_dec', models.FloatField(blank=True, help_text='Proper Motion: Dec. Milliarsec/year.', null=True, verbose_name='Proper Motion (Declination)')),
                ('galactic_lng', models.FloatField(blank=True, help_text='Galactic Longitude in degrees.', null=True, verbose_name='Galactic Longitude')),
                ('galactic_lat', models.FloatField(blank=True, help_text='Galactic Latitude in degrees.', null=True, verbose_name='Galactic Latitude')),
                ('distance', models.FloatField(blank=True, help_text='Parsecs.', null=True, verbose_name='Distance')),
                ('distance_err', models.FloatField(blank=True, help_text='Parsecs.', null=True, verbose_name='Distance Error')),
                ('mean_anomaly', models.FloatField(blank=True, help_text='Angle in degrees.', null=True, verbose_name='Mean Anomaly')),
                ('arg_of_perihelion', models.FloatField(blank=True, help_text='Argument of Perhihelion. J2000. Degrees.', null=True, verbose_name='Argument of Perihelion')),
                ('eccentricity', models.FloatField(blank=True, help_text='Eccentricity', null=True, verbose_name='Eccentricity')),
                ('lng_asc_node', models.FloatField(blank=True, help_text='Longitude of Ascending Node. J2000. Degrees.', null=True, verbose_name='Longitude of Ascending Node')),
                ('inclination', models.FloatField(blank=True, help_text='Inclination to the ecliptic. J2000. Degrees.', null=True, verbose_name='Inclination to the ecliptic')),
                ('mean_daily_motion', models.FloatField(blank=True, help_text='Degrees per day.', null=True, verbose_name='Mean Daily Motion')),
                ('semimajor_axis', models.FloatField(blank=True, help_text='In AU', null=True, verbose_name='Semimajor Axis')),
                ('ephemeris_period', models.FloatField(blank=True, help_text='Days', null=True, verbose_name='Ephemeris Period')),
                ('ephemeris_period_err', models.FloatField(blank=True, help_text='Days', null=True, verbose_name='Ephemeris Period Error')),
                ('ephemeris_epoch', models.FloatField(blank=True, help_text='Days', null=True, verbose_name='Ephemeris Epoch')),
                ('ephemeris_epoch_err', models.FloatField(blank=True, help_text='Days', null=True, verbose_name='Ephemeris Epoch Error')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='TargetExtra',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=200)),
                ('value', models.TextField()),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tom_targets.Target')),
            ],
        ),
        migrations.CreateModel(
            name='TargetList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of the target list.', max_length=200)),
                ('created', models.DateTimeField(auto_now_add=True, help_text='The time which this target list was created in the TOM database.')),
                ('targets', models.ManyToManyField(to='tom_targets.Target')),
            ],
        ),
    ]
