"""Enumerations used by oddball."""

from enum import Enum


class Dataset(str, Enum):
    """Supported datasets drawn from the ADBench Classical collection."""

    ALOI = "aloi"
    ANNTHYROID = "annthyroid"
    BACKDOOR = "backdoor"
    BREASTW = "breastw"
    CAMPAIGN = "campaign"
    CARDIO = "cardio"
    CARDIOTOCOGRAPHY = "cardiotocography"
    CELEBA = "celeba"
    CENSUS = "census"
    COVER = "cover"
    DONORS = "donors"
    FAULT = "fault"
    FRAUD = "fraud"
    GLASS = "glass"
    HEPATITIS = "hepatitis"
    HTTP = "http"
    INTERNETADS = "internetads"
    IONOSPHERE = "ionosphere"
    LANDSAT = "landsat"
    LETTER = "letter"
    LYMPHOGRAPHY = "lymphography"
    MAGIC_GAMMA = "magic_gamma"
    MAMMOGRAPHY = "mammography"
    MNIST = "mnist"
    MUSK = "musk"
    OPTDIGITS = "optdigits"
    PAGEBLOCKS = "pageblocks"
    PENDIGITS = "pendigits"
    PIMA = "pima"
    SATELLITE = "satellite"
    SATIMAGE2 = "satimage2"
    SHUTTLE = "shuttle"
    SKIN = "skin"
    SMTP = "smtp"
    SPAMBASE = "spambase"
    SPEECH = "speech"
    STAMPS = "stamps"
    THYROID = "thyroid"
    VERTEBRAL = "vertebral"
    VOWELS = "vowels"
    WAVEFORM = "waveform"
    WBC = "wbc"
    WDBC = "wdbc"
    WILT = "wilt"
    WINE = "wine"
    WPBC = "wpbc"
    YEAST = "yeast"
