/*!
 * Source: https://github.com/nex3/npf2html (commit 05d602a0ba7c58d06e68603d91338a734c02ce2c)
 * Built with: esbuild 0.25.10
 *   esbuild src/index.ts --bundle --format=iife --global-name=npf2html --platform=neutral --target=es2020 --outfile=dist/npf2html.iife.js --minify --sourcemap
 *
 * SPDX-License-Identifier: MIT
 *
 * Copyright (c) 2024 Natalie Weizenbaum
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
"use strict";var npf2html=(()=>{var _=Object.defineProperty;var X=Object.getOwnPropertyDescriptor;var Y=Object.getOwnPropertyNames;var Z=Object.prototype.hasOwnProperty;var ee=(t,e)=>{for(var r in e)_(t,r,{get:e[r],enumerable:!0})},te=(t,e,r,n)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of Y(e))!Z.call(t,i)&&i!==r&&_(t,i,{get:()=>e[i],enumerable:!(n=X(e,i))||n.enumerable});return t};var re=t=>te(_({},"__esModule",{value:!0}),t);var ce={};ee(ce,{Renderer:()=>B,default:()=>W});function M(t,e,r){let n=`<div class="${t.prefix}-layout-ask">`;return n+="<figure><figcaption>",e.attribution&&(n+=`<a href="${t.escape(e.attribution.blog.url)}">`),n+="<strong>"+t.escape(e.attribution?.blog?.name??"Anonymous")+"</strong> asked:",e.attribution&&(n+="</a>"),n+="</figcaption>"+r+"</figure></div>",n}function y(t){return!!t&&"type"in t}function T(t,e){let r=e.type==="blog"?e.blog.url:e.url,n=`<a class="${t.prefix}-attribution ${t.prefix}-attribution-${e.type}" href="${t.escape(r)}">`;switch(e.type){case"post":case"blog":n+=t.escape(e.blog.name);break;case"link":n+=t.escape(e.url);break;case"app":{let i=e.display_text||e.app_name;i&&(n+=t.escape(i)),e.logo?n+=t.renderImageMedia([e.logo]):i||(n+=t.escape(e.url))}}return n+"</a>"}function P(t,e){let r=`<figure class="${t.prefix}-block-audio">`;if(e.media||!(e.embed_html||e.embed_url)){let n=e.title||e.artist||e.album,i=e.poster||y(e.attribution)||n;e.media?(r+=`<audio controls src="${t.escape(e.media.url)}"></audio>`,i&&(r+="<figcaption>")):r+=`<a href="${t.escape(e.url)}">`,e.poster&&(r+=t.renderImageMedia(e.poster)),e.title&&(r+=`<span class="${t.prefix}-block-audio-title">`+t.escape(e.title)+"</span>"),e.artist&&(e.title&&(r+=" - "),r+=`<span class="${t.prefix}-block-audio-artist">`+t.escape(e.artist)+"</span>"),e.album&&((e.title||e.artist)&&(r+=" on "),r+=`<span class="${t.prefix}-block-audio-album">`+t.escape(e.album)+"</span>"),e.media||(n||(r+=t.escape(e.url)),r+="</a>"),y(e.attribution)&&(e.media||(r+="<figcaption>"),r+=t.renderAttribution(e.attribution),e.media||(r+="</figcaption>")),e.media&&i&&(r+="</figcaption>")}else r+=e.embed_html?e.embed_html:`<iframe src="${t.escape(e.embed_url)}"></iframe>`,y(e.attribution)&&(r+="<figcaption>"+t.renderAttribution(e.attribution)+"</figcaption>");return r+="</figure>",r}function v(t,e){let r=e.media.reduce((i,s)=>i&&(i.width??0)>(s.width??0)?i:s),n=`<figure class="${t.prefix}-block-image"><a href="${t.escape(r.url)}">`+t.renderImageMedia(e.media,{alt:e.alt_text})+"</a>";return(e.caption||y(e.attribution))&&(n+="<figcaption>",e.caption&&(n+=`<span class="${t.prefix}-block-image-caption">`+t.escape(e.caption)+"</span>"),y(e.attribution)&&(n+=t.renderAttribution(e.attribution)),n+="</figcaption>"),n+="</figure>",n}function ne(t){let e={},r=[];for(let n of t){if(n.type==="link"||n.type==="mention"){r.push(n);continue}let i=e[n.type];if(i!==void 0){let s=r[i];if(s&&ie(s,n)){r[i]={...s,end:n.end};continue}}e[n.type]=r.length,r.push(n)}return r}function ie(t,e){if(t.end!==e.start||t.type!==e.type)return!1;switch(t.type){case"bold":case"italic":case"strikethrough":case"small":return!0;case"link":case"mention":return!1;case"color":return t.hex===e.hex}}function oe(t){switch(t.type){case"bold":case"italic":case"strikethrough":case"small":return t.type;case"color":return`color:${t.hex.toLowerCase()}`;case"link":return`link:${t.url}`;case"mention":return`mention:${t.blog.url}`}}function A(t){switch(t.format.type){case"link":return 0;case"mention":return 1;case"color":return 2;case"bold":return 3;case"italic":return 4;case"strikethrough":return 5;case"small":return 6}}function $(t){return t.format.type==="link"||t.format.type==="mention"}function ae(t){let e=t.filter($);return e.length===0?null:(e.sort((r,n)=>{if(r.start!==n.start)return n.start-r.start;let i=r.end-r.start,s=n.end-n.start;return i!==s?i-s:r.key<n.key?-1:r.key>n.key?1:0}),e[0])}function se(t,e){switch(e.format.type){case"bold":return"<strong>";case"italic":return"<em>";case"strikethrough":return"<s>";case"small":return"<small>";case"color":return`<span style="color: ${t.escape(e.format.hex)}">`;case"link":return`<a href="${t.escape(e.format.url)}">`;case"mention":return`<a class="${t.prefix}-inline-mention" href="${t.escape(e.format.blog.url)}">`}}function V(t){switch(t.format.type){case"bold":return"</strong>";case"italic":return"</em>";case"strikethrough":return"</s>";case"small":return"</small>";case"color":return"</span>";case"link":case"mention":return"</a>"}}function le(t){let e=[0],r=0;for(let n=0;n<t.length;){let d=(t.charCodeAt(n)&64512)===55296?2:1;r+=d,n+=d,e.push(r)}return e}function C(t,e,r){switch(r.type){case"bold":return`<strong>${e}</strong>`;case"italic":return`<em>${e}</em>`;case"strikethrough":return`<s>${e}</s>`;case"small":return`<small>${e}</small>`;case"link":return`<a href="${t.escape(r.url)}">${e}</a>`;case"mention":return`<a class="${t.prefix}-inline-mention" href="${t.escape(r.blog.url)}">${e}</a>`;case"color":return`<span style="color: ${t.escape(r.hex)}">`+e+"</span>"}}function S(t,e,r){if(!r||r.length===0)return t.escape(e);let n=ne(r),i=le(e),s=i.length-1,d=[];for(let o of n){let p=Math.max(0,Math.min(s,o.start)),h=Math.max(p,Math.min(s,o.end??o.start));if(p>=h)continue;let x={format:o,key:oe(o),start:p,end:h};d.push({f:x})}if(d.length===0)return t.escape(e);d.sort((o,p)=>o.f.start-p.f.start||o.f.end-p.f.end||A(o.f)-A(p.f)||(o.f.key<p.f.key?-1:o.f.key>p.f.key?1:0));let m=new Set;for(let o of d)m.add(o.f.start),m.add(o.f.end);m.add(0),m.add(s);let a=Array.from(m).sort((o,p)=>o-p),g=0,u=[],f="";for(let o=0;o<a.length-1;o++){let p=a[o],h=a[o+1];if(p>=h)continue;for(;g<d.length&&d[g].f.end<=p;)g++;let x=[];for(let l=g;l<d.length;l++){let c=d[l].f;if(c.start>p)break;c.end>p&&x.push(c)}let k=[];{let l=new Set;for(let c of x)l.has(c.key)||(l.add(c.key),k.push(c))}let w=ae(k),I=[];for(let l of k)$(l)?w&&l.key===w.key&&I.push(l):I.push(l);I.sort((l,c)=>{let F=$(l),Q=$(c);if(F!==Q)return F?-1:1;if(l.start!==c.start)return l.start-c.start;if(l.end!==c.end)return c.end-l.end;let R=A(l),L=A(c);return R!==L?R-L:l.key<c.key?-1:l.key>c.key?1:0});let b=0;for(;b<u.length&&b<I.length&&u[b].key===I[b].key;)b++;for(let l=u.length-1;l>=b;l--)f+=V(u[l]);u.length=b;for(let l=b;l<I.length;l++){let c=I[l];f+=se(t,c),u.push(c)}let z=i[p],J=i[h];f+=t.escape(e.substring(z,J))}for(let o=u.length-1;o>=0;o--)f+=V(u[o]);return f}function q(t,e){let r=`<a class="${t.prefix}-block-link" href="${t.escape(e.url)}">`;return e.poster&&(r+=t.renderImageMedia(e.poster)),r+="<h2>"+t.escape(e.title??e.display_url??e.url)+"</h2>",e.site_name&&(r+=`<p class="${t.prefix}-block-link-site">${t.escape(e.site_name)}</p>`),e.author&&(r+=`<p class="${t.prefix}-block-link-author">${t.escape(e.author)}</p>`),e.description&&(r+=`<p class="${t.prefix}-block-link-description">${t.escape(e.description)}</p>`),r+="</a>",r}function D(t,e,r){let n="<img",i=e.reduce((s,d)=>s&&(s.width??0)>(d.width??0)?s:d);return n+=` src="${t.escape(i.url)}"`,r?.alt&&(n+=` alt="${t.escape(r.alt)}"`),n+=">",n}function N(t,e){if(e.is_visible===!1)return"";let r=`<a class="${t.prefix}-block-paywall ${t.prefix}-block-paywall-${e.subtype}" href="${t.escape(e.url)}"`;return e.subtype==="divider"&&e.color&&(r+=` style="--${t.prefix}-paywall-color: ${e.color}"`),r+=">",e.subtype!=="divider"&&e.title&&(r+=`<h2>${t.escape(e.title)}</h2>`),e.text&&(r+=`<p>${t.escape(e.text)}</p>`),r+="</a>",r}function O(t,e){let r=`<div class="${t.prefix}-block-poll"><h2>${t.escape(e.question)}</h2><ul>`;for(let n of e.answers)r+=`<li>${t.escape(n.answer_text)}</li>`;return r+="</ul></div>",r}function U(t,e,r){let n=[`${t.prefix}-layout-row`];return e?.mode?.type&&n.push(`${t.prefix}-layout-row-${e?.mode?.type}`),`<div class="${n.join(" ")}">${r}</div>`}function E(t,e){return`<details class="${t.prefix}-layout-truncate"><summary>Keep reading</summary>${e}</details>`}function G(t,e){let r=t.formatText(e.text,e.formatting);switch(e.subtype){case"heading1":return`<h1>${r}</h1>`;case"heading2":return`<h2>${r}</h2>`;case"quirky":return`<p class="${t.prefix}-block-text-quirky">${r}</p>`;case"quote":return`<blockquote class="${t.prefix}-block-text-quote"><p>${r}</p></blockquote>`;case"chat":return`<p class="${t.prefix}-block-text-chat">${r}</p>`;default:return`<p>${r}</p>`}}function j(t,e){let{subtype:r}=e[0],n={indented:"<blockquote>","ordered-list-item":"<ol>","unordered-list-item":"<ul>"}[r];for(let i of e){let s=typeof i=="string";n+=r==="indented"?s?"":"<p>":"<li>",n+=s?i:t.formatText(i.text,i.formatting),n+=r==="indented"?s?"":"</p>":"</li>"}return n+={indented:"</blockquote>","ordered-list-item":"</ol>","unordered-list-item":"</ul>"}[r],n}function H(t,e){let r=`<figure class="${t.prefix}-block-video">`;return e.media?(r+='<video controls src="'+t.escape(e.media?.url??e.url)+'"',e.poster&&(r+=' poster="'+t.escape(e.poster.reduce((n,i)=>n&&(n.width??0)>(i.width??0)?n:i).url)+'"'),r+="></video>"):e.embed_html?r+=e.embed_html:e.embed_iframe?r+=`<iframe src="${t.escape(e.embed_iframe.url)}" width="${e.embed_iframe.width}" height="${e.embed_iframe.height}"></iframe>`:e.embed_url?r+=`<iframe src="${t.escape(e.embed_url)}"></iframe>`:r+=`<a href="${t.escape(e.url)}">`+t.escape(e.url)+"</a>",y(e.attribution)&&(r+="<figcaption>"+t.renderAttribution(e.attribution)+"</figcaption>"),r+="</figure>",r}var ue=[{width:128,height:128,url:"https://assets.tumblr.com/images/anonymous_avatar_128.gif"},{width:96,height:96,url:"https://assets.tumblr.com/images/anonymous_avatar_96.gif"},{width:64,height:64,url:"https://assets.tumblr.com/images/anonymous_avatar_64.gif"},{width:48,height:48,url:"https://assets.tumblr.com/images/anonymous_avatar_48.gif"}],B=class{constructor(e){this.prefix=e?.prefix??"npf",this.askingAvatar=e?.askingAvatar??ue}escape(e){return e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}formatText(e,r){return S(this,e,r)}renderAskLayout(e,r){return M(this,e,r)}renderAttribution(e){return T(this,e)}renderAudio(e){return P(this,e)}renderImage(e){return v(this,e)}renderInlineFormat(e,r){return C(this,e,r)}renderImageMedia(e,r){return D(this,e,r)}renderLink(e){return q(this,e)}renderPaywall(e){return N(this,e)}renderPoll(e){return O(this,e)}renderRowLayout(e,r){return U(this,e,r)}renderTextNoIndent(e){return G(this,e)}renderTextIndented(e){return j(this,e)}renderTruncateLayout(e){return E(this,e)}renderUnknown(e){return`<p color="font-weight: bold; color: red">Unknown block type "${this.escape(e.type)}"!</p>`}renderVideo(e){return H(this,e)}};function K(t){return t.type==="text"&&(t.subtype==="indented"||t.subtype==="ordered-list-item"||t.subtype==="unordered-list-item")}function pe(t){let e=[];for(let r of t?.layout??[])if(r.type==="ask")e.push(r);else if(r.type==="rows")for(let n of r.display)n.blocks.length!==1&&e.push(n);return e.map(r=>({layout:r,start:Math.min(...r.blocks),end:Math.max(...r.blocks)+1})).sort((r,n)=>r.start-n.start)}function W(t,e){let r=e?.renderer??new B(e),n="",i;for(let a of e?.layout??[])if(a.type==="rows"&&a.truncate_after!==void 0){i=a.truncate_after;break}else if(a.type==="condensed"){if(a.blocks===void 0&&a.truncate_after===void 0)throw new Error("Condensed layout requires either blocks or truncate_after to be present");if(a.blocks!==void 0&&a.blocks.some((g,u)=>g!==u))throw new Error(`Condensed layout has invalid blocks: [${a.blocks}]`);a.truncate_after!==void 0?i=a.truncate_after:a.blocks!==void 0&&(i=a.blocks.length===0?-1:a.blocks[a.blocks.length-1]);break}let s;i===-1&&(s=0);let d=pe(e),m="";for(let a=0;a<t.length;a++){let g=()=>{let p=t[a],h=p.indent_level??0,x=[p];for(;a<t.length-1;){let k=t[a+1];if(!K(k))break;let w=k.indent_level??0;if(w<h)break;if(w===h){if(k.subtype!==p.subtype)break;a++,x.push(k)}else a++,x.push(g())}return r.renderTextIndented(x)},u,f=t[a];switch(f.type){case"audio":u=r.renderAudio(f);break;case"image":u=r.renderImage(f);break;case"link":u=r.renderLink(f);break;case"paywall":u=r.renderPaywall(f);break;case"poll":u=r.renderPoll(f);break;case"video":u=r.renderVideo(f);break;case"text":K(f)?u=g():u=r.renderTextNoIndent(f);break;default:u=r.renderUnknown(f);break}let o=d[0];o&&a>=o.start?(m+=u,a+1===o.end&&(d.shift(),"type"in o.layout?n+=r.renderAskLayout(o.layout,m):n+=r.renderRowLayout(o.layout,m),m="")):n+=u,a===i&&(s=n.length)}return s!==void 0&&(n=n.substring(0,s)+r.renderTruncateLayout(n.substring(s))),n}return re(ce);})();
//# sourceMappingURL=npf2html.iife.js.map
