mod capitalize;
mod contains;
mod count_matches;
mod endswith;
mod find;
mod ilike;
mod left;
mod length_bytes;
mod like;
mod lower;
mod lpad;
mod lstrip;
mod normalize;
pub(crate) mod pad;
mod regexp_count;
mod regexp_extract;
mod regexp_extract_all;
mod regexp_match;
mod repeat;
mod replace;
mod reverse;
mod right;
mod rpad;
mod rstrip;
mod split;
mod startswith;
mod substr;
mod to_date;
mod to_datetime;
mod upper;
pub(crate) mod utils;

pub use capitalize::*;
pub use contains::*;
pub use count_matches::*;
pub use endswith::*;
pub use find::*;
pub use ilike::*;
pub use left::*;
pub use length_bytes::*;
pub use like::*;
pub use lower::*;
pub use lpad::*;
pub use lstrip::*;
pub use normalize::*;
pub use regexp_count::*;
pub use regexp_extract::*;
pub use regexp_extract_all::*;
pub use regexp_match::*;
pub use repeat::*;
pub use replace::*;
pub use reverse::*;
pub use right::*;
pub use rpad::*;
pub use rstrip::*;
pub use split::*;
pub use startswith::*;
pub use substr::*;
pub use to_date::*;
pub use to_datetime::*;
pub use upper::*;

pub struct Utf8Functions;

impl daft_dsl::functions::FunctionModule for Utf8Functions {
    fn register(parent: &mut daft_dsl::functions::FunctionRegistry) {
        parent.add_fn(Capitalize);
        parent.add_fn(Contains);
        parent.add_fn(CountMatches);
        parent.add_fn(EndsWith);
        parent.add_fn(Find);
        parent.add_fn(ILike);
        parent.add_fn(Left);
        parent.add_fn(LengthBytes);
        parent.add_fn(Like);
        parent.add_fn(Lower);
        parent.add_fn(LPad);
        parent.add_fn(LStrip);
        parent.add_fn(Normalize);
        parent.add_fn(RegexpCount);
        parent.add_fn(RegexpExtract);
        parent.add_fn(RegexpExtractAll);
        parent.add_fn(RegexpMatch);
        parent.add_fn(Repeat);
        parent.add_fn(Replace);
        parent.add_fn(RegexpReplace);
        parent.add_fn(Reverse);
        parent.add_fn(Right);
        parent.add_fn(RPad);
        parent.add_fn(RStrip);
        parent.add_fn(Split);
        parent.add_fn(RegexpSplit);
        parent.add_fn(StartsWith);
        parent.add_fn(Substr);
        parent.add_fn(ToDate);
        parent.add_fn(ToDatetime);
        parent.add_fn(Upper);
    }
}
