<div align="center">
  <picture>
    <source srcset="https://kuzudb.com/img/kuzu-logo-dark.png" media="(prefers-color-scheme: dark)">
    <img src="https://kuzudb.com/img/kuzu-logo.png" height="100" alt="Kuzu Logo">
  </picture>
</div>

<br>

<p align="center">
  <a href="https://github.com/kuzudb/kuzu/actions">
    <img src="https://github.com/kuzudb/kuzu/actions/workflows/ci-workflow.yml/badge.svg?branch=master" alt="Github Actions Badge"></a>
  <a href="https://discord.gg/VtX2gw9Rug">
    <img src="https://img.shields.io/discord/1196510116388806837?logo=discord" alt="discord" /></a>
  <a href="https://twitter.com/kuzudb">
    <img src="https://img.shields.io/badge/follow-@kuzudb-1DA1F2?logo=twitter" alt="twitter"></a>
</p>

# Kuzu
Kuzu is an embedded graph database built for query speed and scalability. Kuzu is optimized for handling complex analytical workloads 
on very large databases and provides a set of retrieval features, such as a full text search and vector indices. Our core feature set includes:

- Flexible Property Graph Data Model and Cypher query language
- Embeddable, serverless integration into applications
- Native full text search and vector index
- Columnar disk-based storage
- Columnar sparse row-based (CSR) adjacency list/join indices
- Vectorized and factorized query processor
- Novel and very fast join algorithms
- Multi-core query parallelism
- Serializable ACID transactions
- Wasm (WebAssembly) bindings for fast, secure execution in the browser

Kuzu is being developed by [Kùzu Inc.](https://kuzudb.com/) and 
is available under a permissible license. So try it out and help us make it better! We welcome your feedback and feature requests.

## Installation

| Language | Installation                                                           |
| -------- |------------------------------------------------------------------------|
| Python   | `pip install kuzu`                                                     |
| NodeJS   | `npm install kuzu`                                                     |
| Rust     | `cargo add kuzu`                                                       |
| Go       | `go get github.com/kuzudb/go-kuzu`                                     |
| Swift    | [kuzu-swift](https://github.com/kuzudb/kuzu-swift)                     |
| Java     | [Maven Central](https://central.sonatype.com/artifact/com.kuzudb/kuzu) |
| C/C++    | [precompiled binaries](https://github.com/kuzudb/kuzu/releases/latest) |
| CLI      | [precompiled binaries](https://github.com/kuzudb/kuzu/releases/latest) |

To learn more about installation, see our [Installation](https://docs.kuzudb.com/installation) page.

## Getting Started

Refer to our [Getting Started](https://docs.kuzudb.com/get-started/) page for your first example.

## Build from Source

You can build from source using the instructions provided in the [developer guide](https://docs.kuzudb.com/developer-guide).

## Contributing
We welcome contributions to Kuzu. If you are interested in contributing to Kuzu, please read our [Contributing Guide](CONTRIBUTING.md).

## License
By contributing to Kuzu, you agree that your contributions will be licensed under the [MIT License](LICENSE).

## Support 
We provide professional support for using Kuzu, ensuring timely responses and flexible coverage. Please visit [here](https://kuzudb.com/#support) 
for more information.

## Contact
You can contact us at [contact@kuzudb.com](mailto:contact@kuzudb.com) or [join our Discord community](https://discord.gg/VtX2gw9Rug).
