#pragma once
#include "binder/bound_statement.h"

namespace kuzu {
namespace binder {

class BoundImportDatabase final : public BoundStatement {
public:
    BoundImportDatabase(std::string filePath, std::string query, std::string indexQuery)
        : BoundStatement{common::StatementType::IMPORT_DATABASE,
              BoundStatementResult::createSingleStringColumnResult()},
          filePath{std::move(filePath)}, query{std::move(query)},
          indexQuery{std::move(indexQuery)} {}

    std::string getFilePath() const { return filePath; }
    std::string getQuery() const { return query; }
    std::string getIndexQuery() const { return indexQuery; }

private:
    std::string filePath;
    // We concatenate queries based on the schema.cypher, copy.cypher, and macro.cypher files
    // generated by exporting the database, resulting in queries such as "create node table xxx;
    // create rel table xxx; copy from xxxx;".
    std::string query;
    std::string indexQuery;
};

} // namespace binder
} // namespace kuzu
