"""

Revision ID: 040b15fba458
Revises: ec25c8fa449f
Create Date: 2025-07-15 09:22:11.456381

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "040b15fba458"
down_revision: Union[str, None] = "ec25c8fa449f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "industryview",
        sa.Column("simple_return", sa.Float(), nullable=True),
        sa.Column("log_return", sa.Float(), nullable=True),
        sa.Column("normalized_close", sa.Float(), nullable=True),
        sa.Column("date", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("created_at", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("industry", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("industry_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("sector", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("type", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("date", "country", "industry", "type"),
    )

    op.drop_table("industryreturns")


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    op.create_table(
        "industryreturns",
        sa.Column("date", sa.VARCHAR(), nullable=False),
        sa.Column("created_at", sa.VARCHAR(), nullable=True),
        sa.Column("simple_return", sa.FLOAT(), nullable=True),
        sa.Column("log_return", sa.FLOAT(), nullable=True),
        sa.Column("country", sa.VARCHAR(), nullable=False),
        sa.Column("industry", sa.VARCHAR(), nullable=False),
        sa.Column("industry_group", sa.VARCHAR(), nullable=True),
        sa.Column("sector", sa.VARCHAR(), nullable=True),
        sa.Column("type", sa.VARCHAR(), nullable=False),
        sa.PrimaryKeyConstraint("date", "country", "industry", "type"),
    )

    op.drop_table("industryview")
    # ### end Alembic commands ###
