"""

Revision ID: 49c83f9eb5ac
Revises: ee5baabb35f8
Create Date: 2025-07-06 07:29:51.181393

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "49c83f9eb5ac"
down_revision: Union[str, None] = "ee5baabb35f8"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("median_rate_of_change_1", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("median_rate_of_change_7_4", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("median_rate_of_change_7_12", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("median_rate_of_change_30", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("rate_of_change_7", sa.Float(), nullable=True))
        batch_op.drop_index(batch_op.f("ix_analysis_rate_of_change_1"))
        batch_op.drop_index(batch_op.f("ix_analysis_rate_of_change_7_12"))
        batch_op.drop_index(batch_op.f("ix_analysis_rate_of_change_7_4"))
        batch_op.create_index(
            "ix_analysis_median_rate_of_change_1",
            ["median_rate_of_change_1"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_median_rate_of_change_30",
            ["median_rate_of_change_30"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_median_rate_of_change_7_12",
            ["median_rate_of_change_7_12"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_median_rate_of_change_7_4",
            ["median_rate_of_change_7_4"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_rate_of_change_7", ["rate_of_change_7"], unique=False
        )
        batch_op.drop_column("rate_of_change_7_4")
        batch_op.drop_column("rate_of_change_7_12")
        batch_op.drop_column("rate_of_change_1")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("rate_of_change_1", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_7_12", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("rate_of_change_7_4", sa.FLOAT(), nullable=True))
        batch_op.drop_index("ix_analysis_rate_of_change_7")
        batch_op.drop_index("ix_analysis_median_rate_of_change_7_4")
        batch_op.drop_index("ix_analysis_median_rate_of_change_7_12")
        batch_op.drop_index("ix_analysis_median_rate_of_change_30")
        batch_op.drop_index("ix_analysis_median_rate_of_change_1")
        batch_op.create_index(
            batch_op.f("ix_analysis_rate_of_change_7_4"),
            ["rate_of_change_7_4"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_analysis_rate_of_change_7_12"),
            ["rate_of_change_7_12"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_analysis_rate_of_change_1"),
            ["rate_of_change_1"],
            unique=False,
        )
        batch_op.drop_column("rate_of_change_7")
        batch_op.drop_column("median_rate_of_change_30")
        batch_op.drop_column("median_rate_of_change_7_12")
        batch_op.drop_column("median_rate_of_change_7_4")
        batch_op.drop_column("median_rate_of_change_1")

    # ### end Alembic commands ###
