"""

Revision ID: 65662e214031
Revises: 660897c02c00
Create Date: 2025-08-20 17:30:47.973725

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "65662e214031"
down_revision: Union[str, None] = "660897c02c00"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("downside", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("oai_moat", sa.Boolean(), nullable=True))
        batch_op.create_index("ix_analysis_downside", ["downside"], unique=False)
        batch_op.create_index("ix_analysis_oai_moat", ["oai_moat"], unique=False)

    with op.batch_alter_table("openai", schema=None) as batch_op:
        batch_op.add_column(sa.Column("moat", sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("openai", schema=None) as batch_op:
        batch_op.drop_column("moat")

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_oai_moat")
        batch_op.drop_index("ix_analysis_downside")
        batch_op.drop_column("oai_moat")
        batch_op.drop_column("downside")

    # ### end Alembic commands ###
