"""

Revision ID: c06dc04e782b
Revises: 048bac60974f
Create Date: 2025-11-14 10:01:56.688468

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "c06dc04e782b"
down_revision: Union[str, None] = "048bac60974f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("price_uptrend", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("sma_uptrend", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("rsi_uptrend", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("macd_12_26_9_uptrend", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_macd_12_26_9_uptrend", ["macd_12_26_9_uptrend"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_price_uptrend", ["price_uptrend"], unique=False
        )
        batch_op.create_index("ix_analysis_rsi_uptrend", ["rsi_uptrend"], unique=False)
        batch_op.create_index("ix_analysis_sma_uptrend", ["sma_uptrend"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_sma_uptrend")
        batch_op.drop_index("ix_analysis_rsi_uptrend")
        batch_op.drop_index("ix_analysis_price_uptrend")
        batch_op.drop_index("ix_analysis_macd_12_26_9_uptrend")
        batch_op.drop_column("macd_12_26_9_uptrend")
        batch_op.drop_column("rsi_uptrend")
        batch_op.drop_column("sma_uptrend")
        batch_op.drop_column("price_uptrend")

    # ### end Alembic commands ###
