"""

Revision ID: d0e58e050845
Revises: ff0cc4ba40ec
Create Date: 2025-08-05 14:02:54.407561

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "d0e58e050845"
down_revision: Union[str, None] = "ff0cc4ba40ec"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("next_earnings_date", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_next_earnings_date", ["next_earnings_date"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_next_earnings_date")
        batch_op.drop_column("next_earnings_date")

    # ### end Alembic commands ###
