(define (domain matching_bw_typed)
(:requirements :typing)
(:types block hand)
(:predicates (hand_positive ?h - hand)
             (hand_negative ?h - hand)
             (block_positive ?b - block)
             (block_negative ?b - block)
             (clear ?b - block)
             (on_table ?b - block)
             (empty ?h - hand)
             (holding ?h - hand ?b - block)
             (on ?b1 ?b2 - block)
	     (solid ?b - block))
(:action pickup
  :parameters (?h - hand ?b - block)
  :precondition (and (clear ?b) (on_table ?b) (empty ?h))
  :effect (and (holding ?h ?b) (not (on_table ?b)) (not (clear ?b))
               (not (empty ?h))))
(:action putdown_pos_pos
  :parameters  (?h - hand ?b - block)
  :precondition (and (holding ?h ?b) (hand_positive ?h) (block_positive ?b))
  :effect (and (empty ?h) (on_table ?b) (clear ?b)
               (not (holding ?h ?b))))
(:action putdown_neg_neg
  :parameters  (?h - hand ?b - block)
  :precondition (and (holding ?h ?b) (hand_negative ?h) (block_negative ?b))
  :effect (and (empty ?h) (on_table ?b) (clear ?b)
               (not (holding ?h ?b))))
(:action putdown_pos_neg
  :parameters  (?h - hand ?b - block)
  :precondition (and (holding ?h ?b) (hand_positive ?h) (block_negative ?b))
  :effect (and (empty ?h) (on_table ?b) (clear ?b) (not (solid ?b)) 
               (not (holding ?h ?b))))
(:action putdown_neg_pos
  :parameters  (?h - hand ?b - block)
  :precondition (and (holding ?h ?b) (hand_negative ?h) (block_positive ?b))
  :effect (and (empty ?h) (on_table ?b) (not (solid ?b)) (clear ?b)
               (not (holding ?h ?b))))
(:action stack_pos_pos
  :parameters  (?h - hand ?b ?underb - block)
  :precondition (and (clear ?underb) (solid ?underb) (holding ?h ?b) (hand_positive ?h) (block_positive ?b))
  :effect (and (empty ?h) (on ?b ?underb) (clear ?b)
               (not (clear ?underb)) (not (holding ?h ?b))))
(:action stack_neg_neg
  :parameters  (?h - hand ?b ?underb - block)
  :precondition (and (clear ?underb) (solid ?underb) (holding ?h ?b) (hand_negative ?h) (block_negative ?b))
  :effect (and (empty ?h) (on ?b ?underb) (clear ?b)
               (not (clear ?underb)) (not (holding ?h ?b))))
(:action stack_pos_neg
  :parameters  (?h - hand ?b ?underb - block)
  :precondition (and (clear ?underb) (solid ?underb) (holding ?h ?b) (hand_positive ?h) (block_negative ?b))
  :effect (and (empty ?h) (on ?b ?underb) (not (solid ?b)) (clear ?b)
               (not (clear ?underb)) (not (holding ?h ?b))))
(:action stack_neg_pos
  :parameters  (?h - hand ?b ?underb - block)
  :precondition (and (clear ?underb) (solid ?underb) (holding ?h ?b) (hand_negative ?h) (block_positive ?b))
  :effect (and (empty ?h) (on ?b ?underb) (not (solid ?b)) (clear ?b)
               (not (clear ?underb)) (not (holding ?h ?b))))

(:action unstack
  :parameters  (?h - hand ?b ?underb - block)
  :precondition (and (on ?b ?underb) (clear ?b) (empty ?h))
  :effect (and (holding ?h ?b) (clear ?underb) (not (clear ?b))
               (not (on ?b ?underb)) (not (empty ?h)))))
